const jwt = require('jsonwebtoken');
const config = require('config');
const hash = require('utils/hash');
const _ = require('lodash');
const mongoose = require('mongoose');
const Stat = require('db/mongo/stat');
const cron = require('cron');
const CronJob = cron.CronJob;
const RequestData = require('db/mongo/requestdata');
const CowRequestdata = require('db/mongolog/cowrequestdata');
const ShopRequestdata = require('db/mongolog/shoprequestdata');
const op = require('../db/op');
const xlsx = require('node-xlsx');
const moment = require('moment');
const fs = require('fs');
const pluginMap = {
    '1': '转盘',
    '2': '危机一发',
    '3': '宝箱',
    '4': '找茬',
    '5': '运势',
    '6': '答题',
    '7': '金蛋',
    '8': '猜歌',
    '9': '种树',
    '10': '捞金币',
    '11': '套圈',
    '12': '娃娃机',
    '13': '转盘2',
    '14': '彩球机',
    '15': '刮刮卡',
    '16': '剪羊毛',
    '17': '桃花',
    '18': '福灯',
    '19': '奶牛庄园',
    '20': '奶牛庄园2',
    '21': '果蔬大作战',
    '999': '积分',
    '998': 'bind'
}

const {
    ObjectId
} =  require('mongoose').Types;

const actions = ["init_sdk", "play_video", "ad", "show_yunbao", "active_time", "show_list", "click_yunbao", "enter_plugin", "diversion_opened","diversion_click_download"]


/*const titleMap = {
    init_sdk: 'SDK初始化',
    play_video: '广告按钮点击',
    ad: '广告点击',
    show_yunbao: '浮标展示', 
    active_time: '场景时间', 
    show_list:'抽屉入口展示', 
    click_yunbao: '浮标点击',
    enter_plugin: '场景点击',
    diversion_opened: 'App引流任务打开',
    diversion_click_download: 'App引流任务点击下载'
}*/

const titleMap = {
    init_sdk_pv: 'SDK初始化次数',
    init_sdk_uv: 'SDK初始化人数',
    show_yunbao_pv: '浮标展示次数',
    show_yunbao_uv: '浮标展示人数',
    click_yunbao_pv: '浮标点击次数',
    click_yunbao_uv: '浮标点击人数',
    play_video: '广告按钮点击',
    ad: '广告展示数',
    ad_click_pv: '广告点击次数',
    ad_click_uv: '广告点击人数',
    diversion_opened_pv: 'App引流任务打开次数',
    diversion_opened_uv: 'App引流任务打开人数',
    diversion_click_download_pv: 'App引流任务点击下载次数',
    diversion_click_download_uv: 'App引流任务点击下载人数'
};

const noReactActions = ['enter_plugin','active_time'];



/*(async function() {
    let c = await CowRequestdata.count({});
    console.dir(c);
})()*/

async function calcShop({ qs, sdk_version, channel, appId, package_name, app_name, basicData }, appMap) {
        
        let _qs = {};
        let types = [];

        basicData['sdk_version'] = sdk_version;
        basicData['channel'] = channel;
        basicData['package_name'] = package_name;
        basicData['app_name'] = app_name;
        basicData['appId'] = appId;
        if(appId) {
            basicData['appName'] = appMap[appId];
        }
        let _type = basicData.type || 'detail';
        let yesterDay = { 
            createdAt: { $gte: moment(basicData.date,'YYYYMMDD').add(-1,'days').startOf('day').toDate(), $lt: moment(basicData.date,'YYYYMMDD').add(-1,'days').endOf('day').toDate() }
        }

        if(_type == 'detail') {
            _qs['data.sdk_version'] = (sdk_version === undefined ? { $exists: 0 } : sdk_version);
            _qs['data.channel'] = (channel === undefined ? { $exists: 0 } : channel);
            _qs['data.package_name'] = (package_name === undefined ? { $exists: 0 } : package_name);
            _qs['data.deviceInfo.app_name'] = (app_name === undefined ? { $exists: 0 } : app_name);
        }

        if(_type == 'mask') {
            _qs['data.deviceInfo.app_name'] = (app_name === undefined ? { $exists: 0 } : app_name);
        }

        if(_type == 'channel') {
            _qs['data.channel'] = (channel === undefined ? { $exists: 0 } : channel);
            _qs['data.deviceInfo.app_name'] = (app_name === undefined ? { $exists: 0 } : app_name);
        }

        if(_type == 'appId') {
            _qs['data.appId'] = (appId === undefined ? { $exists: 0 } : appId);
        }

        let query = { ...qs, ..._qs };

        /* 赚积分页面数据统计 */

        // 打开次数
        let get_coin_pv = await ShopRequestdata.count({ ...query, 'data.action': 'get_coin' });
        // 昨日日活
        let get_coin_uv = await ShopRequestdata.distinct('data.deviceInfo.uid', { ...query, 'data.action': 'get_coin' });
        get_coin_uv = get_coin_uv.length;

       
        // 任务1~n分别点击统计

        let missionObj = {};
        let missions = await ShopRequestdata.aggregate([{
            $match: { ...query, 'data.action': 'click_mission' }
        },{
            $group: {
                _id: '$data.missionId',
                count: {
                    $sum: 1
                }
            }
        }]);

        for(let mission of missions) {
            let click_mission_uv = await ShopRequestdata.distinct('data.deviceInfo.uid', { ...query, 'data.action': 'click_mission', 'data.missionId': mission._id });
            missionObj[mission._id] = {
                click_pv: mission.count,
                click_uv: click_mission_uv.length
            };
        }

        // 任务1~n分别统计领奖人数


        let _missions = await ShopRequestdata.aggregate([{
            $match: { ...query, 'data.action': 'get_mission' }
        },{
            $group: {
                _id: '$data.missionId',
                count: {
                    $sum: 1
                }
            }
        }]);

        for(let mission of _missions) {
            let get_mission_uv = await ShopRequestdata.distinct('data.deviceInfo.uid', { ...query, 'data.action': 'get_mission', 'data.missionId': mission._id });
            if(missionObj[mission._id]) missionObj[mission._id]['get_uv'] = get_mission_uv.length;
            else missionObj[mission._id] = {
                get_uv: get_mission_uv.length
            };
        }


        /* 花积分页面 */
        // 打开兑奖页


        // 打开次数
        let cost_coin_pv = await ShopRequestdata.count({ ...query, 'data.action': 'cost_coin' });
        // 打开人数
        let cost_coin_uv = await ShopRequestdata.distinct('data.deviceInfo.uid', { ...query, 'data.action': 'cost_coin' });
        cost_coin_uv = cost_coin_uv.length;



        // 限量兑换领取
        let limit_exchange_pv = await ShopRequestdata.count({ ...query, 'data.action': 'limit_exchange' });
        let limit_exchange_uv = await ShopRequestdata.distinct('data.deviceInfo.uid', { ...query, 'data.action': 'limit_exchange' });
        limit_exchange_uv = limit_exchange_uv.length;


        // 签到有礼 打开人数次数

        let open_sign_pv = await ShopRequestdata.count({ ...query, 'data.action': 'open_sign' });
        let open_sign_uv = await ShopRequestdata.distinct('data.deviceInfo.uid', { ...query, 'data.action': 'open_sign' });
        open_sign_uv = open_sign_uv.length;

        // 签到有礼 签到人数

        let sign_uv = await ShopRequestdata.distinct('data.deviceInfo.uid', { ...query, 'data.action': 'sign' });
        sign_uv = sign_uv.length;
        
        // 云币抽奖 抽奖次数人数

        let lottery_pv = await ShopRequestdata.count({ ...query, 'data.action': 'lottery' });
        let lottery_uv = await ShopRequestdata.distinct('data.deviceInfo.uid', { ...query, 'data.action': 'lottery' });
        lottery_uv = lottery_uv.length;

        // 精品卡券 兑换人数次数

        let card_exchange_pv = await ShopRequestdata.count({ ...query, 'data.action': 'card_exchange' });
        let card_exchange_uv = await ShopRequestdata.distinct('data.deviceInfo.uid', { ...query, 'data.action': 'card_exchange' });
        card_exchange_uv = card_exchange_uv.length;

        let shop_data = {
            get_coin_pv,
            get_coin_uv,
            missionObj,
            cost_coin_pv,
            cost_coin_uv,
            limit_exchange_pv,
            limit_exchange_uv,
            open_sign_pv,
            open_sign_uv,
            sign_uv,
            lottery_pv,
            lottery_uv,
            card_exchange_pv,
            card_exchange_uv
        }

        let data = {
            ...basicData,
            shop_data
        };
        console.dir(data);
        let existStat = await Stat.findOne(basicData);
        if(existStat) await Stat.update(basicData, {
            $set: {
               shop_data
            }
        });
        else { 
            let rep = await new Stat(data).save();
            console.dir(rep);
        } 
}


async function calcCow({ qs, sdk_version, channel, appId, package_name, app_name, basicData }, appMap) {
        
        let _qs = {};
        let types = [];

        basicData['sdk_version'] = sdk_version;
        basicData['channel'] = channel;
        basicData['package_name'] = package_name;
        basicData['app_name'] = app_name;
        basicData['appId'] = appId;
        if(appId) {
            basicData['appName'] = appMap[appId];
        }
        let _type = basicData.type || 'detail';
        let yesterDay = { 
            createdAt: { $gte: moment(basicData.date,'YYYYMMDD').add(-1,'days').startOf('day').toDate(), $lt: moment(basicData.date,'YYYYMMDD').add(-1,'days').endOf('day').toDate() }
        }

        if(_type == 'detail') {
            _qs['data.sdk_version'] = (sdk_version === undefined ? { $exists: 0 } : sdk_version);
            _qs['data.channel'] = (channel === undefined ? { $exists: 0 } : channel);
            _qs['data.package_name'] = (package_name === undefined ? { $exists: 0 } : package_name);
            _qs['data.deviceInfo.app_name'] = (app_name === undefined ? { $exists: 0 } : app_name);
        }

        if(_type == 'mask') {
            _qs['data.deviceInfo.app_name'] = (app_name === undefined ? { $exists: 0 } : app_name);
        }

        if(_type == 'channel') {
            _qs['data.channel'] = (channel === undefined ? { $exists: 0 } : channel);
            _qs['data.deviceInfo.app_name'] = (app_name === undefined ? { $exists: 0 } : app_name);
        }

        if(_type == 'appId') {
            _qs['data.appId'] = (appId === undefined ? { $exists: 0 } : appId);
        }

        let query = { ...qs, ..._qs };

        // 日活人数
        //let active_pv = await CowRequestdata.count({ ...query });
        //console.dir(`init_sdk_pv,${init_sdk_pv}`);
        let active_uv = await CowRequestdata.distinct('data.deviceInfo.uid', { ...query });
        // 昨日日活
        let last_active_uv = await CowRequestdata.distinct('data.deviceInfo.uid', { ...query, ...yesterDay })
        let c = 0;
        if(active_uv && active_uv.length && last_active_uv && last_active_uv.length)
        for ( let uid of active_uv) {
            c += (last_active_uv.indexOf(uid) >= 0 ? 1: 0);
        }

        let left = c;

        active_uv = active_uv.length;
        last_active_uv = last_active_uv.length;

        // 投喂次数
        let feed_pv = await  CowRequestdata.count({ ...query, 'data.action': 'feed' });
        //投喂人数
        let feed_uv = await  CowRequestdata.distinct('data.deviceInfo.uid', { ...query, 'data.action': 'feed' });

        feed_uv = feed_uv.length;
        // 各项任务
        let missionObj = {};
        for(let x of [1,2,3,4]) {
            let action = `mission_${x}`;
            let s  = await CowRequestdata.distinct('data.deviceInfo.uid', { ...query, 'data.action': action });
            missionObj[action + '_uv'] = s.length;
        }
        // 许愿池广告展示
        let wish_show_pv = await  CowRequestdata.count({ ...query, 'data.action': 'wish_show' });
        //console.dir(wish_show_pv);
        // 许愿池广告点击
        let wish_click_pv = await  CowRequestdata.count({ ...query, 'data.action': 'wish_click' });
        // 小熊猫展示
        let panda_show_pv = await  CowRequestdata.count({ ...query, 'data.action': 'panda_show' });
        // console.dir(panda_show_pv);
        // 小熊猫点击
        let panda_click_pv = await  CowRequestdata.count({ ...query, 'data.action': 'panda_click' });
        // console.dir(panda_click_pv);
        // 广告推销展示
        let adman_show_pv = await  CowRequestdata.count({ ...query, 'data.action': 'adman_show' });
        // console.dir(adman_show_pv);
        // 广告推销点击
        let adman_click_pv = await  CowRequestdata.count({ ...query, 'data.action': 'adman_click' });
        // console.dir(adman_click_pv);
        let plugin_data_more = {
            active_uv,
            feed_pv,
            feed_uv,
            ...missionObj,
            wish_show_pv,
            wish_click_pv,
            panda_show_pv,
            panda_click_pv,
            adman_show_pv,
            adman_click_pv,
            last_active_uv,
            left
        }
        let data = {
            ...basicData,
            plugin_data_more
        };
        let existStat = await Stat.findOne(basicData);
        if(existStat) await Stat.update(basicData, {
            $set: {
               plugin_data_more 
            }
        });
        else { 
            let rep = await new Stat(data).save();
            console.dir(rep);
        }
}

async function calc({ qs, sdk_version, channel, appId, package_name, app_name, basicData, reactActions }, appMap) {
        let _qs = {};
        let types = [];
        basicData['sdk_version'] = sdk_version;
        basicData['channel'] = channel;
        basicData['package_name'] = package_name;
        basicData['app_name'] = app_name;
        basicData['appId'] = appId;
        if(appId) {
            console.log(appMap[appId] + '==========>')
            basicData['appName'] = appMap[appId];
        }
        let _type = basicData.type || 'detail';

        if(_type == 'detail') {
            _qs['data.sdk_version'] = (sdk_version === undefined ? { $exists: 0 } : sdk_version);
            _qs['data.channel'] = (channel === undefined ? { $exists: 0 } : channel);
            _qs['data.package_name'] = (package_name === undefined ? { $exists: 0 } : package_name);
            _qs['data.deviceInfo.app_name'] = (app_name === undefined ? { $exists: 0 } : app_name);
        }

        if(_type == 'mask') {
            _qs['data.deviceInfo.app_name'] = (app_name === undefined ? { $exists: 0 } : app_name);
        }

        if(_type == 'channel') {
            _qs['data.channel'] = (channel === undefined ? { $exists: 0 } : channel);
            _qs['data.deviceInfo.app_name'] = (app_name === undefined ? { $exists: 0 } : app_name);
        }

        if(_type == 'appId') {
            _qs['data.appId'] = (appId === undefined ? { $exists: 0 } : appId);
        }

        let query = { ...qs, ..._qs };
        //console.dir(query);
        //console.dir('基础条件');
        //console.dir(query);

        // init_sdk SDK初始化
        //console.dir({ ...query, 'data.action': 'init_sdk'});
        let init_sdk_pv = await RequestData.count({ ...query, 'data.action': 'init_sdk' });
        //console.dir(`init_sdk_pv,${init_sdk_pv}`);
        let init_sdk_uv = await RequestData.aggregate([{
            $match: { ...query, 'data.action': 'init_sdk' }
        },{
            $group: {
                _id: '$data.deviceInfo.uid',
                count: {
                    $sum: 1
                }
            }
        }]);

        //console.dir(`init_sdk_uv,${init_sdk_uv.length}`);
        init_sdk_uv = init_sdk_uv.length;

        // show_yunbao 浮标
        let show_yunbao_pv = await RequestData.count({ ...query, 'data.action': 'show_yunbao' });
        //console.dir(`show_yunbao_pv,${show_yunbao_pv}`);
        let show_yunbao_uv = await RequestData.distinct('data.deviceInfo.uid', { ...query, 'data.action': 'show_yunbao' });
        

        //console.dir(`show_yunbao_uv,${show_yunbao_uv.length}`);
        show_yunbao_uv = show_yunbao_uv.length;
        // click_yunbao 浮标点击

        let click_yunbao_pv = await RequestData.count({ ...query, 'data.action': 'click_yunbao' });
        //console.dir(`click_yunbao_pv,${click_yunbao_pv}`);
        let click_yunbao_uv = await RequestData.distinct('data.deviceInfo.uid', { ...query, 'data.action': 'click_yunbao' });
        //console.dir(`click_yunbao_uv,${click_yunbao_uv.length}`);
        click_yunbao_uv = click_yunbao_uv.length;


        // play_video 广告按钮
        let play_video = await RequestData.count({ ...query, 'data.action': 'play_video' });
        //console.dir(`play_video,${play_video}`);

         // ad   广告填充
        let ad = await RequestData.count({ ...query, 'data.action': 'ad', 'data.adCallback': 'onVideoPlayStart' });
        //console.dir(`ad,${ad}`);


        // onAdClicked 广告点击
        let ad_click_pv = await RequestData.count({ ...query, 'data.action': 'ad', 'data.adCallback': 'onAdClicked' });
        //console.dir(`ad_click_pv,${ad_click_pv}`);
        let ad_click_uv = await RequestData.distinct('data.deviceInfo.uid', { ...query, 'data.action': 'ad', 'data.adCallback': 'onAdClicked' });
        //console.dir(`ad_click_uv,${ad_click_uv.length}`);

        ad_click_uv = ad_click_uv.length;
        


        // show_list  抽屉入口展示
        let show_list_pv = await RequestData.count({ ...query, 'data.action': 'show_list' });
        //console.dir(`show_list_pv,${show_list_pv}`);
        let show_list_uv = await RequestData.distinct('data.deviceInfo.uid',{ ...query, 'data.action': 'show_list' });
        //console.dir(`show_list_uv,${show_list_uv.length}`);

        show_list_uv = show_list_uv.length;


        let plugin_data = {};


        // enter_plugin 场景点击
        let enter_plugin_pvs = await RequestData.aggregate([{
            $match: {
                ...query,
                //'data.pluginId': {  $exists:1   },
                'data.action': "enter_plugin"
            }
        },
        {    
            $group: {
                _id: '$data.pluginId',
                count: {
                    $sum: 1
                }
            }
        }]);

        for(let enter_obj of enter_plugin_pvs) {
            plugin_data[`pluginId_${enter_obj._id}`] = { 
                pluginId: enter_obj._id,
                enter_plugin_pv: enter_obj.count 
            };
        }


        //console.dir(`enter_plugin_pv`);
        ////console.dir(plugin_data);

        for(let key of Object.keys(plugin_data)) {
            let pluginId = plugin_data[key].pluginId;
            let enter_plugin_uv = await RequestData.distinct('data.deviceInfo.uid',{ ...query, 'data.action': 'enter_plugin', 'data.pluginId': pluginId });
            plugin_data[key]['enter_plugin_uv'] = enter_plugin_uv.length;
            // react 互动统计
            let plugin_react_uv = await RequestData.distinct('data.deviceInfo.uid',{ ...query, 'data.action': { $in: reactActions }, 'data.pluginId': pluginId });
            plugin_data[key]['plugin_react_uv'] = plugin_react_uv.length;


            // 广告展示
            let ad_show = await RequestData.count({ ...query, 'data.action': 'ad','data.adCallback':'onVideoPlayStart', 'data.pluginId': pluginId });
            plugin_data[key]['ad_show'] = ad_show;

            // 广告点击
            let ad_click = await RequestData.count({ ...query, 'data.action': 'ad','data.adCallback':'onAdClicked', 'data.pluginId': pluginId });
            plugin_data[key]['ad_click'] = ad_click;
        }

        //console.dir(`enter_plugin_uv`);
        ////console.dir(plugin_data);


        // active_time 场景时间
        let active_time = await RequestData.aggregate([{
            $match: {
                ...query,
               'data.action' : "active_time"
            }
        },
        {
            $group: {   
                _id: '$data.pluginId',
                count: {
                    $sum: 1
                },
                sum: {
                    $sum: '$data.rtime'
                }
            }
        }]);

        for(let obj of active_time) {
            let key = `pluginId_${obj._id}`;
            let average = (obj.count == 0 ? '0.00' : (obj.sum / obj.count).toFixed(2));
            if(plugin_data[key]) {
                plugin_data[key]['active_time'] = average;
            } else plugin_data[key] = {
                active_time: average
            }
        }

        //console.dir(`active_time`);
        ////console.dir(plugin_data);

        // diversion_opened App引流任务打开

        let diversion_opened_pv = await RequestData.count({ ...query, 'data.action': 'diversion_opened' });
        //console.dir(`diversion_opened_pv,${diversion_opened_pv}`);
        diversion_opened_pv = diversion_opened_pv || 0;
        let diversion_opened_uv = await RequestData.distinct('data.deviceInfo.uid',{ ...query, 'data.action': 'diversion_opened' });
        //console.dir(`diversion_opened_uv,${diversion_opened_uv.length}`);
        diversion_opened_uv = diversion_opened_uv.length;

        // diversion_click_download App引流任务点击下载

        let diversion_click_download_pv = await RequestData.count({ ...query, 'data.action': 'diversion_click_download' });
        //console.dir(`diversion_click_download_pv,${diversion_click_download_pv}`);
        diversion_click_download_pv = diversion_click_download_pv || 0;
        let diversion_click_download_uv = await RequestData.distinct('data.deviceInfo.uid',{ ...query, 'data.action': 'diversion_click_download' });
        //console.dir(`diversion_click_download_uv,${diversion_click_download_uv.length}`);
        diversion_click_download_uv = diversion_click_download_uv.length

        let data = {
            ...basicData,
            detail: {
                init_sdk_pv,
                show_list_pv,
                show_list_uv,
                init_sdk_uv,
                show_yunbao_pv,
                show_yunbao_uv,
                click_yunbao_pv,
                click_yunbao_uv,
                play_video,
                ad,
                ad_click_pv,
                ad_click_uv,
                diversion_opened_pv,
                diversion_opened_uv,
                diversion_click_download_pv,
                diversion_click_download_uv  
            },
            plugin_data
        }
        console.dir(basicData);
        let existStat = await Stat.findOne(basicData);
        if(existStat) await Stat.remove(basicData);
        let rep = await new Stat(data).save();
        console.dir(rep._id + '');
}

async function handle(date,os,type) {
    //let dateString = date;
    let [start,end] = [moment(date,'YYYYMMDD').startOf('day').toDate(),moment(date,'YYYYMMDD').endOf('day').toDate()];
    let osQuery = (os == 'android' ? { 'data.osType': { $in: ['1','3'] } } : { 'data.osType': { $in:['2','4'] } });
    let qs = { date, ...osQuery };
    let cowqs = { createdAt: { $gte: start, $lt: end }, ...osQuery };
    let basicData = { date, osType: os };
    if(type) basicData['type'] = type;

    // 获取场景action
    let reactActions = await RequestData.distinct("data.action", { 'data.pluginId': {$exists:1}, ...qs });

    reactActions = reactActions.filter( x => {
        return noReactActions.indexOf(x) == -1
    });
    //console.dir(reactActions);

    let appMap = await getAppMap();
    //console.dir(appMap);
    if(type == 'all') {
        await calc({  qs, reactActions, basicData });
        await calcCow({ qs: cowqs, basicData });
        await calcShop({ qs: cowqs, basicData });
    }  else {
        let _id = {
            'sdk_version': '$data.sdk_version',
            'channel': '$data.channel',
            'package_name': '$data.package_name',
            'app_name': '$data.deviceInfo.app_name'
        }
        if(type == 'mask') {
            _id = {
                'app_name': '$data.deviceInfo.app_name'
            }
        }
        if(type == 'channel') {
             _id = {
                'app_name': '$data.deviceInfo.app_name',
                'channel': '$data.channel'
            } 
        }

        if(type == 'appId') {
             _id = {
                'appId': '$data.appId'
            } 
        }
        //console.dir(_id);
        let basics =  await RequestData.aggregate([{
            $match: qs
        },{
            $group: {
                _id,
                count: {
                    $sum: 1
                }
            }
        }]);
        
        for(let q of basics) {
            let { sdk_version, channel, package_name, app_name, appId } = q._id;
            await calc({  sdk_version, channel, package_name, app_name, appId, qs, reactActions, basicData }, appMap);
            await calcCow({  sdk_version, channel, package_name, app_name, appId, qs: cowqs, basicData }, appMap);
            await calcShop({  sdk_version, channel, package_name, app_name, appId, qs: cowqs, basicData }, appMap);
        } 
    }
}

/*async function fix() {
    let a = await RequestData.find({ 'data.action':"active_time" });
    for(let obj of a) {
        //console.dir(obj.time);
        obj.time = parseInt(obj.time) || 0;
        //console.dir(obj.time);
        await obj.save();
    }
}*/

/*(async function() {
    let dates = ['20210317','20210318','20210319','20210320','20210321','20210322','20210323','20210324','20210325','20210326','20210327','20210328','20210329','20210330','20210331','20210401','20210402','20210403','20210404','20210405','20210406','20210407','20210408'].reverse();
    for(let i = 0;i <= 15;i++) {
        dates.push(moment().add(i - 16,'days').format('YYYYMMDD'));
    }
    for(let date of dates) {
        let [start,end] = [moment(date,'YYYYMMDD').startOf('day').format('x'),moment(date,'YYYYMMDD').endOf('day').format('x')];
        let qs = { 'nginxTime': { $gt: parseInt(start), $lte: parseInt(end) }};
        //console.dir(date)
        let c = await RequestData.count(qs);
        if(c) await RequestData.update(qs,{
            $set: { date }
        },{multi: 1});
        //console.dir(c)
    }
})()*/

async function getAppMap() {
    let apps = await op.query('SELECT * FROM app');
    let map = {};
    for(let app of apps) {
        map[app.id] = app.name;
    }
    return map;
}



/*async function run(dates) {
    dates = dates.reverse();
    let osTypes = ['android','ios'];
    for(let date of dates) {
        for(let osType of osTypes) {
            console.log("获取appId" + date)
            await handle(date, osType, 'appId');
            console.log("获取channel" + date)
            await handle(date, osType, 'channel');
            console.log("获取detail" + date)
            await handle(date, osType);
            console.log("获取mask" + date)
            await handle(date, osType, 'mask');
            console.log("获取all" + date)
            await handle(date, osType, 'all');
        }
    }
}*/


/*
(async function() {
    let dates = ['20210622'].reverse();
    let osTypes = ['android','ios'];
    for(let date of dates) {
        for(let osType of osTypes) {
            console.log("获取appId" + date);
            await handle(date, osType, 'appId');
            console.log("获取channel" + date);
            await handle(date, osType, 'channel');
            console.log("获取detail" + date);
            await handle(date, osType);
            console.log("获取mask" + date);
            await handle(date, osType, 'mask');
            console.log("获取all" + date);
            await handle(date, osType, 'all');
        }
    }
})()*/


/*(async function() {
    let dates = ['20210622'];
    for(let date of dates) {
        let datas = await RequestData.find({ date, 'data.action': 'active_time' });
        let c = 0;
        for(let d of datas) {
            if(d.data && d.data.time && typeof d.data.time == 'string' ) {
                 console.dir(typeof d.data.time)
                 console.dir(typeof parseInt(d.data.time || 0))
                 d.data = {
                    ...d.data,
                    rtime: parseInt(d.data.time || 0)
                 }
                 await d.save();
            }
            console.dir(datas.length + '___' + (c++))
        }
        console.dir('done' + date);
    }
})()*/

/*setInterval(async () => {
    let dates = moment().format('YYYYMMDD');
    console.log(dates);
    await run(dates);
}, 1000 * 60 * 60);*/


const job = new CronJob({
  cronTime: '00 00 05 * * 0-6',
  onTick: async function() {
    let date = moment().add(-1, 'days').format('YYYYMMDD');
    let osTypes = ['android','ios'];
    for(let osType of osTypes) {
        console.log("获取appId" + date);
        await handle(date, osType, 'appId');
        console.log("获取channel" + date);
        await handle(date, osType, 'channel');
        console.log("获取detail" + date);
        await handle(date, osType);
        console.log("获取mask" + date);
        await handle(date, osType, 'mask');
        console.log("获取all" + date);
        await handle(date, osType, 'all');
    }
  },
  start: false,
});
job.start();


exports.selects = async(ctx, next) => {
    let apps = await Stat.distinct('app_name',{});
    let appNames = await Stat.distinct('appName',{});
    //console.dir(apps);
    
    ctx.body = {
        status: 'ok',
        data: {
            apps,
            appNames,
            osTypes: ['android','ios'],
            plugins: Object.keys(pluginMap).map( x => {
               return {
                key: x, name: pluginMap[x]
               }   
            })
        }
    }
}

exports.list = async(ctx, next) => {
    let {
        app_name,
        osType,
        keyword,
        type,
        start,
        end,
        skip=0,
        limit=100
    } = ctx.request.body;
    let query = {};
    console.dir(ctx.request.body);
    if(type == 'mask' || type == 'all' ||  type == 'channel' ||  type == 'appId') {
        query['type'] = type;
    } else query['type'] = { $nin: ['mask','all','channel','appId'] };

    if(start && end) {
        query['date'] = { $gte: start, $lte: end };
    }
    if(osType && osType !== 'all') {
         query['osType'] = osType;
    }
    if(app_name && app_name !== 'all') {
        if(type == 'appId') query['appName'] = app_name; 
        else query['app_name'] = app_name;
    }

    if(keyword && keyword.length) {
        query['$or'] = [
            { app_name: { $regex: new RegExp(keyword) } },
            { package_name: { $regex: new RegExp(keyword) } },
            { channel: { $regex: new RegExp(keyword) } },
            { appName: { $regex: new RegExp(keyword) } }
        ] 
    }

    let total  = await Stat.count(query);
    let stats  = await Stat.find(query, null, {
        skip: parseInt(skip) * parseInt(limit),
        limit
    }).sort({
        date: -1
    });

    ctx.body = {
        status: 'ok',
        stats,
        total,
        limit,
        skip 
    };
};