const fs = require("fs");
const path = require('path');
const readline = require('readline');
const moment = require('moment');
const compressing = require('compressing');
const elasticsearch= require('elasticsearch');
const FileData = require('../db/mongo/file');
const RequestData = require('../db/mongo/requestdata');
const child_process = require('child_process');
const { ESHOST } = require('../config');
const client = new elasticsearch.Client({
  host: ESHOST,
  log: 'trace',
  apiVersion: '7.x', // use the same version of your Elasticsearch instance
});
let doing = false;

function decodeNginxLog(c) {
	let r = '';
	for (let i = 0; i < c.length;) {
		if (c[i] === '\\' && c[i + 1] === 'x') {
			let j = i;
			let hexList = [];
			while(true) {
				if (c[j] === '\\' && c[j + 1] === 'x') {
					hexList.push(c[j + 2]);
					hexList.push(c[j + 3]);
				} else {
					break;
				}
				j += 4;
			}
			r += Buffer.from(hexList.join(''), 'hex').toString('utf8');
			i = j;
		} else{
			r += c[i];
			i++;
		}
	}
	return r;
}


async function decompress(fileName) {
	return new Promise(function(resolve,reject) {
		compressing.gzip.uncompress(fileName, `${fileName}.txt`)
		  .then(() => {
		    resolve(`${fileName}.txt`);
		  })
		  .catch(err => {
		  	console.error(err);
		  	reject(err);
		  });
	})
}



function stringToBase64(str){
    var base64Str = new Buffer(str).toString('base64');
    return base64Str;
}

function base64ToString(base64Str){
    var str = new Buffer(base64Str,'base64').toString();
    return str;
}


async function parseFile(fileName) {
	let count = 0;
	let filedata = await FileData.findOne({ filename: fileName });
	if(filedata) {
		return null;
	} else console.dir('parseFile 开始处理');
	let fReadName = await decompress(fileName);
	let id = await child_process.execSync('wc -l ' + fReadName + "| awk '{print $1}'");
	let num = parseInt(id.toString().trim());
	return new Promise(function(resolve,reject) {
		const fRead = fs.createReadStream(fReadName);
		const objReadline = readline.createInterface({
			input: fRead
		});
		objReadline.on('line', async (line, linecount) => {
			count++;
			if(line.indexOf('/Log/logdata')>=0 || line.indexOf('setting?h5Type=')>=0 || line.indexOf('/plugin/config')>=0) {
				let time_string = line.split("[")[1].split("]")[0].split(" ")[0];
				let time = moment(time_string,'DD/MMM/YYYY:HH:mm:ss').format('x')
				
				let info = decodeNginxLog(line).split('request_body:')[1].trim();
				let data = {};

				if(info.indexOf('resp_body') >= 0) info = info.split('resp_body')[0].trim();
				if(info.indexOf('{') >=0) {
					info = JSON.parse(info);
					let data = {};
					if(info.encryption) {
						delete info.encryption;
						for(let k in info) {
							 let key = base64ToString(k);
							 data[key] = base64ToString(decodeURIComponent(info[k]));
						}
						data['encryption'] = 1;
						info = data;
					}

					if(info.deviceInfo && info.deviceInfo.indexOf('{') >=0) {
						info.deviceInfo = JSON.parse(decodeURIComponent(info.deviceInfo));
					}
					
				} else info = null;

				if(info && line.indexOf('/plugin/config') >= 0) {
					if((info.sdk_version && info.sdk_version <= '1.2.1') || info.sdk_version == '1.2.3') { info.action = 'show_yunbao'; }
					else info = null;
				} 

				if(info && line.indexOf('setting?h5Type=') >= 0  ) {  
					if(info.sdk_version && info.sdk_version <= '1.1.5') {
						let pluginId = line.split('setting?h5Type=')[1].split('&')[0];
						if(pluginId && pluginId.length) {
							info.action = 'enter_plugin';
							info.pluginId = parseInt(pluginId);
						}
					} else info = null;
					
				}
				if(info) {
					/*await client.create({
					  index: 'xiaoyunssp',
					  id:  Date.now() + '_' + Math.random().toString(36).substr(2) + '_' + info.action,
					  type: 'log',
					  body: info
					});*/
					if(info.action == 'ad' && info.appId='52P455VrhbIVFIeaLS9DwL56XzMNPEAn')
					fs.appendFile('./log.txt', JSON.stringify(info), (err) => {
					  if (err) throw err;
					  console.log('数据已被追加到文件');
					});
					console.dir(info);
					let rep = await new RequestData({
						nginxTime: time,
						filename: fileName,
						data: info
					}).save();
					if(num <= count) {
						console.dir('done' + count);
						resolve({ count })
					}
				}
			}
		});
		objReadline.on('close', ()=>{
			console.dir('close done==============');
			
		});
    })
}


const sleep = function (ms){
  return new Promise(resolve => setTimeout(resolve, ms))
}


const check = async  (entry) => {
	if(doing) {
		console.log('执行中');
		return;
	} else {
		if(entry.indexOf('.txt') >=0 || entry.indexOf('ui.') >=0 || entry.indexOf('.gz') == -1) { 
			console.log('格式错误');
			return; 
		}
		doing = true;
		console.log('开始处理' + entry);
		let rep = await parseFile(entry);
		console.log('处理完成' + entry);
		doing = false;
		return rep;
	}
}


const getInfo = async (entry) => {
	const dirInfo = fs.readdirSync(entry);
	for(let item of dirInfo) {
		const location = path.join(entry,item);
		const info = fs.statSync(location);
		if(info.isDirectory()) {
			await getInfo(location);
		} else {
			if(doing) {
				break;
			}
			let rep = await check(location);
			if(rep) {
				await new FileData({
					filename: location,
					lines: rep ? rep.count : 0
				}).save();
				await child_process.execSync(`rm ${location}.txt`);
				console.dir("处理" + location)
			} else { console.dir('没处理' + location) }
			
		}
	}
}


exports.getInfo = getInfo;

