const express = require('express');
const path = require('path');
const send = require('send');
const parseUrl = require('parseurl')
const bodyParser = require('body-parser')
const app = express();
const port = 8786;
const pagePaths = ['','/','/stat','/login']



app.use(bodyParser.urlencoded({ extended: false }))
app.use(bodyParser.json())


// 页面渲染
app.get('/umi.css',(req,res) => {
	let stream = send(req, path.join(__dirname, './dist/umi.css'), {});
    stream.pipe(res);
});

app.get('/umi.js',(req,res) => {
	let stream = send(req, path.join(__dirname, './dist/umi.js'), {});
    stream.pipe(res);
});

app.use((req, res, next) => {
	console.dir(req.url)
	let dir = (req.hostname || '').split('.')[0];
	let originalUrl = parseUrl.original(req);
	let _path = parseUrl(req).pathname
	if (_path === '/' && originalUrl.pathname.substr(-1) !== '/') {
      _path = ''
    }
    if(pagePaths.indexOf(_path) >= 0) {
    	let stream = send(req, path.join(__dirname, './dist/index.html'), {});
    	stream.pipe(res);
    } else next();
});

app.listen(port, () => console.log(`index page app listening on port ${port}!`))