import React, { useState, useEffect, useRef } from 'react';
import styles from './index.less';
import ReactECharts from 'echarts-for-react';
import { Button, Form, Card, Input, Layout, Menu, Select, DatePicker, Table, Radio, message } from 'antd';
import { setToken, delToken, setUserName, delUserName, getUserName } from '../local';
import moment from 'moment';
import {
  MenuUnfoldOutlined,
  MenuFoldOutlined,
  UserOutlined,
  VideoCameraOutlined,
  UploadOutlined,
  DatabaseOutlined,
  FundOutlined
} from '@ant-design/icons';
import * as fn from '../api';

const { Search } = Input;


const pluginMap = {
    '1': '转盘',
    '2': '危机一发',
    '3': '宝箱',
    '4': '找茬',
    '5': '运势',
    '6': '答题',
    '7': '金蛋',
    '8': '猜歌',
    '9': '种树',
    '10': '捞金币',
    '11': '套圈',
    '12': '娃娃机',
    '13': '转盘2',
    '14': '彩球机',
    '15': '刮刮卡',
    '16': '剪羊毛',
    '17': '桃花',
    '18': '福灯',
    '19': '奶牛庄园',
    '20': '奶牛庄园2',
    '21': '果蔬大作战',
    '999': '积分',
    '998': 'bind'
}



const { getSelects, getStats } = fn.default;

const { Header, Sider, Content } = Layout;
const { Option } = Select;
const { RangePicker } = DatePicker;
const dateFormat = 'YYYYMMDD';

const basicOption = {
    title: {
        text: '基础统计'
    },
    tooltip: {
        trigger: 'axis',
        axisPointer: {
            type: 'cross'
        }
    },
    legend: {
        data: ['邮件营销']
    },
    grid: {
        left: '3%',
        right: '4%',
        bottom: '3%',
        containLabel: true
    },
    toolbox: {
        feature: {
            dataView: {show: true, readOnly: false},
            restore: {show: true},
            saveAsImage: {show: true}
        }
    },
    xAxis: {
            type: 'category',
            axisTick: {
                alignWithLabel: true
            },
            data: ['周一', '周二', '周三', '周四', '周五', '周六', '周日']
    },
    yAxis: [
        {
            type: 'value',
            name: '数量',
            min: 0,
            position: 'left',
            axisLabel: {
                formatter: '{value}'
            }
        },
        {
            type: 'value',
            name: '概率',
            min: 0,
            max: 100,
            position: 'right',
            axisLabel: {
                formatter: '{value} %'
            }
        }
    ],
    series: [{
        name: 'sdk加载',
        yAxisIndex: 0,
        type: 'line',
        data: [120, 132, 101, 134, 90, 230, 210]
    }]
}

export default function IndexPage(props) {

  //let defaultPluginData = {};

  let localPlugins = Object.keys(pluginMap).map( x => {
     return {
      key: x, name: pluginMap[x]
     }   
  });
  console.dir(localPlugins);

  let localDefaultPluginData = {};
  localPlugins.forEach( x => {
    localDefaultPluginData[`pluginId_${x.key}`] = {
          "name": x.name,
          "pluginId" : x.key,
          "enter_plugin_pv" : 0,
          "enter_plugin_uv" : 0,
          "plugin_react_uv" : 0,
          "ad_show" : 0,
          "ad_click" : 0,
          "active_time" : "0.00"
    }
  });
  //setDefaultPluginData(defaultPluginData);
  //console.dir(defaultPluginData);
  let scrollX = 1000;
  const [defaultPluginData,setDefaultPluginData] = useState(localDefaultPluginData);
  const [data,setData] = useState(basicOption);
  const [apps,setApps] = useState([]);
  const [appNames,setAppNames] = useState([]);
  const [scene,setScene] = useState('all');
  const [coin,setCoin] = useState('get');
  const [sceneData,setSceneData] = useState([]);
  const [plugins,setPlugins] = useState(localPlugins);
  const [plugin,setPlugin] = useState('all');
  const [headers, setHeaders] = useState([]);
  const [keyword, setKeyWord] = useState('');
  const [dates,setDates] = useState([]);

  //const [scrollX, setScrollX] = useState(1000);


  const [app,setApp] = useState();
  const [osType,setOs] = useState('android');
  const [statData,setStatData] = useState([]);
  const [loading,setLoading] = useState(true);
  const [type,setType] = useState('all');

  const[pagination, setPagination] = useState({
      pageSize: 100,
      current: 0,
      total: 0
  })

  const toggle = () => {
    setCollapsed(!collapsed);
  };



  async function fetchStat(obj, t, pluginId) {
    setLoading(true);
    setStatData([]);
    setSceneData([]);
    let data = await getStats(obj);
    let stats = (data.stats || []).map( x => {
      let detail = x.detail || {
        "init_sdk_pv" : 0,
        "init_sdk_uv" : 0,
        "show_list_pv" : 0,
        "show_list_uv" : 0,
        "show_yunbao_pv" : 0,
        "show_yunbao_uv" : 0,
        "click_yunbao_pv" : 0,
        "click_yunbao_uv" : 0,
        "play_video" : 0,
        "ad" : 0,
        "ad_click_pv" : 0,
        "ad_click_uv" : 0,
        "diversion_opened_pv" : 0,
        "diversion_opened_uv" : 0,
        "diversion_click_download_pv" : 0,
        "diversion_click_download_uv" : 0,
        "active_uv" : 0,
        "feed_pv" : 0,
        "feed_uv" : 0,
        "mission_1_uv" : 0,
        "mission_2_uv" : 0,
        "mission_3_uv" : 0,
        "mission_4_uv" : 0,
        "wish_show_pv" : 0,
        "wish_click_pv" : 0,
        "panda_show_pv" : 0,
        "panda_click_pv" : 0,
        "adman_show_pv" : 6,
        "adman_click_pv" : 0,
        "last_active_uv" : 0,
        "left" : 0
      }

      let plugin_data_more = x.plugin_data_more || {};
      let plugin_data = {};
      
      let shop_data = x.shop_data || {};
      if(shop_data.missionObj) {
        for(let mission of Object.keys(shop_data.missionObj)) {
          shop_data[`mission_` +  mission + '_click_pv'] = shop_data.missionObj[mission].click_pv;
          shop_data[`mission_` +  mission + '_click_uv'] = shop_data.missionObj[mission].click_pv;
          shop_data[`mission_` +  mission + '_get_uv'] = shop_data.missionObj[mission].get_uv;
        }
      }
      delete shop_data.missionObj;
      //let scene_dates = _dates || dates;
      //console.dir(t + '==================111')
      if(t == 'plugin' || scene == 'plugin') {
        let _plugin = pluginId || plugin;
        for(let key of Object.keys(defaultPluginData)) {
          if(_plugin && _plugin!== 'all' && key !== 'pluginId_' + _plugin) continue;
          for(let ik of Object.keys(defaultPluginData[key])) {
            if(ik == 'pluginId' || ik == 'name') continue;
            plugin_data[`${key}_${ik}`] = x.plugin_data && x.plugin_data[key] ?  x.plugin_data[key][ik] :  defaultPluginData[key][ik]
          }
        }  
      }
      console.dir(shop_data);
      return {
        key: x._id,
        date: x.date,
        osType: x.osType,
        sdk_version: x.sdk_version,
        app_name: x.appName || x.app_name,
        channel: x.channel,
        package_name: x.package_name,
        ...detail,
        ...plugin_data,
        ...plugin_data_more,
        ...shop_data
      }
    });

    let scene_data = [];
    console.dir(dates);
    console.dir(plugin);
    console.dir(scene);
    if( obj.start && obj.end && obj.start == obj.end && plugin == 'all' && scene == 'plugin') {
      console.dir('========data====!!!!!!!!!!!!');
      
      for(let d of stats) {
       /* let obj = {
          key: d.key,
          date: d.date,
          osType: d.osType,
          sdk_version: d.sdk_version,
          app_name: d.app_name,
          channel: d.channel,
          package_name: d.package_name,
          show_list_pv: d.show_list_pv,
          show_list_uv: d.show_list_uv
        }*/
        for(let key of Object.keys(defaultPluginData)) {
          console.dir(key + defaultPluginData[key]['name']);
          scene_data.push({
            key: d.key  +  d.date + d.osType + d.sdk_version + d.app_name + d.channel + d.package_name + Math.random().toString(36).substr(2),
            date: d.date,
            osType: d.osType,
            sdk_version: d.sdk_version,
            app_name: d.app_name,
            channel: d.channel,
            package_name: d.package_name,
            show_list_pv: d.show_list_pv,
            show_list_uv: d.show_list_uv,
            name: defaultPluginData[key]['name'],
            enter_plugin_pv: d[`${key}_enter_plugin_pv`] || 0,
            enter_plugin_uv: d[`${key}_enter_plugin_uv`] || 0,
            enter_plugin_rate: (d.show_list_uv == 0 ?  0 : (((d[`${key}_enter_plugin_uv`] || 0) / d.show_list_uv)  * 100)).toFixed(2),
            plugin_react_uv: d[`${key}_plugin_react_uv`] || 0,
            ad_show: d[`${key}_ad_show`] || 0,
            ad_click: d[`${key}_ad_click`] || 0,
            ad_click_rate: ((d[`${key}_ad_show`] || 0) == 0 ? 0 : (((d[`${key}_ad_click`] || 0) / d[`${key}_ad_show`])  * 100)).toFixed(2),
            active_time: d[`${key}_active_time`] || "0.00",
            ...data
          });
        }
      }
      setLoading(false);
      setSceneData(scene_data);
      console.dir(scene_data);
      return;
    }
    setPagination({
      total: data.total,
      pageSize: data.limit,
      current: data.skip + 1
    })
    setLoading(false);
    setStatData(stats);
  }


  async function init() {
    let result = await getSelects();
    setApps(result.data && result.data.apps ? result.data.apps : []);
    setAppNames(result.data && result.data.appNames ? result.data.appNames : []);
    setPlugins(result.data && result.data.plugins ? result.data.plugins: []);
    //console.dir(defaultPluginData);

    fetchStat({  
      type,
      osType,
      app_name: app,
      skip: 0,
      limit: 100
    });
      // setChannels(result.data && result.data.channels ? result.data.channels : []);
  }

  useEffect(() => {

      init();
      setData({
        ...basicOption, 
        legend: {
            data: ['邮件营销']
        }, 
        series:  [
            {
                name: 'sdk加载',
                yAxisIndex: 0,
                type: 'line',
                data: [120, 132, 101, 134, 90, 230, 210]
            }
        ],
        xAxis:{
            type: 'category',
            axisTick: {
                alignWithLabel: true
            },
            data: ['周一', '周二', '周三', '周四', '周五', '周六', '周日']
        }

      });
  }, [])


  const handleTableChange = async (pagination, filters, sorter) => {
    const pager = pagination;
    pager.current = pagination.current;
    setPagination(pager)
    fetchStat({  
      type,
      osType,
      app_name: app,
      skip: pagination.current-1,
      keyword,
      start: dates[0],
      end: dates[1],
      limit: 100
    });
  }


  

  const handleChangeApp = (e) => {
    setApp(e);
    fetchStat({  
      type,
      osType,
      app_name: e,
      keyword,
      start: dates[0],
      end: dates[1],
      skip: 0,
      limit: 100
    });
  }


  const handleChangeosType = (e) => {
    setOs(e);
    fetchStat({  
      type,
      osType: e,
      app_name: app,
      keyword,
      start: dates[0],
      end: dates[1],
      skip: 0,
      limit: 100
    });
  }

  const onChangeCoin = (e) => {
    setCoin(e.target.value);
    console.dir(e.target.value);
  }

  const onChangeScene = (e) => {
  
    setScene(e.target.value);
    console.dir(e.target.value);
    setTimeout(() => {
      fetchStat({  
        type,
        osType,
        app_name: app,
        keyword,
        start: dates[0],
        end: dates[1],
        skip: 0,
        limit: 100
      },e.target.value);
    }, 0);
   
  }

  const handleChangePluginType = (e) => {
    setPlugin(e);
    fetchStat({  
      type,
      osType,
      app_name: app,
      keyword,
      start: dates[0],
      end: dates[1],
      skip: 0,
      limit: 100
    },'plugin', e);
  }

  const onSearch = (e) => {
    setKeyWord(e);
    fetchStat({  
      type,
      osType,
      keyword: e,
      app_name: app,
      start: dates[0],
      end: dates[1],
      skip: 0,
      limit: 100
    },'plugin', e);
    console.dir(e);
  }

  const onChange = (e) => {
    setType(e.target.value);
    if(e.target.value == 'all') {
        setApp('all');
        setKeyWord('');  
    }
    if(e.target.value = 'appId') {
        setApp('all');
        setApps(appNames);
    }
    
    fetchStat({  
      type: e.target.value,
      keyword: e.target.value == 'all' ? null : keyword,
      osType,
      app_name: e.target.value == 'all' ? 'all' : app,
      start: dates[0],
      end: dates[1],
      skip: 0,
      limit: 100
    });
  }

  function download() {
    return message.info('开发中');
  }


  function onChangeDate(date, _dates) {
    console.log(date, _dates);
    setDates(_dates);
    fetchStat({
      type,
      keyword,
      osType,
      app_name: app,
      start: _dates[0],
      end: _dates[1],
      skip: 0,
      limit: 100
    });
  }


  const Headers = {
    date: { title: '日期', unique: true, types: ['mask','appId','detail','all','channel'], scenes: ['all','plugin'] },
    osType: { title: '系统', unique: true, types: ['mask','appId','detail', 'all','channel'], scenes: ['all','plugin'] },
    sdk_version: { title: 'sdk版本', unique: true, types: ['detail'], scenes: ['all','plugin'] },
    app_name: { title: 'app', unique: true, types: ['mask','appId','detail','channel'], scenes: ['all','plugin'] },
    channel: { title: 'channel', unique: true, types: ['detail','channel'], scenes: ['all','plugin'] },
    package_name: { title: '包名', unique: true, types: ['detail'], scenes: ['all','plugin'] },
    init_sdk: { title: 'SDK初始化', types: ['mask','appId','detail','all','channel'], scenes: ['all'] },
    show_yunbao: { title: '浮标展示',types: ['mask','appId','detail','all','channel'], scenes: ['all'] },
    click_yunbao: { title: '浮标点击', types: ['mask','appId','detail','all','channel'], scenes: ['all'] },
    show_list:  { title: '抽屉展示',types: ['mask','appId','detail','all','channel'], scenes: ['all','plugin'] },
    play_video: { title: '广告按钮点击', unique: true, types: ['mask','appId','detail','all','channel'], scenes: ['all'] },
    ad: { title: '广告展示数', unique: true, types: ['mask','appId','detail','all','channel'], scenes: ['all'] },
    ad_click: { title: '广告点击', types: ['mask','appId','detail','all','channel'], scenes: ['all'] },
    diversion_opened: { title: 'App引流任务打开', types: ['mask','appId','detail','all','channel'], scenes: ['all'] },
    diversion_click_download: { title: 'App引流任务点击下载', types: ['mask','appId','detail','all','channel'], scenes: ['all'] },
    //pluginId_1_enter_plugin_pv: { title: '测试', unique: true, types: ['mask','appId','detail','all'], scenes: ['all','plugin'] }
  } 

  let columns = [];
  for(let x of Object.keys(Headers)) {
    if((Headers[x].types || []).indexOf(type) == -1) continue;
    if((Headers[x].scenes || []).indexOf(scene) == -1) continue;
    if(Headers[x].unique) columns.push({ title: Headers[x].title, dataIndex: x, key: x });
    else columns.push({ title:Headers[x].title, children: [{ title: x =='show_list' ? 'pv' : '次数', dataIndex: `${x}_pv`, key: `${x}_pv`}, { title: x =='show_list' ? 'uv' :'人数', dataIndex: `${x}_uv`, key: `${x}_uv`} ]});
  }
 

  if(scene !== 'all') {
      if(coin == 'get') {
        let tasks = [];
        for(let i = 1; i <= 13;i++) {
          tasks.push(i);
        }
        tasks = tasks.map( x => {
          return {
            title: '任务' + x,
            children: [{
              title: '点击次数',
              dataIndex: `mission_${x}_click_pv`,
              key: `mission_${x}_click_pv`,
     
            },{
              title: '点击人数',
              dataIndex: `mission_${x}_click_uv`,
              key: `mission_${x}_click_uv`,
     
            },{
              title: '领奖人数',
              dataIndex: `mission_${x}_get_uv`,
              key: `mission_${x}_get_uv`,
     
            }]
          }
        });
        columns = columns.concat([{
          title: '赚积分页面打开次数',
          dataIndex: `get_coin_pv`,
          key: `get_coin_pv`
        },{
          title: '赚积分页面打开人数',
          dataIndex: `get_coin_uv`,
          key: `get_coin_uv`
        }],...tasks);
      } else {
        columns = columns.concat([{
          title: '兑奖页面打开次数',
          dataIndex: `cost_coin_pv`,
          key: `cost_coin_pv`
        },{
          title: '兑奖页面打开人数',
          dataIndex: `cost_coin_uv`,
          key: `cost_coin_uv`
        },{
          title: '限量兑换领取次数',
          dataIndex: `limit_exchange_pv`,
          key: `limit_exchange_pv`
        },{
          title: '限量兑换领取人数',
          dataIndex: `limit_exchange_uv`,
          key: `limit_exchange_uv`
        },{
          title: '签到有礼打开次数',
          dataIndex: `open_sign_pv`,
          key: `open_sign_pv`
        },{
          title: '签到有礼打开人数',
          dataIndex: `open_sign_uv`,
          key: `open_sign_uv`
        },{
          title: '签到有礼签到人数',
          dataIndex: `sign_uv`,
          key: `sign_uv`
        },{
          title: '云币抽奖打开次数',
          dataIndex: `lottery_pv`,
          key: `lottery_pv`
        },{
          title: '云币抽奖打开人数',
          dataIndex: `lottery_uv`,
          key: `lottery_uv`
        },{
          title: '精品卡券兑换次数',
          dataIndex: `card_exchange_pv`,
          key: `card_exchange_pv`
        },{
          title: '精品卡券兑换人数',
          dataIndex: `card_exchange_uv`,
          key: `card_exchange_uv`
        }]);
      }

  }

  /*columns = columns.map( x => {
    x['fixed'] = 'left';
    return x;
  });*/
 /* if(scene == 'plugin') {
      columns = columns.map( x => {
       x['fixed'] = 'left';
       return x;
     });
  }*/
  columns = columns.map( x => {
     if(scene == 'plugin') {
        if(x.dataIndex == 'date') x['fixed'] = 'left';
        x.width = 30;
        if(x.children) {
          x.children = x.children.map( x => {
            //x['fixed'] = 'left';
            x.width = 30;
            return x;
          });
        }
     } else {
      delete x.fixed;
      delete x.width;
     }
     //if(x.dataIndex == 'date') x['fixed'] = 'left';
     return x;
  });
  
  let sceneColumns = [];
  if(scene == 'plugin') {
      if(dates && dates.length == 2 && dates[0] == dates[1] && plugin == 'all' && scene == 'plugin') {
        sceneColumns = columns.concat([{
          title: '场景',
          dataIndex: `name`,
          key: `name`,
          width: 20
        },{
          title: '入口点击次数',
          dataIndex: `enter_plugin_pv`,
          key: `enter_plugin_pv`,
          sorter: (a, b) => a.enter_plugin_pv - b.enter_plugin_pv,
          sortDirections: ['ascend','descend'],
          width: 20
        },{
          title: '入口点击人数',
          dataIndex: `enter_plugin_uv`,
          key: `enter_plugin_uv`,
          sorter: (a, b) => a.enter_plugin_uv - b.enter_plugin_uv,
          sortDirections: ['ascend','descend'],
          width: 20
        },{
          title: '入口点击率(%)',
          dataIndex: `enter_plugin_rate`,
          key: `enter_plugin_rate`,
          sorter: (a, b) => a.enter_plugin_rate - b.enter_plugin_rate,
          sortDirections: ['ascend','descend'],
          width: 20
        },{
          title: '互动人数',
          dataIndex: `plugin_react_uv`,
          key: `plugin_react_uv`,
          sorter: (a, b) => a.plugin_react_uv - b.plugin_react_uv,
          sortDirections: ['ascend','descend'],
          width: 20
        },{
          title: '广告展示',
          dataIndex: `ad_show`,
          key: `ad_show`,
          sorter: (a, b) => a.ad_show - b.ad_show,
          sortDirections: ['ascend','descend'],
          width: 20
        },{
          title: '广告点击',
          dataIndex: `ad_click`,
          key: `ad_click`,
          sorter: (a, b) => a.ad_click - b.ad_click,
          sortDirections: ['ascend','descend'],
          width: 20
        },{
          title: '广告点击率(%)',
          dataIndex: `ad_click_rate`,
          key: `ad_click_rate`,
          sorter: (a, b) => a.ad_click_rate - b.ad_click_rate,
          sortDirections: ['ascend','descend'],
          width: 20
        },{
          title: '活跃时长',
          dataIndex: `active_time`,
          key: `active_time`,
          sorter: (a, b) => a.active_time - b.active_time,
          sortDirections: ['ascend','descend'],
          width: 20
        }])


      } else {

        let count = 0;
        for(let key of Object.keys(defaultPluginData)) {
          if(plugin!== 'all' && key !== 'pluginId_' + plugin) continue;
          count += 1;
          let data = { title: defaultPluginData[key].name, children: [{
            title: '入口点击次数',
            dataIndex: `${key}_enter_plugin_pv`,
            key: `${key}_enter_plugin_pv`,
            width: 20
          },{
            title: '入口点击人数',
            dataIndex: `${key}_enter_plugin_uv`,
            key: `${key}_enter_plugin_uv`,
            width: 20
          },{
            title: '互动人数',
            dataIndex: `${key}_plugin_react_uv`,
            key: `${key}_plugin_react_uv`,
            width: 20
          },{
            title: '广告展示',
            dataIndex: `${key}_ad_show`,
            key: `${key}_ad_show`,
            width: 20
          },{
            title: '广告点击',
            dataIndex: `${key}_ad_click`,
            key: `${key}_ad_click`,
            width: 20
          },{
            title: '活跃时长',
            dataIndex: `${key}_active_time`,
            key: `${key}_active_time`,
            width: 20
          }] 
         };
         columns.push(data);
        }
        scrollX = 100 + count * 500;
      } 

      console.dir(plugin + '===============')
      if(plugin == '19') {
        columns = columns.concat([{
            title: '投喂次数',
            dataIndex: `feed_pv`,
            key: `feed_uv`,
            width: 20
          },{
            title: '投喂人数',
            dataIndex: `feed_uv`,
            key: `feed_uv`,
            width: 20
          },{
            title: '饲料任务',
            children: [{
            title: '完成1次',
            dataIndex: `mission_1_uv`,
            key: `mission_1_uv`,
            width: 20
          },{
            title: '完成2次',
            dataIndex: `mission_2_uv`,
            key: `mission_2_uv`,
            width: 20
          },{
            title: '完成3次',
            dataIndex: `mission_3_uv`,
            key: `mission_3_uv`,
            width: 20
          },{
            title: '完成4次',
            dataIndex: `mission_4_uv`,
            key: `mission_4_uv`,
            width: 20
          }]},{
            title: '日活人数',
            dataIndex: `active_uv`,
            key: `active_uv`,
            width: 20
          },{
            title: '昨日日活',
            dataIndex: `last_active_uv`,
            key: `last_active_uv`,
            width: 20
          },{
            title: '次留日活',
            dataIndex: `left`,
            key: `left`,
            width: 20
          },{
            title: '许愿池展示',
            dataIndex: `wish_show_pv`,
            key: `wish_show_pv`,
            width: 20
          },{
            title: '许愿池点击',
            dataIndex: `wish_click_pv`,
            key: `wish_click_pv`,
            width: 20
          },{
            title: 'npc小熊猫展示',
            dataIndex: `panda_show_pv`,
            key: `panda_show_pv`,
            width: 20
          },{
            title: 'npc小熊猫点击',
            dataIndex: `panda_click_pv`,
            key: `panda_click_pv`,
            width: 20
          },{
            title: '广告推销员展示',
            dataIndex: `adman_show_pv`,
            key: `adman_show_pv`,
            width: 20
          },{
            title: '广告推销员点击',
            dataIndex: `adman_click_pv`,
            key: `adman_click_pv`,
            width: 20
          }])
        console.dir(scrollX + 'before');
        scrollX = scrollX + 2000;
        console.dir(scrollX + + 'after');
      }
      //setScrollX(count * 300)
  }

  if(scene !== 'all') scrollX += (coin == 'get' ? 3600 : 1500);


  const appOptions = apps.map( x => <Option key={x} value={x}>{ x }</Option>)
  const pluginOptions = plugins.map( x => <Option key={x.key} value={x.key}>{ x.name }</Option>)
  return (
    <div className="container"> 
      <div className="opbox flex r" style={{ marginBottom: '12px' }}>
        <Radio.Group onChange={onChangeScene} value={scene} style={{ marginRight: '12px', minWidth: '176px' }}>
          <Radio.Button value="all">全局视角</Radio.Button>
          <Radio.Button value="plugin">场景分析</Radio.Button>
        </Radio.Group>
        <Radio.Group onChange={onChangeCoin} value={coin} style={{ marginRight: '12px', minWidth: '176px' }}>
          <Radio.Button value="get">赚积分</Radio.Button>
          <Radio.Button value="cost">花积分</Radio.Button>
        </Radio.Group>
        <Radio.Group onChange={onChange} value={type} style={{ marginRight: '12px', minWidth: '476px' }}>
          <Radio.Button value="all">大盘数据</Radio.Button>
          <Radio.Button value="mask">全局数据</Radio.Button>
          <Radio.Button value="appId">全局数据(官方)</Radio.Button>
          <Radio.Button value="channel">渠道数据</Radio.Button>
          <Radio.Button value="detail">详细数据</Radio.Button>
        </Radio.Group>
       
        <RangePicker
          format={dateFormat}
          style={{ marginRight: '12px' }}
          onChange={ onChangeDate }
        />
        <Button type="primary" onClick={ download }>下载数据</Button>
      </div>
      <div className="opbox flex r" style={{ marginBottom: '12px' }}>
        <Select placeholder="请选择系统" onChange={handleChangeosType} value={osType} style={{ marginRight: '12px',  minWidth: '200px' }}>
          <Option value="all">全部</Option>
          <Option value="android">安卓</Option>
          <Option value="ios">IOS</Option>
        </Select>
        { type != 'all' ? <Select  placeholder="请选择APP" onChange={handleChangeApp} value={app} style={{ marginRight: '12px',  width: '200px' }}>
          <Option value="all">全部</Option>
          {
            appOptions
          }
        </Select>: null 
        }
        
        {
          scene == 'plugin' ? <Select placeholder="请选择场景" onChange={handleChangePluginType} value={plugin} style={{ marginRight: '12px',  minWidth: '200px' }}>
          <Option value="all">全部场景</Option>
          {
            pluginOptions
          }
        </Select>: null
        }

        {
         type != 'all' ? <Search style={{ marginRight: '12px' }} allowClear placeholder="输入包名、channel、app" onSearch={onSearch} style={{ width: 250 }} enterButton/> : null
        }
        
      </div>
      <div className="chart" style={{ display: 'none' }}><ReactECharts option={ data } /></div>
      {
       (dates && dates.length == 2 && dates[0] == dates[1] && plugin == 'all' && scene == 'plugin') ? <Table dataSource={sceneData} columns={sceneColumns}  loading={loading} pagination={{ pageSize: 10000 }} scroll={{ x: 2000, y: 700 }}/>  : <Table dataSource={statData} columns={columns} onChange={handleTableChange} loading={loading} pagination={{...pagination}} scroll={{ x: scrollX, y: 700 }}/> 
      }
    </div>
  );
}
