import React, { useState, useEffect, useRef } from 'react';
import styles from './index.less';
import { useAccess } from 'umi';
import { Button, Form, Card, Input, Layout, Menu } from 'antd';
import { setToken, delToken, setUserName, delUserName, getUserName } from '../local';
import {
  MenuUnfoldOutlined,
  MenuFoldOutlined,
  UserOutlined,
  VideoCameraOutlined,
  UploadOutlined,
  DatabaseOutlined,
  FundOutlined,
  SettingOutlined,
  LogoutOutlined
} from '@ant-design/icons';

const { Header, Sider, Content } = Layout;

import * as fn from '../api';
const { sign } = fn.default;
const menus = ['/','/stat'];

const BasicLayout: React.FC = props => {

  const access = useAccess();
 
  if(!access.token) {
    delToken();
    delUserName();
    console.dir('=========')
    if(props.location.pathname !== '/login') return window.location.href = '/login';
  }
  const [collapsed,setCollapsed] = useState(false);
  const [key,setKey] = useState([menus.indexOf(props.location.pathname).toString()]);
  const username = getUserName()
  const toggle = () => {
    setCollapsed(!collapsed);
  };

  const handleClick = (e) => {
    window.location.href = menus[e.key];
  };

  const logout = (e) => {
    delToken();
    setTimeout( x => {
      window.location.reload();
    },500);
  }

  return (
    <div style={{ height: '100%', width: '100%' }}>
          <Layout className="box">
        <Sider trigger={null} collapsible collapsed={collapsed}>
          <div className="logo" />
          <Menu theme="dark" mode="inline" defaultSelectedKeys={key} onClick={handleClick}>
            <Menu.Item key="0" icon={<FundOutlined />}>
              广告数据
            </Menu.Item>
            <Menu.Item key="1" icon={<SettingOutlined />}>
              权限设置
            </Menu.Item>
          </Menu>
        </Sider>
        <Layout className="site-layout">
          <Header className="layout-back" style={{ padding: 0,justifyContent: 'space-between', display: 'flex' }}>
            {React.createElement(collapsed ? MenuUnfoldOutlined : MenuFoldOutlined, {
              className: 'trigger',
              onClick: toggle,
            })}
            <div>
             <span>欢迎你，{
              username
            }</span>
            {React.createElement(LogoutOutlined, {
              className: 'trigger',
              onClick: logout,
            })}
            </div>
          </Header>
          <Content
            className="layout-back"
            style={{
              margin: '24px 16px',
              padding: 24,
              minHeight: 280,
            }}
          >
            {props.children}
          </Content>
        </Layout>
      </Layout>


     
    </div>
  );
};

export default BasicLayout;
