const moment = require('moment');
const fs = require('fs');
module.exports = {
	transDate: (items, key) => {
		return items.map( x => {
			x = x.toJSON ? x.toJSON() : x;
			x[key || 'createdAt'] = moment(x[key || 'createdAt']).format('YYYY/MM/DD HH:mm');
			return x;	
		})
	},
	generateDateQuery: (start, end, option) => {
		if(/^[0-9]{8}$/.test(start) && /^[0-9]{8}$/.test(end)) {
			let data = {};
			if(option && option.type === 'string') {
				data[option && option.key ? option.key : 'createdAt'] =  { '$gte': start, '$lte':  end };
			} else {
				data[option && option.key ? option.key : 'createdAt'] =  { '$gte': moment(start,'YYYYMMDD').startOf('day').toDate(), '$lt':  moment(end,'YYYYMMDD').endOf('day').toDate() };
			}
			return data;
		}
		else return {};
	},
	generateTokenCode: () => {
		return Math.random().toString(36).substr(8);
	},
	getFixedNumber: (number) => {
  		return parseFloat(Number(number || 0).toFixed(2));
	},
	valid: (id) => {
		return /^[0-9a-z]{24}$/.test(id);
	},
	allUndefined: (array) => {
		let b = true
		for(var k in array) {
			b = b && (array[k] === undefined)
		}
		return b;
	},
	log: (content,file) => {
		let to = file || 'public/log';
		let time = moment().format('YYYYMMDD HH:mm:ss') + '~~';
		fs.appendFile(to, 'At '+ time +  content + '\n',function(){
	      console.log(content);
	  	});
	}
}