require('colors');
require('app-module-path/register');
const api = require('./utils/api');
const config = require('config');
const PassThrough = require('stream').PassThrough;
const Koa = require('koa');
const compress = require('koa-compress');
const cors = require('kcors');
const bodyParser = require('koa-bodyparser');
const logger = require('koa-logger');
const path = require('path');
const mongoose = require('mongoose');
const moment = require('moment');
const error = require('middleware/error');
const jwt = require('middleware/jwt');
const rp = require('request-promise');
const request = require('request');
const mountRoutes = require('utils/mount-routes');
const favicon = require('koa-favicon');
const fs = require('fs');
//const crypto = require('crypto');

const websockify = require('koa-websocket');


global.Promise = mongoose.Promise = require('bluebird');
const options = {
    useMongoClient: true
};
const parse = require('co-body');
const router = require('koa-router')();
const app = new Koa();
const { MONGO_DB } = process.env;

/*mongoose.connect(MONGO_DB || config.MONGO_DB, {});
console.log('MONGO CONNECT INFO: ', MONGO_DB || config.MONGO_DB);*/

const opts = { threshold: 2048 };


app.use(cors());
app.use(compress(opts));
app.use(router.routes());

app.use(logger());
app.use(error());

app.use(require('koa-static')(__dirname + '/dist'))
app.use(jwt());
app.use(bodyParser({}));

app.use(mountRoutes().routes());


const { PORT = 8787 } = process.env;
app.listen(PORT, () => {
    console.log(`server start at ${PORT}`);
});

console.dir(`当前运行环境${process.env.NODE_ENV}`);
process.on('unhandledRejection', (err, promise) => {
    console.error('Unhandled rejection (promise: ', promise, ', reason: ', err, ').');
});