const mysql = require("mysql");
const config = require('../config');
const Promise = require('bluebird');
const pool = mysql.createPool(config.SQL_CONF);

module.exports = {
    query(query_string) {
      return new Promise(( resolve, reject ) => {
            pool.getConnection(function(err, connection) {
              if (err) {
                reject( err )
              } else {
                connection.query(query_string, ( err, rows) => {
                  if ( err  ) {
                    reject( err )
                  } else {
                    resolve( rows )
                  }
                  connection.release()
                })
              }
            })
        })
    }
}

