
function randomn(n) {
  if (n > 21) return null
  return parseInt((Math.random() + 1) * Math.pow(10,n-1))
}
const jwt = require('jsonwebtoken');
const config = require('config');
const hash = require('utils/hash');
const _ = require('lodash');
const mongoose = require('mongoose');
const Account = require('db/mongo/user');
const {
    ObjectId
} =  require('mongoose').Types;

function getToken(user, opt = {}) {
    if (!opt.expiresIn) {
        opt.expiresIn = '7d';
    }
    return jwt.sign(
        user,
        config.JWT_SECRET,
        opt
    );
}

/*(async function(argument) {
    let a = await  new Account({
        username: 'admin',
        password: hash('admin')
    }).save();
    console.dir(a);
})()*/

const RETURN_FIELDS = ['_id', 'code', 'username','role', 'createdAt'];

exports.checkPassword = async(ctx, next) => {
    let {
        username,
        password
    } = ctx.request.body;
    let user = await Account.findOne({
        username,
        removed: { $ne: true }
    });
    console.dir(ctx.request.body);
    ctx.assert(user, 404, '没有该用户', {
        code: 1
    });
    user = user.toJSON();
    console.dir(user.password)
    ctx.assert(
        hash(password) === user.password,
        400,
        '密码错误', {
            code: 1
        }
    );
    ctx.state.checkedAccount = user;
    await next();
};

exports.whoAmI = async ctx => {
    let myId = ctx.state.user._id;
    let { username, phone, company, createdAt, updatedAt, role } = await Account.findById(myId);
    ctx.body = {
        status: 'ok',
        data: {
            username
        }
    };
};

exports.signin = async(ctx, next) => {
    let {
        username
    } = ctx.request.body;
    let user = await Account.findOne({
        username
    });
    let token = getToken(_.pick(user, '_id', 'username'));
    ctx.body = {
        status: 'ok',
        pid: user._id,
        username,
        role: user.role,
        token
    };
};



console.log('==============')
console.log(hash('1234567xx'))
