This project was bootstrapped with [Create React App](https://github.com/facebook/create-react-app).

## Available Scripts

In the project directory, you can run:

### `npm start`

Runs the app in the development mode.<br>
Open [http://localhost:3000](http://localhost:3000) to view it in the browser.

The page will reload if you make edits.<br>
You will also see any lint errors in the console.

### `npm test`

Launches the test runner in the interactive watch mode.<br>
See the section about [running tests](https://facebook.github.io/create-react-app/docs/running-tests) for more information.

### `npm run build`

Builds the app for production to the `build` folder.<br>
It correctly bundles React in production mode and optimizes the build for the best performance.

The build is minified and the filenames include the hashes.<br>
Your app is ready to be deployed!

See the section about [deployment](https://facebook.github.io/create-react-app/docs/deployment) for more information.

### `npm run eject`

**Note: this is a one-way operation. Once you `eject`, you can’t go back!**

If you aren’t satisfied with the build tool and configuration choices, you can `eject` at any time. This command will remove the single build dependency from your project.

Instead, it will copy all the configuration files and the transitive dependencies (Webpack, Babel, ESLint, etc) right into your project so you have full control over them. All of the commands except `eject` will still work, but they will point to the copied scripts so you can tweak them. At this point you’re on your own.

You don’t have to ever use `eject`. The curated feature set is suitable for small and middle deployments, and you shouldn’t feel obligated to use this feature. However we understand that this tool wouldn’t be useful if you couldn’t customize it when you are ready for it.

## Learn More

You can learn more in the [Create React App documentation](https://facebook.github.io/create-react-app/docs/getting-started).

To learn React, check out the [React documentation](https://reactjs.org/).

### Code Splitting

This section has moved here: https://facebook.github.io/create-react-app/docs/code-splitting

### Analyzing the Bundle Size

This section has moved here: https://facebook.github.io/create-react-app/docs/analyzing-the-bundle-size

### Making a Progressive Web App

This section has moved here: https://facebook.github.io/create-react-app/docs/making-a-progressive-web-app

### Advanced Configuration

This section has moved here: https://facebook.github.io/create-react-app/docs/advanced-configuration

### Deployment

This section has moved here: https://facebook.github.io/create-react-app/docs/deployment

### `npm run build` fails to minify

This section has moved here: https://facebook.github.io/create-react-app/docs/troubleshooting#npm-run-build-fails-to-minify




## 数据库结构
钓鱼排行榜数据库主要以mongo为主，结合 mysql和redis 实现业务流程；
mysql 部分为账户钱包存储，和转账，取现，充值等业务需求；
redis 为满足app首页，头部信息和之后频繁获取配置项的缓存需求；

mongo collection结构如下(集合名词，字段，含义),具体字段类型见源码

### 后台管理员信息集合
account  { 
	username,  	//	账户
	password,	//  密码
    nickName,    //  昵称
    role        //  角色
}
### 订单信息集合 
application {
    event,      // 活动/赛事id
    user,       // 发起用户id
    from,       // 付款来源（miniprogram为微信小程序）
    payType: 	// 付款类型，目前支持，钱包付款、微信付款，之后集成支付宝
    check       // 核销状态
    status,		// 付款状态
    balancelog,	// 关联日志
    nums,       // 分配后座位号（客户端可见）
    init_nums,  // 初始化座位号（客户端不可见）
    archive,	// 归档标识
    code, 		// 订单编码
    count,      // 数量
    price,      // 单价
    money,      // 金额
    serveMoney, // 平台服务费
    removed,    // 订单删除
    originMoney,  // 预留
    origin,	    // 预留
    payment    // 预留
}
### 文章集合
article {
    title,		 // 标题
    content,		// 内容 混合h5
    from,	// 来源
    author,	// 作者
    classTypes, // 文章类型
    top,	// 置顶状态
    type,	// 预留
    words,	// 关键字
    images,	// 图片集
    textualContent,	// 简要
    times,		// 阅读次数
    weight,    // 权重
    removed: Boolean	// 前端可见状态
}
### 财务日志集合
balancelog {
    type,	            // 日志类型
    backMoney,          // 退款标识
    application,        // 关联订单,
    cashPutApplication, // 关联取现订单
    cashApplication,	// 关联充值订单
    money,				// 财务金额
    platformMoney,		// 平台金额
    time,				// 时间
    meta,				// 备注
    how,				// 操作类型，阿里转账， 微信转账， 人工操作， 系统内转账
    from,			    // 发起用户
    to,					// 接受用户
    status				// 状态
}
### 取现订单集合
cashApplication{
    user,				// 发起用户
    money,				// 取现金额
    auto,               // 自动转账标识（支付宝接口）
    accountMoney,		// 取现前余额
    alipayAccount,		// 阿里账户
    name,				// 姓名
    phone,				// 电话
    archive,			// 归档状态
    status				// 订单状态
}
### 充值订单集合
cashPutApplication{
    user,				// 发起用户
    payType, 			// 付款类型
    money,				// 金额
    archive,			// 归档状态
    status				// 订单状态
}

### 评论集合
cashPutApplication{
    user,               // 用户
    article,            // 渔获文章
    content,            // 评论内容
}
### 活动/赛事集合
event{
    name,				// 名称
    type,				// 类型 活动 or 赛事
    top,				// 置顶状态
    weight: Number,		// 权重
    tab,		        // 特殊标签 预留
    time,	            // 开始时间（可读）
    endTime,            //报名截止时间
    count: {			// 人数限制 
        type: Number,
        required: true
    },
    user: {				// 发起用户
        type: ObjectId,
        ref: 'user'
    },
    money: {			// 报名金额
        type: Number,
        required: true
    },
    numable,             // 是否支持摇号
    nums_done,           // 摇号状态
    applicationCount,    // 订单数量
    applicationUserCount,// 报名人数
    outdate,             // 过期标识
    removed,             // 活动|赛事取消标识
    backMoney,           // 退款标识
    backMoneyDone,       // 退款完成标识
    backMoneyAmount,     // 退款金额
    eventRound,          // ['日场','夜场']
    eventType,           // ['正钓','偷驴','路亚']
    eventFish,           // ['鲤鱼','鲫鱼', '路亚鱼种']
    spot: {				 // 关联钓场
        type: ObjectId,
        ref: 'spot'
    },
    users: [{			// 参与用户  预留
        type: ObjectId,
        ref: 'user'
    }],
    applications: [{	// 关联订单 
        id: {
            type: ObjectId,
            ref: 'application'
        },
        user: {
            type: ObjectId,
            ref: 'ref'
        },
        count: {
            type: Number
        } 
    }],
    posters,	// 海报
    icon,       //封面图
    content,	// 注意事项
    status			// 状态
}
### 钓场集合
spot{
    name,			// 名称,
    point,			// 经纬度信息
    verify,         // 认证标识
    game,           // 赛事标识
    activity,       // 活动标识
    ngeohash,		// 经纬度信息 hash 值
    geohash,		// 经纬度信息 hash 值
    address,		// 地址
    top,			// 置顶状态
    weight,			// 权重
    money,          //收费标准
    phone,			// 联系电话
    star,			// 星级
    spotType,		// 钓场类型
    waterSquare,    // 水域面积
    fishes,			// 鱼种信息
    waterCount,     // 池塘个数
    spotCount,      // 钓位个数
    spotDistance,   // 钓位间距
    rodLong,        // 限杆长度
    waterDepth,     // 水深度
    content,        //简介
    posters,		// 海报
    icon,			// icon
    location,		// 位置信息
    content,		// 钓场说明
    status, 		// 审核状态
    removed,		// 是否可见
    user,			// 关联用户
    contactPhone,	// 联系电话
    contactName		// 联系人
}

### 用户集合
user{
    nickname,		// 昵称
    pointInfo,      // 积分
    speakDisable,   // 禁言标识
    readwarn,       // 提示读取记录
    uniqID,			// 唯一id
    sex,			// 性别
    headimgurl,		// 头像
    birthday,		// 生日
    sign: String,   //  个性签名
    address,        // 地址
    phone,         	// 手机号， 登陆使用唯一     
    password,		// 登录密码
    wechat,			// 关联微信信息
    alipayAccount,	// 关联支付宝信息
    card: {         // 身份证
        type: String
    },
    fans:Number,    // 粉丝数
    favorate: Number, // 关注数
    name: {          // 姓名
        type: String
    }
}



### 渔获集合
fisharticle{
    （同文章集合）
}

### 关系集合 (待优化)
relation{
    targetUser,	  // 被关注用户
    fan           // 关注用户
}

### 上传积分集合
uploadpoint{
   phone,         // 手机
   point,         // 积分
   type,          // 类型
   user,          // 关联网内用户 
}

### 兑换币集合
point{
    time,         // 时间
    archive,      // 归档标识   
    coins,        // 归档标识
    reason,       // 积分项目 ['每日签到','完成注册','实名认证','完善资料','首次关注钓场','首次参与赛事','首次参与活动','首次发布渔获','参与赛事','参与活动','发布渔获','评论渔获','分享内容']
    application,  // 关联订单
    article,      // 关联渔获
    shareContent, // 关联分享信息
    meta,         // 备注
    user,         // 用户
}

### 渔获点赞日志集合 ()
fishfavor{
    article,      // 渔获
    user,         // 关注用户
    removed       // 状态，是否有效
}

### 钓场收藏日志集合 ()
spotfavor{
    spot,         // 钓场
    user,         // 收藏用户
    removed       // 状态，是否有效
}


### 大图集合（app大图配置集合，首页和钓场页）
swiper{
    file:String,   // 文件名称
    type: String,  // 类型
    id: ObjectId,  // 关联id
    page:String	   // 页面信息
}


##mysql
###数据库 balances

table balance {
 	id INT AUTO_INCREMENT PRIMARY KEY,	// 唯一id
    uid VARCHAR(255),					// 关联用户 uniqID
    balance DECIMAL(10,2) NOT NULL,		// 余额
    moneyin DECIMAL(10,2) NOT NULL ,	// 入账
    moneyout DECIMAL(10,2) NOT NULL,	// 出账
    frozen DECIMAL(10,2) NOT NULL		// 冻结金额
}
##redis
###待定

