import { Commit } from 'vuex';
import { Message } from 'element-ui';

import { GET_FILTERLIST, CREATE_FILTERLIST } from '../types';
import { getFilterList, createFilterList } from '@/api/filterNumber';

interface PermissionAttribute {
  id?: string;
  name: string;
  code: string;
  desc?: string;
  status?: boolean;
  createdAt?: number;
  updatedAt?: number;
}

export interface State {
  dataList: any[];
  count: number;
}

const filterNumberState: State = {
  dataList: [
    {
      name: '0001',
      wechatTotal: '王二狗(123)',
      status: false,
      total: 5000,
      used: 3000,
      createdAt: '1536549529672',
      taskList: [
        {number: '18612341234', createdAt: '1536549523672', callbackcode: 2},
        {number: '18612341234', createdAt: '1536549523672', callbackcode: 4},
        {number: '18612341234', createdAt: '1536549523672', callbackcode: 2},
        {number: '18612341234', createdAt: '1536549523672', callbackcode: 0},
        {number: '18612341234', createdAt: '1536549523672', callbackcode: 1},
        {number: '18612341234', createdAt: '1536549523672', callbackcode: 2},
        {number: '18612341234', createdAt: '1536549523672', callbackcode: 3},
        {number: '18612341234', createdAt: '1536549523672', callbackcode: 0},
      ],
    },
    {
      name: '0001',
      wechatTotal: '王二狗(123)',
      status: false,
      total: 5000,
      used: 3000,
      createdAt: '1536549529672',
      taskList: [
        {number: '18612341234', createdAt: '1536549523672', callbackcode: 2},
        {number: '18612341234', createdAt: '1536549523672', callbackcode: 4},
        {number: '18612341234', createdAt: '1536549523672', callbackcode: 2},
        {number: '18612341234', createdAt: '1536549523672', callbackcode: 0},
        {number: '18612341234', createdAt: '1536549523672', callbackcode: 1},
        {number: '18612341234', createdAt: '1536549523672', callbackcode: 2},
        {number: '18612341234', createdAt: '1536549523672', callbackcode: 3},
        {number: '18612341234', createdAt: '1536549523672', callbackcode: 0},
      ],
    },
    {
      name: '0001',
      wechatTotal: '王二狗(123)',
      status: false,
      total: 5000,
      used: 3000,
      createdAt: '1536549529672',
      taskList: [
        {number: '18612341234', createdAt: '1536549523672', callbackcode: 2},
        {number: '18612341234', createdAt: '1536549523672', callbackcode: 4},
        {number: '18612341234', createdAt: '1536549523672', callbackcode: 2},
        {number: '18612341234', createdAt: '1536549523672', callbackcode: 0},
        {number: '18612341234', createdAt: '1536549523672', callbackcode: 1},
        {number: '18612341234', createdAt: '1536549523672', callbackcode: 2},
        {number: '18612341234', createdAt: '1536549523672', callbackcode: 3},
        {number: '18612341234', createdAt: '1536549523672', callbackcode: 0},
      ],
    },
    {
      name: '0001',
      wechatTotal: '王二狗(123)',
      status: false,
      total: 5000,
      used: 3000,
      createdAt: '1536549529672',
      taskList: [
        {number: '18612341234', createdAt: '1536549523672', callbackcode: 2},
        {number: '18612341234', createdAt: '1536549523672', callbackcode: 4},
        {number: '18612341234', createdAt: '1536549523672', callbackcode: 2},
        {number: '18612341234', createdAt: '1536549523672', callbackcode: 0},
        {number: '18612341234', createdAt: '1536549523672', callbackcode: 1},
        {number: '18612341234', createdAt: '1536549523672', callbackcode: 2},
        {number: '18612341234', createdAt: '1536549523672', callbackcode: 3},
        {number: '18612341234', createdAt: '1536549523672', callbackcode: 0},
      ],
    },
    {
      name: '0001',
      wechatTotal: '王二狗(123)',
      status: false,
      total: 5000,
      used: 3000,
      createdAt: '1536549529672',
      taskList: [
        {number: '18612341234', createdAt: '1536549523672', callbackcode: 2},
        {number: '18612341234', createdAt: '1536549523672', callbackcode: 4},
        {number: '18612341234', createdAt: '1536549523672', callbackcode: 2},
        {number: '18612341234', createdAt: '1536549523672', callbackcode: 0},
        {number: '18612341234', createdAt: '1536549523672', callbackcode: 1},
        {number: '18612341234', createdAt: '1536549523672', callbackcode: 2},
        {number: '18612341234', createdAt: '1536549523672', callbackcode: 3},
        {number: '18612341234', createdAt: '1536549523672', callbackcode: 0},
      ],
    },
    {
      name: '0001',
      wechatTotal: '王二狗(123)',
      status: false,
      total: 5000,
      used: 3000,
      createdAt: '1536549529672',
      taskList: [
        {number: '18612341234', createdAt: '1536549523672', callbackcode: 2},
        {number: '18612341234', createdAt: '1536549523672', callbackcode: 1},
        {number: '18612341234', createdAt: '1536549523672', callbackcode: 2},
        {number: '18612341234', createdAt: '1536549523672', callbackcode: 0},
        {number: '18612341234', createdAt: '1536549523672', callbackcode: 1},
        {number: '18612341234', createdAt: '1536549523672', callbackcode: 2},
        {number: '18612341234', createdAt: '1536549523672', callbackcode: 3},
        {number: '18612341234', createdAt: '1536549523672', callbackcode: 0},
      ],
    },
    {
      name: '0001',
      wechatTotal: '王二狗(123)',
      status: false,
      total: 5000,
      used: 3000,
      createdAt: '1536549529672',
      taskList: [
        {number: '18612341234', createdAt: '1536549523672', callbackcode: 2},
        {number: '18612341234', createdAt: '1536549523672', callbackcode: 4},
        {number: '18612341234', createdAt: '1536549523672', callbackcode: 2},
        {number: '18612341234', createdAt: '1536549523672', callbackcode: 0},
        {number: '18612341234', createdAt: '1536549523672', callbackcode: 1},
        {number: '18612341234', createdAt: '1536549523672', callbackcode: 2},
        {number: '18612341234', createdAt: '1536549523672', callbackcode: 3},
        {number: '18612341234', createdAt: '1536549523672', callbackcode: 0},
      ],
    },
    {
      name: '0001',
      wechatTotal: '王二狗(123)',
      status: false,
      total: 5000,
      used: 3000,
      createdAt: '1536549529672',
      taskList: [
        { number: '18612341234', createdAt: '1536549523672', callbackcode: 1 },
      ],
    },
    {
      name: '0001',
      wechatTotal: '王二狗(123)',
      status: false,
      total: 5000,
      used: 3000,
      createdAt: '1536549529672',
      taskList: [
        { number: '18612341234', createdAt: '1536549523672', callbackcode: 0 },
      ],
    },
  ],
  count: 0,
};

const actions = {
  [GET_FILTERLIST](
    context: { commit: Commit, state: State },
    payload: { size: number, page?: number },
  ) {
    // 获取角色列表
    getFilterList(payload.size, payload.page).then((data) => {
      const result = data.data.result;
      if (result) {
        context.commit(GET_FILTERLIST, result);
      } else {
        Message.error(`获取数据失败错误原因是${data.data.msg}`);
      }
    }).catch((err) => {
      throw(err);
    });
  },

  [CREATE_FILTERLIST](
    context: { commit: Commit, state: State },
    payload: {
      name: string,
      desc: string,
      code: string,
    }) {
    // 创建角色
    createFilterList(payload).then((data) => {
      const result = data.data.result;
      if (result) {
        context.commit(CREATE_FILTERLIST, result);
        Message.success('角色创建成功');
      } else {
        Message.error(data.data.msg);
      }
    }).catch((err) => {
      throw(err);
    });
  },
};

const mutations = {
  [GET_FILTERLIST](state: State, data: { rows: PermissionAttribute[], count: number }) {
    state.dataList = data.rows;
    state.count = data.count;
  },

  [CREATE_FILTERLIST](state: State, data: PermissionAttribute) {
    state.dataList.unshift(data);
    state.count += 1;
  },
};

export default {
  state: filterNumberState,
  actions,
  mutations,
};
