import Vue from 'vue';
import Router from 'vue-router';
import Home from './views/layout/Layout.vue';

const Login = () => import('./views/Login.vue');
const FilterNumber = () => import('./views/FilterNumber.vue');
const AddTask = () => import('./views/AddTask.vue');

Vue.use(Router);

export default new Router({
  mode: 'history',
  base: process.env.BASE_URL,
  routes: [
    {
      path: '/',
      name: 'home',
      component: Home,
      children: [
        {
          path: '/filternumber',
          name: 'filternumber',
          component: FilterNumber,
        },
        {
          path: '/addtask',
          name: 'addtask',
          component: AddTask,
        },
      ],
    },
    {
      path: '/login',
      name: 'login',
      component: Login,
    },
  ],
});
