import axios from 'axios';

axios.defaults.withCredentials = true;

const getPassports = (size: number, page?: number) => {
  return axios.get(`/api/passport?page=${page}&size=${size}`);
};

const createPassport = (
  form: {
    password: string,
    username: string,
    email: string,
  }) => {
  return axios.post(`/api/passport`, form);
};

const updatePassport = (
  form: {
    id: string,
    password?: string,
    IsDelete?: boolean,
  }) => {
  return axios.put(`/api/passport`, form);
};

const deletePassport = (form: {id: string}) => {
  return axios.delete(`/api/passport`, {data: {id: form.id}});
};

const setRole = (form: { passportId: string, roleId: string }) => {
  return axios.post(`/api/setRole`, form);
};

export {
  getPassports,
  createPassport,
  updatePassport,
  deletePassport,
  setRole,
};
