import axios from 'axios';

axios.defaults.withCredentials = true;

const getRoles = (size: number, page?: number) => {
  return axios.get(`/api/rolePermission?page=${page}&size=${size}`);
};

const createRole = (
  form: {
    name: string,
    status?: boolean,
    isUsed?: boolean,
    parent?: string,
    children?: string,
  }) => {
  return axios.post(`api/role`, form);
};

const updateRole = (
  form: {
    id: string,
    status?: boolean,
    isUsed?: boolean,
    parent?: string,
    children?: string,
  }) => {
  return axios.put(`api/role`, form);
};

const deleteRole = (form: { roleId: string }) => {
  return axios.delete(`/api/role`, { data: { roleId: form.roleId } });
};

const setPermission = (form: { permissionId: string, roleId: string }) => {
  return axios.post(`/api/setPermission`, form);
};

export {
  getRoles,
  createRole,
  updateRole,
  deleteRole,
  setPermission,
};
