import axios from 'axios';

axios.defaults.withCredentials = true;

const getPermissions = (size: number, page?: number) => {
  return axios.get(`/api/permission?page=${page}&size=${size}`);
};

const createPermission = (
  form: {
    name: string,
    desc: string,
    code: string,
  }) => {
  return axios.post(`api/permission`, form);
};

const updatePermission = (
  form: {
    id: string,
    name?: string,
    desc?: string,
    status?: boolean,
  }) => {
  return axios.put(`api/permission`, form);
};

const deletePermission = (form: { permissionId: string }) => {
  return axios.delete(`/api/permission`, { data: { permissionId: form.permissionId } });
};

export {
  getPermissions,
  createPermission,
  updatePermission,
  deletePermission,
};
