import axios from 'axios';

axios.defaults.withCredentials = true;

const getFilterList = (size: number, page?: number) => {
  return axios.get(`/api/permission?page=${page}&size=${size}`);
};

const createFilterList = (
  form: {
    name: string,
    desc: string,
    code: string,
  }) => {
  return axios.post(`api/permission`, form);
};

export {
  getFilterList,
  createFilterList,
};
