import { Commit } from 'vuex';
import { Message } from 'element-ui';

import { LOGIN } from '../types';
import { getUser } from '@/api/login';


export interface State {
  isLogin: boolean;
  account: { username: string };
}

const loginState: State = {
  isLogin: false,
  account: { username: '' }
};

const actions = {
  [LOGIN](
    context: { commit: Commit, state: State },
    payload: { username: string, password: string, callback: any },
  ) {
    // 获取角色列表
    getUser(payload).then((result) => {
      console.dir(result.data);
      if (result.data && result.data.account) {
        context.commit(LOGIN, result.data.account);
        if(payload.callback) payload.callback(null, result.data.account);
      } else {
        Message.error(`获取数据失败错误`);
      }
    }).catch((data) => {
      Message.error(data.error ? data.error : `账户或密码错误`)
      if(payload.callback) payload.callback(data.error ? data.error : `账户或密码错误`);
    });
  },


};

const mutations = {
  [LOGIN](state: State, data: { username: string, sessionID: string }) {
    state.isLogin = true;
    localStorage.setItem('__sessionID', data.sessionID);
    state.account = data;
    // state.dataList = data.rows;
    // state.count = data.count;
  },


};

export default {
  state: loginState,
  actions,
  mutations,
};
