import { Commit } from 'vuex';
import { Message } from 'element-ui';

import { GET_DEVICELIST, GET_QRCODE, GET_WECHAT, RESET_QRCODE, RESET_WECHATINFO } from '../types';
import { getDeviceList, getQrcode, getDeviceStatus } from '@/api/device';

export interface State {
  deviceList: any[];
  qrcode: string;
  weChatInfo: any;
  taskID: any;
}

const deviceState: State = {
  deviceList: [],
  qrcode: '',
  weChatInfo: {},
  taskID: null,
};

const actions = {
  [GET_DEVICELIST](
    context: { commit: Commit, state: State },
    payload: {},
  ) {
    getDeviceList().then((data) => {
      const result = data.data;
      if (result) {
        context.commit(GET_DEVICELIST, result);
      } else {
        Message.error(`获取设备失败`);
      }
    }).catch((err: any) => {
      throw(err);
    });
  },

  [GET_QRCODE](
    context: { commit: Commit, state: State },
    payload: { sn: string, type: string}) {
    // 获取二维码
    getQrcode(payload.sn, payload.type).then((_data) => {
      const result = _data.data;
      if (result) {
        const taskID = setInterval(() => {
            getDeviceStatus(payload.sn).then((data) => {
              if( data.data && data.data.WeChat && data.data.status === '1' ) {
                window.clearInterval(context.state.taskID);
                context.commit(GET_WECHAT, data.data.WeChat);
              }
            });
          }, 1000);
        result.taskID = taskID;
        context.commit(GET_QRCODE, result);
      } else {
        Message.error(`获取二维码失败`);
      }
    }).catch((err) => {
      throw(err);
    });
  },


  [RESET_QRCODE](
    context: { commit: Commit, state: State }) {
    // 获取二维码
    context.commit(RESET_QRCODE, '');
  },

  [RESET_WECHATINFO](
    context: { commit: Commit, state: State }, data: any) {
    // 获取二维码
    context.commit(RESET_WECHATINFO, data);
  },

};

const mutations = {
  [GET_DEVICELIST](state: State, data: { list: any[]}) {
    state.deviceList = data.list.map( (x: any) => {
      const wechat = x.weChatInfo && x.weChatInfo.nickname ? x.weChatInfo.nickname : '未登录';
      return {
        label: x.deviceSN + '[' + wechat + ']',
        value: x.deviceSN + '[' + wechat + ']',
        weChatInfo: x.weChatInfo,
      };
    });
  },
  [GET_QRCODE](state: State, data: { qrcode: string, taskID: any }) {
    state.qrcode = data.qrcode;
    state.taskID = data.taskID;
  },
  [GET_WECHAT](state: State, data: any) {
    state.weChatInfo = data;
  },
  [RESET_QRCODE](state: State, data: any) {
    state.qrcode = data;
  },
  [RESET_WECHATINFO](state: State, data: any) {
    state.weChatInfo = data;
  },
};

export default {
  state: deviceState,
  actions,
  mutations,
};
