import { Commit } from 'vuex';
import { Message } from 'element-ui';

import { GET_TASKLIST, CREATE_TASK, GET_DETAILLIST, REMOVE_TASK } from '../types';
import { getTaskList, createTask, getDetailList, removeTask } from '@/api/addTask';


export interface State {
  dataList: any[];
  count: number;
  detailData: any;
  page: number;
  size: number;
}

const filterNumberState: State = {
  dataList: [],
  count: 0,
  page: 1,
  size: 10,
  detailData: {
    count: 0,
    page: 1,
    size: 10,
    dataList: [],
  },
};

const actions = {
  [GET_TASKLIST](
    context: { commit: Commit, state: State },
    payload: { size: number, page?: number },
  ) {
    // 获取角色列表
    getTaskList(payload.size, payload.page).then((data) => {
      const result = data.data;
      if (result.list) {
        context.commit(GET_TASKLIST, result);
      } else {
        Message.error(`获取数据失败`);
      }
    }).catch((err: any) => {
      throw(err);
    });
  },

  [REMOVE_TASK](
    context: { commit: Commit, state: State },
    payload: { id: string, update: string },
  ) {
    // 获取角色列表
    removeTask(payload.id,payload.update).then((data: any) => {
      Message.success(`更新成功`);
    }).catch((err: any) => {
      Message.error(`更新成功`);
      throw(err);
    });
  },

  [GET_DETAILLIST](
    context: { commit: Commit, state: State },
    payload: { size: number, taskWrapID: any, page: number },
  ) {
    getDetailList(payload.size, payload.page, payload.taskWrapID).then((data: any) => {
      const result = data.data;
      if (result.list) {
        context.commit(GET_DETAILLIST, result);
      } else {
        Message.error(`获取数据失败`);
      }
    }).catch((err: any) => {
      throw(err);
    });
  },

  [CREATE_TASK](
    context: { commit: Commit, state: State },
    payload: {
        count: number,
        id: string,
        user_id: string,
        greet: string,
        callback: any
    }) {
    createTask(payload).then((data) => {
      const result = data.data;
      context.commit(CREATE_TASK, result);
      Message.success('创建成功');
      if(payload.callback) payload.callback(null, result);
    }).catch((err) => {
      if(payload.callback) payload.callback('创建失败');
      throw(err);
    });
  },
};

const mutations = {
  [GET_TASKLIST](state: State, data: { list: any[], count: number, size: any, page: any }) {
    state.dataList = data.list.map( (x: any) => {
      return {
          name: x.code,
          wechatTotal: (x.weChatInfo && x.weChatInfo.nickname) ?  x.weChatInfo.nickname :  x.user_id,
          total: x.ids.length,
          online: x.weChatInfo,
          used: x.used || 0,
          createdAt: x.createdAt,
          _id: x._id,
          stop: x.stop,
        };
    });
    state.count = data.count;
    state.page = parseInt(data.page);
    state.size = parseInt(data.size || 10);
  },

  [GET_DETAILLIST](state: State, data: { list: any[], count: number, size: any, page: any }) {
    state.detailData.dataList = data.list.map( (x: any) => {
      return {
          number: x.phone,
          date: x.date || 0,
          callbackcode: x.status || 100,
        };
    });
    state.detailData.count = data.count;
    state.detailData.page = parseInt(data.page);
    state.detailData.size = parseInt(data.size || 10);
  },

  [CREATE_TASK](state: State, data: any) {
    state.dataList.unshift(data);
    state.count += 1;
  },
};

export default {
  state: filterNumberState,
  actions,
  mutations,
};
