import Vue from 'vue';
import App from './App.vue';
import router from './router';
import store from './store';
import './plugins/element.js';

Vue.config.productionTip = false;

store.dispatch('LOGIN', {
  sessionID: localStorage.getItem('__sessionID'),
  callback(err: any) {
    const State: any = store.state; 
    router.beforeEach((to, from, next) => {
      if (to.matched.some((record) => record.meta.requiresAuth)) {
        if (!State.login.isLogin) {
          next({ path: '/login', query: { redirect: to.fullPath } });
        } else {
          next();
        }
      } else {
        if (to.path === '/login' && State.login.isLogin) {
          next({ path: '/' });
        } else {
          next(); // 确保一定要调用 next()
        }
      }
    });

    /* eslint-disable no-new */
    new Vue({
	    router,
	    store,
	    render: (h) => h(App),
	  }).$mount('#app');
  },
});

