import axios from 'axios';

axios.defaults.withCredentials = true;

const getFilterList = (size: number, page?: number) => {
  return axios.get(`/api/search?page=${page}&size=${size}`);
};

const createFilterList = (
  form: {
    ageEnd: string,
    ageStart: string,
    consumptionDuring: string,
    consumptionEnd: string,
    consumptionStart: string,
    districts: any,
    dsgroup: string,
    flow: string,
    flowDuring: string,
    flowEnd: string,
    flowStart: string,
    sexlist: string,
  }) => {
  return axios.post(`api/model/query`, form);
};

const filterCount = (
  form: {
    name: string,
    desc: string,
    code: string,
  }) => {
  return axios.post(`api/model/count`, form);
};

export {
  getFilterList,
  createFilterList,
  filterCount,
};
