import { Commit } from 'vuex';
import { Message } from 'element-ui';

import { GET_FILTERLIST, CREATE_FILTERLIST, FILTERLIST_COUNT } from '../types';
import { getFilterList, createFilterList, filterCount } from '@/api/filterNumber';

interface PermissionAttribute {
  id?: string;
  name: string;
  code: string;
  desc?: string;
  status?: boolean;
  createdAt?: number;
  updatedAt?: number;
}

export interface State {
  dataList: any[];
  count: number;
  page: number;
  size: number;
  deviceList: any[];
}

const filterNumberState: State = {
  dataList: [],
  deviceList: [{ label: '1', value: '1'}],
  count: 0,
  page: 1,
  size: 10,
};

const actions = {
  [GET_FILTERLIST](
    context: { commit: Commit, state: State },
    payload: { size: number, page?: number },
  ) {
    getFilterList(payload.size, payload.page).then((data) => {
      const result = data.data;
      if (result) {
        context.commit(GET_FILTERLIST, result);
      } else {
        Message.error(`获取数据失败`);
      }
    }).catch((err) => {
      throw(err);
    });
  },

  [CREATE_FILTERLIST](
    context: { commit: Commit, state: State },
    payload: {
        ageEnd: string,
        ageStart: string,
        consumptionDuring: string,
        consumptionEnd: string,
        consumptionStart: string,
        districts: any,
        dsgroup: string,
        flow: string,
        flowDuring: string,
        flowEnd: string,
        flowStart: string,
        sexlist: string,
        callback: any,
    }) {
    // 筛选
    createFilterList(payload).then((data: any) => {
      Message.success('创建成功');
      if(payload.callback) payload.callback(null, data);
    }).catch((err: any) => {
      Message.error('创建失败');
      if(payload.callback) payload.callback(err);
      throw(err);
    });
  },

  [FILTERLIST_COUNT](
    context: { commit: Commit, state: State },
    payload: {
      name: string,
      desc: string,
      code: string,
    }) {
    // 筛选
    filterCount(payload).then((data) => {
      const result = data.data;
      if (result) {
        context.commit(FILTERLIST_COUNT, result);
        Message.success('筛选数量成功');
      } else {
        Message.error(data.data.msg);
      }
    }).catch((err) => {
      throw(err);
    });
  },
};

const mutations = {
  [GET_FILTERLIST](state: State, data: { list: any, count: number, size: any, page: any }) {
    state.dataList = data.list.map( (x: any) => {
      let filter = '';
      if( x.sexlist ) {
        filter += (x.sexlist.join('、') + '，');
      }
      if( x.ageStart && x.ageEnd ) {
        filter += ((x.ageStart + '-' + x.ageEnd) + '，');
      }
      if( x.districts ) {
        let cities:any = [];
        x.districts.forEach((x:any) => {
          cities = cities.concat(x.cities)
        })
        filter += (cities.join('、') + '，')
      }
      if( x.flowStart && x.flowEnd ) {
         filter += ((x.flowStart + '-' + x.flowEnd) + 'M，');
      }
      if( x.consumptionStart && x.consumptionEnd ) {
         filter += ((x.consumptionStart + '-' + x.consumptionEnd) + '元');
      }
      let total = x.respData && x.respData.total ? x.respData.total : 0;
      let count = x.respData && x.respData.customers ? x.respData.customers.length : 0;
      return {
        numberGroup: x.dsgroup,
        total: total,
        used: x.used || 0,
        count: count,
        _id: x._id,
        createdAt: x.createdAt || Date.now(),
        filterList: filter,
      };
    });
    state.count = data.count;
    state.page = parseInt(data.page);
    state.size = parseInt(data.size || 10);
  },

  /*[CREATE_FILTERLIST](state: State, data: PermissionAttribute) {
    state.dataList.unshift(data);
    state.count += 1;
  },
  
  [FILTERLIST_COUNT](state: State, data: PermissionAttribute) {
    state.dataList.unshift(data);
    state.count += 1;
  },*/
};

export default {
  state: filterNumberState,
  actions,
  mutations,
};
