import axios from 'axios';

axios.defaults.withCredentials = true;

const getDeviceList = () => {
  return axios.get(`/api/devices`);
};

const getQrcode = (sn: string, type: string) => {
  return axios.get(`/api/qrcode?sn=${sn}&type=${type}`);
};

const getDeviceStatus = (sn: string) => {
  return axios.get(`/api/is_login_wechat?sn=${sn}`);
};

export {
  getDeviceList,
  getQrcode,
  getDeviceStatus,
};
