import axios from 'axios';

axios.defaults.withCredentials = true;

const getTaskList = (size: number, page?: number) => {
  return axios.get(`/api/tasks?page=${page}&size=${size}`);
};

const removeTask = (id: string, update: string) => {
  return axios.get(`/api/task/update?id=${id}&update=${update}`);
};

const getDetailList = (size: number, page: number,  taskWrapID: string) => {
  return axios.get(`/api/task/detail?page=${page}&size=${size}&taskWrapID=${taskWrapID}`);
};

const createTask = (
  form: {
    count: number,
    id: string,
    user_id: string,
    greet: string,
  }) => {
  return axios.post(`api/task`, form);
};


export {
  getTaskList,
  createTask,
  getDetailList,
  removeTask
};
