const router = require("express").Router();
const mongodb = require("mongodb");
const MongoClient = mongodb.MongoClient;
const axios = require("axios");
const moment = require('moment');
const crypto = require('crypto');
const _ = require('lodash');
const qs = require('qs');


let db = {};
const dbpath = process.env.MONGO || "mongodb://127.0.0.1:27017/addwechat?poolSize=100000000";
const AuthName = 'l_q6KiRVG4200kwRXIwVfgY1yOIa';
const AuthPass = 'N11ztBU2lExdNOklH2AmX4JOzdIa';
const host =  process.env.GO || 'http://192.168.1.116:9912';
const deviceHost = process.env.DEVICE || 'http://192.168.1.122:9911';
//const host = "http://192.168.1.122:9912";
let authorition = '';
let access_token = null;
let tokenEndTime = 0;

const salt = "BreakingBad";
const SECRET = 'remarketing-token';
let myToken = '';
let wechatMap = {};

const map2Code = {
  'age': 'K000002',
  'sex': 'K000001',
  'flow_3': 'K003727',
  'flow_6': 'K003728',
  'consume_3': 'K003611',
  'consume_6': 'K003726',
  'city': 'K003681'
}
const city2code = { '北京': 'V0110000','天津': 'V0120000','上海': 'V0310000','重庆': 'V0500000','海口': 'V0460100','三亚': 'V0460200','保亭': 'V04602003','澄迈': 'V04601006','文昌': 'V04601003','临高': 'V04600032','五指山': 'V04602004','琼山': 'V04601001','昌江': 'V04600033','儋州': 'V0460003','陵水': 'V04602002','琼中': 'V04601008','屯昌': 'V04601007','万宁': 'V04601004','定安': 'V04601005','乐东': 'V04602001','琼海': 'V04601002','东方': 'V04600031','白沙': 'V04600034','广州': 'V0440100','汕尾': 'V0441500','阳江': 'V0441700','揭阳': 'V0445201','茂名': 'V0440901','江门': 'V0440700','韶关': 'V0440201','惠州': 'V0441300','梅州': 'V0441401','汕头': 'V0440510','深圳': 'V0440300','珠海': 'V0440400','佛山': 'V0440600','肇庆': 'V0441201','湛江': 'V0440800','中山': 'V0442000','河源': 'V0441600','清远': 'V0441800','云浮': 'V0441281','潮州': 'V0445100','东莞': 'V0441900','武汉': 'V0420100','襄樊': 'V0420600','鄂州': 'V0420700','孝感': 'V0420900','黄冈': 'V0422100','黄石': 'V0420200','咸宁': 'V0422300','荆州': 'V0422400','宜昌': 'V0420500','恩施': 'V0422800','十堰': 'V0422600','随州': 'V0420681','荆门': 'V0420800','江汉': 'V0422401','沈阳': 'V0210100','大连': 'V0210200','鞍山': 'V0210300','抚顺': 'V0210400','本溪': 'V0210500','丹东': 'V0210600','锦州': 'V0210700','营口': 'V0210800','阜新': 'V0210900','辽阳': 'V0211000','铁岭': 'V0211200','朝阳': 'V0211300','盘锦': 'V0211100','葫芦岛': 'V0211400','德宏': 'V0533100','文山': 'V0532600','保山': 'V0533000','临沧': 'V0533500','怒江傈': 'V0533300','迪庆': 'V0533400','昭通': 'V0532100','昆明': 'V0530100','红河': 'V0532500','大理': 'V0532900','丽江': 'V0533200','楚雄': 'V0532300','玉溪': 'V0532400','曲靖': 'V0532200','西双版纳': 'V0532800','普洱': 'V0533600','定西': 'V0622400','平凉': 'V0622700','庆阳': 'V0622800','武威': 'V0622300','张掖': 'V0622201','嘉峪关': 'V0620200','天水': 'V0620500','临夏': 'V0622901','白银': 'V0620400','金昌': 'V0620300','酒泉': 'V0622100','陇南': 'V0622600','甘南': 'V0623000','兰州': 'V0620100','呼和浩特': 'V0150100','包头': 'V0150200','乌海': 'V0150300','赤峰': 'V0150400','兴安': 'V0152200','通辽': 'V0152301','锡林郭勒': 'V0152500','乌兰察布': 'V0152600','鄂尔多斯': 'V0152700','巴彦淖尔': 'V0152800','阿拉善': 'V0152900','呼伦贝尔': 'V0152302','海拉尔': 'V0152101','贵阳': 'V0520100','遵义': 'V0522100','安顺': 'V0522500','铜仁': 'V0522200','毕节': 'V0522400','六盘水': 'V0520200','黔西南': 'V0522900','黔东南': 'V0523100','黔南': 'V0523200','郑州': 'V0410100','开封': 'V0410200','洛阳': 'V0410300','平顶山': 'V0410400','安阳': 'V0410500','鹤壁': 'V0410600','新乡': 'V0410700','焦作': 'V0410800','濮阳': 'V0410900','许昌': 'V0411000','漯河': 'V0411100','三门峡': 'V0411200','商丘': 'V0412300','周口': 'V0412700','驻马店': 'V0412801','南阳': 'V0412901','信阳': 'V0413000','济源': 'V0412800','杭州': 'V0330100','宁波': 'V0330200','温州': 'V0330300','台州': 'V0332600','金华': 'V0330700','嘉兴': 'V0330400','绍兴': 'V0330600','湖州': 'V0330500','丽水': 'V0332500','衢州': 'V0330800','舟山': 'V0330900','南京': 'V0320100','苏州': 'V0320500','无锡': 'V0320200','常州': 'V0320400','扬州': 'V0321000','镇江': 'V0321100','南通': 'V0320600','徐州': 'V0320300','泰州': 'V0321082','盐城': 'V0320900','淮安': 'V0320800','连云港': 'V0320700','宿迁': 'V0320881','长春': 'V0220100','吉林': 'V0220200','延边': 'V0222400','四平': 'V0220300','通化': 'V0220500','白城': 'V0220800','辽源': 'V0220400','松原': 'V0220700','白山': 'V0220600','西宁': 'V0630100','海东': 'V0632100','格尔木': 'V0632801','海北': 'V0632200','海南': 'V0632500','海西': 'V0632800','果洛': 'V0632600','玉树': 'V0632700','黄南': 'V0632300','拉萨': 'V0540100','日喀则': 'V0542300','山南': 'V0542200','林芝': 'V0542600','昌都': 'V0542100','那曲': 'V0542400','阿里': 'V0542500','长沙': 'V0430100','株洲': 'V0430200','湘潭': 'V0430300','衡阳': 'V0430400','岳阳': 'V0430600','益阳': 'V0430900','郴州': 'V0431000','常德': 'V0430700','娄底': 'V0432500','邵阳': 'V0430500','湘西': 'V0433100','张家界': 'V0430800','怀化': 'V0431200','永州': 'V0431100','福州': 'V0350100','厦门': 'V0350200','泉州': 'V0350500','漳州': 'V0350600','宁德': 'V0352200','莆田': 'V0350300','南平': 'V0352100','三明': 'V0350400','龙岩': 'V0352600','成都': 'V0510100','自贡': 'V0510300','攀枝花': 'V0510400','泸州': 'V0510500','德阳': 'V0510600','绵阳': 'V0510700','广元': 'V0510800','遂宁': 'V0510900','内江': 'V0511000','乐山': 'V0511100','南充': 'V0511300','眉山': 'V0513800','宜宾': 'V0512500','广安': 'V0513600','达州': 'V0513000','雅安': 'V0513100','巴中': 'V0513700','资阳': 'V0513900','阿坝': 'V0513200','甘孜': 'V0513300','凉山': 'V0513400','东川': 'V0530200','乌鲁木齐': 'V0650100','克拉玛依': 'V0650200','吐鲁番': 'V0652101','哈密': 'V0652201','昌吉': 'V0652301','博尔塔拉': 'V0650300','巴音郭楞': 'V0650500','阿克苏': 'V0652901','克孜勒苏': 'V0650600','喀什': 'V0653101','和田': 'V0653201','奎屯': 'V0654001','伊犁': 'V0650400','塔城': 'V0654201','阿勒泰': 'V0654301','石河子': 'V0659001','南昌': 'V0360100','九江': 'V0360400','上饶': 'V0362233','抚州': 'V0362500','宜春': 'V0362200','吉安': 'V0362400','赣州': 'V0362100','景德镇': 'V0360200','萍乡': 'V0360300','新余': 'V0360500','鹰潭': 'V0360600','马鞍山': 'V0340500','蚌埠': 'V0340300','安庆': 'V0340800','芜湖': 'V0340200','六安': 'V0342400','合肥': 'V0340100','阜阳': 'V0342100','淮南': 'V0340400','铜陵': 'V0340700','宣城': 'V0342500','滁州': 'V0341100','宿州': 'V0342200','淮北': 'V0340600','黄山': 'V0341000','池州': 'V0342900','亳州': 'V0343000','巢湖': 'V0342600','朔州': 'V0140600','忻州': 'V0142200','太原': 'V0140100','大同': 'V0140200','阳泉': 'V0140300','晋中': 'V0142400','长治': 'V0140400','晋城': 'V0140500','临汾': 'V0142600','吕梁': 'V0142300','运城': 'V0142700','邯郸': 'V0130400','保定': 'V0130600','张家口': 'V0130700','唐山': 'V0130200','沧州': 'V0130900','邢台': 'V0130500','秦皇岛': 'V0130300','石家庄': 'V0130100','承德': 'V0130800','廊坊': 'V0131000','衡水': 'V0133000','银川': 'V0640100','吴忠': 'V0642100','石嘴山': 'V0640200','固原': 'V0642200','中卫': 'V0642300','宝鸡': 'V0610300','西安': 'V0610100','延安': 'V0612601','渭南': 'V0612101','咸阳': 'V0610400','榆林': 'V0612701','铜川': 'V0610200','商洛': 'V0612501','安康': 'V0612401','汉中': 'V0612301','南宁': 'V0450100','桂林': 'V0450300','柳州': 'V0450200','梧州': 'V0450400','玉林': 'V0452500','百色': 'V0452600','钦州': 'V0452800','河池': 'V0452700','北海': 'V0450500','崇左': 'V0453200','贺州': 'V0453000','贵港': 'V0452900','防城港': 'V0450600','来宾': 'V0453100','哈尔滨': 'V0230100','齐齐哈尔': 'V0230200','牡丹江': 'V0231000','佳木斯': 'V0230800','绥化': 'V0232300','大庆': 'V0230600','鸡西': 'V0230300','黑河': 'V0231100','伊春': 'V0230700','双鸭山': 'V0230500','鹤岗': 'V0230400','七台河': 'V0230900','大兴安岭': 'V0232700','济南': 'V0370100','青岛': 'V0370200','淄博': 'V0370300','枣庄': 'V0370400','东营': 'V0370500','烟台': 'V0370600','潍坊': 'V0370700','济宁': 'V0370800','泰安': 'V0370900','威海': 'V0371000','日照': 'V0371100','莱芜': 'V0371200','临沂': 'V0372801','德州': 'V0372401','聊城': 'V0372500','滨州': 'V0372300','菏泽': 'V0372900' }

//initAuthorization();
// TODO ! put into init
MongoClient.connect(dbpath, (err, conn) => {
  if (err) 
  return console.log(err);console.log("#### DB CONNECTED");
  db = conn.db(process.env.MONGO_DB || "addwechat");
  initMongo();
  db
    .collection("session")
    .createIndex({ createdAt: 1 }, { expireAfterSeconds: 3600 * 24 });
});


function initMongo() {
  db.collection('account').findOne({username: 'admin'},(e,r) => {
    if(e || !r) {
      db.collection('account').update({ username: 'admin'},{ $set: { password: md5password('123asd') } }, { upsert: 1},(err,rep) => {
        console.dir(err);
        console.dir(rep.result);
      })
    }
  });
}


function initAuthorization() {
  let b = new Buffer(AuthName + ':' + AuthPass);
  let s = b.toString('base64');
  authorition =  "Basic" + s;
  console.dir(authorition);
}


setInterval(() => {
  //console.dir(' in setInterval');
  axios(deviceHost + '/get_device', {
    method: "GET",
    headers: { "Content-Type": "application/json" },
    timeout: 300000
  })
  .then(async rep => {
    refreshOnlineMap(rep.data.msg.list)
  })
  .catch(err => {
    devicelist = [];
    wechatMap = {};
  });
},1000 * 60 * 3 );


function refreshOnlineMap(devices) {
  for(var k in devices) {
    if(devices[k].weChatInfo && devices[k].weChatInfo.wechatId) {
        wechatMap[devices[k].weChatInfo.wechatId] = devices[k].weChatInfo;
    }
  }
  //console.dir(wechatMap);
}

router.get('/ping',async function (req, res) {
  //let a = await generateToken();
  res.send({ status: 'ok' });
})

router.get('/search',async (req, res) => {
  let { page = 1, size = 10 } = req.query;
  if(page > 0) page -= 1;
  let options = { skip: parseInt(page * size), limit: parseInt(size) };
  let count = await db.collection('filters').count({})
  db.collection('filters').find({})
    .sort({createdAt: -1})
    .skip(parseInt(page * size))
    .limit(parseInt(size))
    .toArray(async (err,rep) => {
      let arrs =  await getCount(rep)
      if(err) return res.status(500).json({ error: '数据获取错误' });
      else return res.status(200).json({ count, list: arrs, page: parseInt(page || 0) + 1, size: parseInt(size || 10) });
  });
})

router.get('/qrcode',async (req, res) => {
  let {  sn, type='get' } = req.query;
  axios(deviceHost + (type='get' ? '/get_qr_code/' : 're_qr_code') + sn, {
    method: "GET",
    headers: { "Content-Type": "application/json" },
    timeout: 300000
  })
  .then(async rep => {
    console.dir(rep.data.msg)
    if(rep.data && rep.data.msg && rep.data.msg.qrcode) {
      //console.dir(rep.data.msg.qrcode);
      res.status(200).json({ qrcode: 'data:image/png;base64,' + rep.data.msg.qrcode });
    } else{
      //res.status(200).json({ qrcode: 'data:image/png;base64,' + "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" });
      res.status(500).json({ error: rep.data.errorCode === 1000 ? '设备离线,稍后重试' : '获取失败,稍后重试'});
    }
  })
  .catch(err => {
    console.dir(err);
    if (err) return res.status(500).json({ error: '获取失败'});
  });
})


router.get('/tasks',async (req, res) => {
  let { page = 1, size = 10 } = req.query;
  if(page > 0) page -= 1;
  let options = { skip: parseInt(page * size), limit: parseInt(size) };
  let count = await db.collection('taskWrap').count({})
  db.collection('taskWrap').find({})
    .sort({createdAt: -1})
    .skip(parseInt(page * size))
    .limit(parseInt(size))
    .toArray(async (err,rep) => {
      if(err) return res.status(500).json({ error: '数据获取错误' });
      else {
        let arrs = await getOkCount(rep);
        arrs = arrs.map( x => {
          x.weChatInfo = wechatMap[x.user_id]
          return x;
        });
        console.dir(arrs);
        return res.status(200).json({ count, list: arrs, page: parseInt(page || 0) + 1, size: parseInt(size || 10) });
      }
  });
})

router.get('/task/update',(req, res) => {
  let { id, update } = req.query;
  let update_body = {};
  if(update == 'stop') {
    update_body['$set'] = { stop: 1 };
  } else {
    update_body['$unset'] = { stop: 1 };
  }
  console.dir(update_body);
  db.collection('taskWrap').update({_id: OID(id)}, update_body, (err,rep) => {
    if(err) return res.status(500).json({ error: '更新失败,刷新查看' });
    else {
      db.collection('tasks').update({taskWrapID: OID(id)}, update_body, {multi: 1},(error,rep) => {
        if(error) return res.status(500).json({ error: '更新失败，刷新查看' });
        else res.status(200).json({ status: 'ok' }); 
      });
    }
  });
})


router.get('/task/detail',async (req, res) => {
  let { page = 1, size = 10 , taskWrapID = null} = req.query;
  if(page > 0) page -= 1;
  let options = { skip: parseInt(page * size), limit: parseInt(size) };
  let count = await db.collection('tasks').count({ taskWrapID: OID(taskWrapID) })
  db.collection('tasks').find({ taskWrapID: OID(taskWrapID) })
    .sort({createdAt: -1})
    .skip(parseInt(page * size))
    .limit(parseInt(size))
    .toArray(async (err,rep) => {
      rep = rep.map( x => { delete x.wechat_id; let phone =  (x.phone || ['*']);  x.phone = phone[0] + '*********' +  phone[phone.length - 1]; return x;});
      if(err) return res.status(500).json({ error: '数据获取错误' });
      else return res.status(200).json({ count, list: rep, page: parseInt(page || 0) + 1, size: parseInt(size || 10) });
  });
})


function getNum(total,num) {
  let s = ''
  for (var i = 0; i < total - (num + '').length; i++) {
    s += '0';
  }
  return s + num;
}


router.post("/task", async function(req, res) {
  let { count, id, user_id, greet } = req.body;
  if(!id) return res.status(500).json({ error: '参数错误'});
  let { respData } = await db.collection('filters').findOne({ _id: OID(id) });
  let task_count = await db.collection('tasks').count({ filterID: OID(id) });
  let customers = [];
  if( respData.customers && respData.customers.length ) {
    customers = respData.customers.slice(task_count, parseInt(count) + task_count)
  }
  let data = customers.map( x => {
    return {
      user_id : user_id,
      date : moment().format('YYYYMMDD'),
      greet : greet,
      phone : x,
      wechat_id: x,
      filterID: OID(id)
    }
  })
  db.collection('tasks').insertMany(data, async (err,rep) => {
   if (err) return res.status(500).json({ error: '服务器错误'});
   else {
    let ids = []
    if(rep && rep.ops) {
      ids = rep.ops.map( x => x._id);
      let code = getNum(6, await db.collection('taskWrap').count());
      db.collection('taskWrap').insert({
        code,
        createdAt: Date.now(),
        user_id,
        greet,
        filterID: id,
        ids
      },async (err,rep) => {
        if(rep.ops[0]._id) { 
         let _rep = await db.collection('tasks').update({ _id:{ $in: ids} },{ $set: { taskWrapID: rep.ops[0]._id }},{ multi: 1})
         res.status(200).json(_rep);
        }
        else res.status(500).json({ error: '数据异常'});
      });
    }
   }
  })
});


async function getCount(arrays) {
    let tasks = [];
    arrays.forEach((x) => {
        tasks.push(new Promise(async (r,e) => {
          const count = (x._id) ? await db
            .collection("tasks")
            .count({ filterID: x._id }) : 0;
            r(_.merge(x, { used: count } ));   
        }));
    });
    const arrs = await Promise.all(tasks);
    return arrs;
}


async function getOkCount(arrays) {
    let tasks = [];
    arrays.forEach((x) => {
        tasks.push(new Promise(async (r,e) => {
          const count = (x._id) ? await db
            .collection("tasks")
            .count({ taskWrapID: x._id, status: { $exists: 1} }) : 0;
            r(_.merge(x, { used: count } ));   
        }));
    });
    const arrs = await Promise.all(tasks);
    return arrs;
}



router.get('/is_login_wechat/',async (req, res) => {
  let {  sn } = req.query;
  axios(deviceHost + '/is_login_wechat/' + sn, {
    method: "GET",
    headers: { "Content-Type": "application/json" },
    timeout: 300000
  })
  .then(async rep => {
    if(rep.data && rep.data.msg) {
      res.status(200).json(rep.data.msg);
    } else{
      res.status(500).json({ error: rep.data.errorCode === 1000 ? '设备离线,稍后重试' : '获取失败,稍后重试'});
    }
  })
  .catch(err => {
    console.dir(err);
    if (err) return res.status(500).json({ error: '获取失败'});
  });
})


router.post('/remove',async (req, res) => {
  let collection = req.body.collection;
  let query = req.body.query;
  let rep = await db
            .collection(collection)
            .remove(query);
  return res.status(200).json(rep);
});

router.get('/devices',async (req, res) => {
  console.dir(deviceHost);
  axios(deviceHost + '/get_device', {
    method: "GET",
    headers: { "Content-Type": "application/json" },
    timeout: 300000
  })
  .then(async rep => {
    console.dir(rep.data);
    if(rep.data && rep.data.msg && rep.data.msg.list) {
      res.status(200).json({ list: rep.data.msg.list });
    } else{
      res.status(500).json({ error: rep.data.errorCode === 1000 ? '设备离线,稍后重试' : '获取失败,稍后重试'});
    }
  })
  .catch(err => {
    console.dir(err);
    if (err) return res.status(500).json({ error: '获取失败'});
  });
})



// generateToken();

async function generateToken() {
  let timeNow = Math.floor(Date.now() / 1000);
    console.dir('begin token');
    return new Promise((r,e) => {
      axios(host + '/getAuth', {
        method: "POST",
        data: qs.stringify({
          AuthName,
          AuthPass
        }),
        headers: { 
          "Content-type": "application/x-www-form-urlencoded",
          "Authorization": authorition
         }
      })
      .then(rep => {
        if( rep && rep.data && rep.data.access_token ) {
          access_token = access_token;
          tokenEndTime = Date.now() + parseInt(rep.data.expires_in) * 1000
          r(rep.data);
        } else {
          e('not known error');
        }
      })
      .catch(err => {
        e(err);
      });
  });
}


function generateRequestID() {
  let num = '';
  for(let i=0; i<4; i++){
    num += Math.floor(Math.random()*10);
  }
  return `U200000` + moment().format('YYYYMMDDHHmmss') +  num;
}


router.post("/login", function(req, res) {
  // check sessionID
  checkSession(req.body, (err, rep) => {
    if (err) return res.sendStatus(500);
    if (!rep) {
      //没有符合的session
      return authorize(req.body, (err, rep) => {
        if (err) return  res.status(500).json({ error: '账户或密码错误' });
        if (!rep) return res.status(403).json({ error: '账户或密码错误' });
        //验证通过
        const account = _.merge(rep, { sessionID: genSessionID(rep._id) });
        delete account.password;
        res.send({ status: "ok", account });
      });
    } else {
      db
        .collection("account")
        .findOne({ _id: OID(rep.accountID) }, (err, rep) => {
          if (err || !rep) return res.status(500).json({ error: '账户或密码错误' });
          const account = _.merge(rep, { sessionID: req.body.sessionID });
          delete account.password;
          res.send({ status: "ok", account });
        });
    }
  });
});


function generateQueryModel (body) {
  let attrs = [];
  let age = [];
  let consumption = [];
  let flow = [];
  let sex = [];
  let areas = [];
  let { ageEnd, ageStart, consumptionDuring, consumptionEnd, consumptionStart, districts, dsgroup, flowDuring, flowEnd, flowStart, sexlist } = body;
  if(!isNaN(ageEnd) && !isNaN(ageStart)) {
    age = [{ attrCode: map2Code['age'], relation: 5, attrValue: ageEnd, condition: 'and' },{ attrCode: map2Code['age'], relation: 3, attrValue: ageStart, condition: 'and' }];
    attrs= attrs.concat(age);
  }

  if(!isNaN(consumptionStart) && !isNaN(consumptionEnd)) {
    if(consumptionDuring === '近三月平均') {
      consumption = [{ attrCode: map2Code['consume_3'], relation: 5, attrValue: consumptionEnd, condition: 'and' },{ attrCode: map2Code['consume_3'], relation: 3, attrValue: consumptionStart, condition: 'and' }];
    } else {
      consumption = [{ attrCode: map2Code['consume_6'], relation: 5, attrValue: consumptionEnd, condition: 'and' },{ attrCode: map2Code['consume_3'], relation: 3, attrValue: consumptionStart, condition: 'and' }];
    }
    attrs= attrs.concat(consumption);
  }

  if(!isNaN(flowStart) && !isNaN(flowEnd)) {
    if(flowDuring === '近三月平均') {
      flow = [{ attrCode: map2Code['flow_3'], relation: 5, attrValue: flowEnd, condition: 'and' },{ attrCode: map2Code['flow_3'], relation: 3, attrValue: flowStart, condition: 'and' }];
    } else {
      flow = [{ attrCode: map2Code['flow_6'], relation: 5, attrValue: flowEnd, condition: 'and' },{ attrCode: map2Code['consume_3'], relation: 3, attrValue: flowStart, condition: 'and' }];
    }
    attrs= attrs.concat(flow);
  }

  if( sexlist && sexlist.indexOf('男') >= 0 ) {
    sex.push({ attrCode: map2Code['sex'], relation: 1, attrValue: '01', condition: 'or' });
  }

  if( sexlist && sexlist.indexOf('女') >= 0 ) {
    sex.push({ attrCode: map2Code['sex'], relation: 1, attrValue: '02', condition: 'or' });
  }
  if( sex.length ) attrs= attrs.concat(sex);
  if(districts) {
    districts.forEach( x => {
      x.cities.forEach( y => {
        areas.push({ attrCode: map2Code['city'], relation: 1, attrValue: city2code[y], condition: 'or' })
      })
    })
  }
  if( areas.length ) attrs = attrs.concat(areas);
  if(attrs.length) {
    attrs[attrs.length - 1].condition = 'and';
  }
  return attrs;
}

router.post("/model/query", function(req,res) {
  checkSession(req.body, async (err,result) => {
    if(!err) {
      let { access_token } = await generateToken();
      console.dir(access_token);
      let model = generateQueryModel(req.body);
      axios(host + '/modelUserListQuery', {
        method: "POST",
        data: JSON.stringify({
          requestId: generateRequestID(),
          queryModel: [{ attrList: model, groupCondition: 'and' },{
            attrList: [{
              "attrCode":"K003638",
              "relation":8,
              "attrValue":"90AAAAAA"
            }]
          }]
        }),
        timeout: 1000 * 60 * 10,
        headers: {
          "Content-Type": "application/x-www-form-urlencoded",
          "Authorization": access_token
        }
      })
      .then(rep => {
        console.dir(rep.data);
        if(rep && rep.data && rep.data.respData) {
          rep.data.createdAt = Date.now(); 
          db.collection('filters').insert(_.merge(rep.data,req.body),(err,rep) => {
            if(err) return res.status(500).json({ error: '数据存储错误' });
            else return res.status(200).json(rep.data);
          });
        } else {
          return res.status(500).json({ error: '请求数据错误' });
        }
      })
      .catch(err => {
        return res.status(500).json({ error: '请求错误' });
      });
    } else return res.status(500).json({ error: '请先登录再操作' });
  })
});



router.post("/logout",function(req,res) {
  let { sessionID } = req.body;
  db
    .collection('session')
    .remove({ _id: OID(sessionID) }, (err, rep) => {
      if(err || !rep) return res.sendStatus(500);
      res.send({ status: "ok", rep });
    });
});



function checkSession(data, callback) {
  if (!data.sessionID) return callback(null);
  db
    .collection("session")
    .findOne({ sessionID: OID(data.sessionID) }, (err, rep) => {
      if (err || !rep) return callback(err, null);
      callback(null, rep);
    });
}


function authorize(data, callback) {
  db.collection("account").findOne({ username: data.username }, (err, rep) => {
    if (err || !rep) return callback(err, null);
    if (md5password(data.password) !== rep.password)
      return callback("password wrong", null);
    callback(null, rep);
  });
}

function genSessionID(accountID) {
  const sessionID = mongodb.ObjectID();
  db.collection("session").insert(
    {
      createdAt: new Date(),
      sessionID,
      accountID
    },
    (err, rep) => {
      if (err) console.log(err);
    }
  );

  return sessionID;
}

function md5password(str) {
  const salt = ",tom";
  const hash = crypto
    .createHash("md5")
    .update(str + salt)
    .digest()
    .toString("hex");
  return hash;
}

function OID(str) {
  return  typeof str === 'string' ? mongodb.ObjectID(str) : str;
}


module.exports =  {
  router
}