const db = require('../db');
const xlsx = require('node-xlsx').default;
const fs = require('fs');
const _ = require('lodash');
const moment = require('moment');
const INFINITE = 10000000000000000000;
async function task(argument) {
  const agent = await db.getAgentCollection('account');
  const tokens = await db.getCollection('tokens');
  const new_tokens = await db.getNewCollection('tokens');

  //let agents = agent.find();
  let _tokens = await tokens.find({}).limit(INFINITE).toArray();

  for(token of _tokens) {
    let { phone, token: password, _id,  passwd, saleGroupId, removed, createdAt, updatedAt, nickname, accountID} = token
    if(!removed) {
      let data = {
        _id,
        account: db.ObjectID(accountID),
        phone,
        password,
        createdAt,
        updatedAt: updatedAt || createdAt
      }
      if(saleGroupId) data.salegroup = db.ObjectID(saleGroupId)
      if(nickname) data.nickname = nickname;
      await new_tokens.insert(data);
    }
  }
}

function ISODateRange(date) {
    const startAt = moment(date).format(`YYYY-MM-DD 00:00:00`)
        , endAt = moment(date).add(1, 'd').format(`YYYY-MM-DD 00:00:00`)
    return [new Date(startAt), new Date(endAt)];
}

task();


