var a = [{"p":"直辖市","c":["北京","天津","上海","重庆"]},{"p":"河北","c":["石家庄","唐山","秦皇岛","邯郸","邢台","保定","张家口","承德","沧州","廊坊","衡水"]},{"p":"山西","c":["太原","大同","阳泉","长治","晋城","朔州","晋中","运城","忻州","临汾","吕梁"]},{"p":"内蒙古","c":["呼和浩特","包头","乌海","赤峰","通辽","鄂尔多斯","呼伦贝尔","巴彦淖尔","乌兰察布","兴安","锡林郭勒","阿拉善"]},{"p":"辽宁","c":["沈阳","大连","鞍山","抚顺","本溪","丹东","锦州","营口","阜新","辽阳","盘锦","铁岭","朝阳","葫芦岛"]},{"p":"吉林","c":["长春","吉林","四平","辽源","通化","白山","松原","白城","延边"]},{"p":"黑龙江","c":["哈尔滨","齐齐哈尔","鸡西","鹤岗","双鸭山","大庆","伊春","佳木斯","七台河","牡丹江","黑河","绥化","大兴安岭"]},{"p":"江苏","c":["南京","无锡","徐州","常州","苏州","南通","连云港","淮安","盐城","扬州","镇江","泰州","宿迁"]},{"p":"浙江","c":["杭州","宁波","温州","嘉兴","湖州","绍兴","金华","衢州","舟山","台州","丽水"]},{"p":"安徽","c":["合肥","芜湖","蚌埠","淮南","马鞍山","淮北","铜陵","安庆","黄山","滁州","阜阳","宿州","巢湖","六安","亳州","池州","宣城"]},{"p":"福建","c":["福州","厦门","莆田","三明","泉州","漳州","南平","龙岩","宁德"]},{"p":"江西","c":["南昌","景德镇","萍乡","九江","新余","鹰潭","赣州","吉安","宜春","抚州","上饶"]},{"p":"山东","c":["济南","青岛","淄博","枣庄","东营","烟台","潍坊","济宁","泰安","威海","日照","莱芜","临沂","德州","聊城","滨州","菏泽"]},{"p":"河南","c":["郑州","开封","洛阳","平顶山","安阳","鹤壁","新乡","焦作","濮阳","许昌","漯河","三门峡","南阳","商丘","信阳","周口","驻马店","济源"]},{"p":"湖北","c":["武汉","黄石","十堰","宜昌","襄樊","鄂州","荆门","孝感","荆州","黄冈","咸宁","随州","恩施","仙桃","潜江","天门","神农架"]},{"p":"湖南","c":["长沙","株洲","湘潭","衡阳","邵阳","岳阳","常德","张家界","益阳","郴州","永州","怀化","娄底","湘西"]},{"p":"广东","c":["广州","韶关","深圳","珠海","汕头","佛山","江门","湛江","茂名","肇庆","惠州","梅州","汕尾","河源","阳江","清远","东莞","中山","潮州","揭阳","云浮"]},{"p":"广西","c":["南宁","柳州","桂林","梧州","北海","防城港","钦州","贵港","玉林","百色","贺州","河池","来宾","崇左"]},{"p":"海南","c":["海口","三亚","五指山","琼海","儋州","文昌","万宁","东方"]},{"p":"四川","c":["成都","自贡","攀枝花","泸州","德阳","绵阳","广元","遂宁","内江","乐山","南充","眉山","宜宾","广安","达川","雅安","巴中","资阳","阿坝","甘孜","凉山"]},{"p":"贵州","c":["贵阳","六盘水","遵义","安顺","铜仁","黔西南","毕节","黔东南","黔南"]},{"p":"云南","c":["昆明","曲靖","玉溪","保山","昭通","丽江","普洱","临沧","楚雄","红河","文山","西双版纳","大理","德宏","怒江傈","迪庆"]},{"p":"西藏","c":["拉萨","昌都","山南","日喀则","那曲","阿里","林芝"]},{"p":"陕西","c":["西安","铜川","宝鸡","咸阳","渭南","延安","汉中","榆林","安康","商洛"]},{"p":"甘肃","c":["兰州","嘉峪关","金昌","白银","天水","武威","张掖","平凉","酒泉","庆阳","定西","陇南","临夏","甘南"]},{"p":"青海","c":["西宁","海东","海北","黄南","海南","果洛","玉树","梅西"]},{"p":"宁夏","c":["银川","石嘴山","吴忠","固原","中卫"]},{"p":"新疆","c":["乌鲁木齐","克拉玛依","吐鲁番","哈密","昌吉","博尔塔拉","巴音郭楞","阿克苏","克孜勒苏","喀什","和田","伊犁","塔城","阿勒泰","石河子","阿拉尔","图木舒克","五家渠"]},{"p":"地区","c":["香港","澳门","台湾"]}]
let map = {};
a.forEach(x => {
	let p = x.p ;
	x.c.forEach( y => {
		map[y] = (p === '直辖市' ? y : p);
	});
});
const db = require('../db');
const xlsx = require('node-xlsx').default;
const fs = require('fs');
const _ = require('lodash');
const moment = require('moment');
async function task(argument) {
  const bills = await db.getCollection('bills');
  const group = await db.getCollection('dspCallGroups');
  let group_arrs = await group.find({}).limit(1000000000000).toArray();
  let groupMap = {};
  let agentcompanyMap = {}
  group_arrs.forEach((data) => {
    if(data && data._id) {
     groupMap[data._id + ''] = data;
    }
  })
  let _count = 0;
  let query = { _id : {'$in' : [
 "5bf639b62e4fb2000782715c",
"5bf4fba52e4fb20007826ffb",
"5bf4d1d92e4fb20007826fb4",
"5bf4ce2a2e4fb20007826fa7",
"5bf38c8e2e4fb20007826da4",
"5bf3719c2e4fb20007826cdb",
"5bf36dc52e4fb20007826cb7",
"5bf368cb2e4fb20007826c91",
"5bf3666e2e4fb20007826c7c",
"5bf35c112e4fb20007826c3a",
"5bf25a1e2e4fb20007826b15",
"5bf22c502e4fb20007826a94",
"5bf2191a2e4fb20007826a28",
"5bee77a7e3ec3033c82d7ff2",
"5bee3dfe2e4fb200078266f1",
"5bee3c092e4fb200078266e4",
"5bee36e82e4fb200078266bd",
"5bee2e7e2e4fb200078266a4",
"5bee2e532e4fb200078266a0",
"5bee2777c5ed930007209d93",
"5bed5b85c5ed930007209d0a",
"5bed47f8c5ed930007209cf6",
"5bed22e8e17798293e8d883c",
"5bed1eedc5ed930007209c0c",
"5bece2f2537c8d0007db60b1",
"5becde87537c8d0007db60a1",
"5becdaf3537c8d0007db6085",
"5beaaf4c537c8d0007db5d94",
"5bea8eb8537c8d0007db5ce8",
"5bea3997232b830007e19cfc",
"5bea2af7232b830007e19c6c",
"5be95630232b830007e19bc7",
"5be93109232b830007e19b06",
"5be8e3bd232b830007e199bf"].map( x => db.ObjectID(x) )}}
  console.dir(query);
  let arrs = await bills.find(query).limit(1000000000000).toArray();
  let data = [['任务名称','类型','客户筛选标签','省分','城市']];
  console.dir(arrs.length + '====>');
  arrs.forEach( async ({ _id, groupID }) => {
    let group = groupMap[groupID];
    _count ++;
    if(group) {
    	let areas = [];
    	let citylist = group.citylist || [];
    	let provincelist = group.provincelist || [];
    	let cityMap = {};
    	citylist.forEach( x => {
    		provincelist = provincelist.concat(map[x]);
    		cityMap[map[x]] = (cityMap[map[x]] || []).concat(x)
    	});
    	provincelist.forEach( x => {
    		areas.push([x, (cityMap[x] || []).join(',') ])
    	})
    	

    	let interestlist = group.interestlist || [];
    	let applist = group.applist || [];
    	let hostlist = group.hostlist || []

    	areas.forEach( x => {
    		interestlist.forEach( y => {
    			data.push([_id + '', '关键字', y ].concat(x))
    		})
    		applist.forEach( z => {
    			data.push([_id + '', 'APP', z ].concat(x))
    		})
    		hostlist.forEach( m => {
    			data.push([_id + '', '域名', m ].concat(x))
    		})
    	})
    }
    if(_count === arrs.length) {

        var buffer = xlsx.build([{name: "mySheetName", data: data}]);
        fs.writeFile('./area1.xlsx', buffer, function(err) {
          console.dir(err + '====>')
              if (err) {
                  throw err;
              }
              console.log('Hello.');
        });
    }


  });

}


task();


