const db = require('../db');
const xlsx = require('node-xlsx').default;
const fs = require('fs');
const _ = require('lodash');
const moment = require('moment');
const INFINITE = 1000000000;
async function task(argument) {
  const clues = await db.getNewCollection('clues');
  const calltasks = await db.getNewCollection('calltasks');
  const orders = await db.getNewCollection('orders');
  //const analysis = await db.getCollection('analysis');
  
  let agents = await db.getNewCollection('agent_caches');
  let _agents = await agents.find({}).limit(1000000).toArray();
  let accounts = await db.getNewCollection('accounts');
  let _accounts = await accounts.find({role:1}).limit(1000000).toArray();
  //let _calltasks = await calltasks.find({duration:{$gt:0}}).limit(100000000).toArray();
  let _orders = await orders.find({}).limit(1000000).toArray();
  let agentMap = {};
  let accountMap = {};

  let orderMap = {};
  let provinceMap = {};
  let aMap = {};
  let agMap = {};
  let oMap = {}
  for(let a of _agents){
  	let { _id } = a;
  	agentMap[_id + ''] = a;
  }

  for(let a of _accounts){
  	let { _id, discount } = a;
  	let agent = discount ? (discount.junior || discount.agent) : null;
  	accountMap[_id + ''] = a;
  	if(agent) accountMap[_id + ''].agent = agent ? agentMap[ agent.id + '' ]: null;
  }

  for(let o of _orders) {
  	oMap[o._id + ''] = o.code || o._id + ''; 
  }

  //console.dir(accountMap);
  
  let _count = 0;
  let _c = 0
  let map = {};
  /*for(let c of _calltasks) {
  	let { account, unikey } = c;
  	await clues.update({ unikey, account: db.ObjectID(account) }, {
  		$set:{
  			ping: true
  		}
  	});
  	console.dir(_c ++ );
  }*/
  let _clues = await clues.find({type:"group"}).limit(INFINITE).toArray();
  let unikeys = [['unikey', '账户', '代理商', '来源', '拨打次数', '是否拨通', '系统标签', '自定义标签', '备注', '订单编号']]
  
  console.dir(_clues.length + '==条数据');
  for(clue of _clues) {
    let { unikey, account, selfTag, remark, key, app, host, systemTag, order, province, from, calledHistory, ping } = clue;
    //let orderObj = await orders.findOne({ _id: db.ObjectID(order) });
    /*let tasks = await calltasks.find({ unikey, account }).limit(10000).toArray();
    let duration = 0;
    if(tasks && tasks.length) {
    	for(let task of tasks) {
    		duration += (task.duration || 0)
    	} 	
    }*/
    let orderID = oMap[order] || (order + '');
    let data = {
      tall:0,
      tfavor:0,
      tpinged:0,
      tmark:0,
      tcalled:0,
    	all: 0,
    	favor: 0,
    	pinged: 0,
    	called: 0,
      mark: 0,
    	ctccall: 0,
    	ctccfavor: 0,
    	ctccpinged: 0,
    	ctcccalled: 0,
      ctccmark: 0,
    }
    let a = (accountMap[account + ''] ? accountMap[account + ''].company : '-');
    let agent =  (accountMap[account + ''] && accountMap[account + ''].agent ? accountMap[account + ''].agent.company: '-');
    unikeys.push([unikey,a, agent, (from == 'ctcc' ? '电信' : '联通'), calledHistory.length, (ping ? '是' : '否'), systemTag, selfTag, remark, orderID])
    let favor = (systemTag == '有意向'  ? 1 : 0);
    //let mark = ((systemTag && systemTag.length) || (selfTag && selfTag.length) || (remark && remark.length)) ? 1 : 0;
    let pinged = ping ? 1 : 0;
    let mark = pinged ? (((systemTag && systemTag.length) || (selfTag && selfTag.length) || (remark && remark.length)) ? 1 : 0) : 0;
    let called = calledHistory && calledHistory.length ? 1 : 0;
    if(from == 'ctcc') {
    	data.ctccall = 1;
      data.ctccmark = mark;
    	data.ctccfavor = favor;
    	data.ctcccalled = called;
    	data.ctccpinged = pinged;
    } else {
    	data.all = 1;
      data.mark = mark;
    	data.favor = favor;
    	data.called = called;
    	data.pinged = pinged;
    }

    data.tall = 1;
    data.tmark = mark;
    data.tfavor = favor;
    data.tcalled = called;
    data.tpinged = pinged;

    setObj(aMap, account + '', data);
    setObj(orderMap, orderID + '', data);
    setObj(provinceMap, province + '', data);
    console.dir('处理第' + (_count++) + '条数据' );
  }

  let s = unikeys.length;
  let a = [];
  for(let i = 0; i++; i < Math.ceil(s/10000)){
    let buffer = xlsx.build([{name: "mySheetName", data: unikeys.splice(i*10000,(i+1)*10000)}]);
    fs.writeFile('./详表'+ i +'.xlsx', buffer, function(err) {
      console.dir(err + '====>')
          if (err) {
              throw err;
          }
          console.log('Hello.' + i);
    });
  }
  

  let as = [['账户','代理商','联通线索','联通拨打线索','联通拨通线索','联通意向线索','联通接通率','联通接通标记率','联通接通意向率','电信线索','电信拨打线索','电信拨通线索','电信意向线索','电信接通率','电信接通标记率','电信接通意向率','总接通率','总标记率','总意向率']];
  for(let k of Object.keys(aMap)) {
  	let {
      tall=0,
      tfavor=0,
      tpinged=0,
      tmark=0,
      tcalled=0,
    	all=0,
    	favor=0,
    	pinged=0,
      mark=0,
    	called=0,
    	ctccall=0,
    	ctccfavor=0,
    	ctccpinged=0,
      ctccmark=0,
    	ctcccalled=0
    } = aMap[k];
    let r = (all == 0 ? 0 : (pinged / all))
    let rm = (pinged == 0 ? 0 : (mark / pinged))
    let rgood = (pinged == 0 ? 0 : (favor / pinged))
    let cr = (ctccall == 0 ? 0 : (ctccpinged / ctccall))
    let crm = (ctccpinged == 0 ? 0 : (ctccmark / ctccpinged))
    let crgood = (ctccpinged == 0 ? 0 : (ctccfavor / ctccpinged))

    let tr = (tall == 0 ? 0 : (tpinged / tall))
    let trm = (tpinged == 0 ? 0 : (tmark / tpinged))
    let trgood = (tpinged == 0 ? 0 : (tfavor / tpinged))
    as.push([ (accountMap[k] ? accountMap[k].company : '-'), (accountMap[k] && accountMap[k].agent ? accountMap[k].agent.company: '-') ,all, called, pinged, favor, r, rm,rgood, ctccall, ctcccalled, ctccpinged, ctccfavor, cr, crm, crgood, tr, trm, trgood])
    console.dir('===')
  }
	console.dir('===go')
  let buffer = xlsx.build([{name: "mySheetName", data: as}]);
	fs.writeFile('./按账户分析.xlsx', buffer, function(err) {
	  console.dir(err + '====>')
	      if (err) {
	          throw err;
	      }
	      console.log('Hello1.');
	});

	let os = [['订单id','联通线索','联通拨打线索','联通拨通线索','联通意向线索','联通接通率','联通接通标记率','联通接通意向率','电信线索','电信拨打线索','电信拨通线索','电信意向线索','电信接通率','电信接通标记率','电信接通意向率','总接通率','总标记率','总意向率']];
	for(let k of Object.keys(orderMap)) {
  	let {
      tall=0,
      tfavor=0,
      tpinged=0,
      tmark=0,
      tcalled=0,
      all=0,
      favor=0,
      pinged=0,
      mark=0,
      called=0,
      ctccall=0,
      ctccfavor=0,
      ctccpinged=0,
      ctccmark=0,
      ctcccalled=0
    } = orderMap[k];
    let r = (all == 0 ? 0 : (pinged / all))
    let rm = (pinged == 0 ? 0 : (mark / pinged))
    let rgood = (pinged == 0 ? 0 : (favor / pinged))
    let cr = (ctccall == 0 ? 0 : (ctccpinged / ctccall))
    let crm = (ctccpinged == 0 ? 0 : (ctccmark / ctccpinged))
    let crgood = (ctccpinged == 0 ? 0 : (ctccfavor / ctccpinged))

    let tr = (tall == 0 ? 0 : (tpinged / tall))
    let trm = (tpinged == 0 ? 0 : (tmark / tpinged))
    let trgood = (tpinged == 0 ? 0 : (tfavor / tpinged))

    os.push([ k, all, called, pinged, favor, r, rm,rgood, ctccall, ctcccalled, ctccpinged, ctccfavor, cr, crm, crgood, tr, trm, trgood])
    console.dir('===1')
  }
console.dir('===1go'  )
  let buffer1 = xlsx.build([{name: "mySheetName", data: os}]);
	fs.writeFile('./按订单ID分析.xlsx', buffer1, function(err) {
	  console.dir(err + '====>')
	      if (err) {
	          throw err;
	      }
	      console.log('Hello2.');
	});
let ps = [['省份','联通线索','联通拨打线索','联通拨通线索','联通意向线索','联通接通率','联通接通标记率','联通接通意向率','电信线索','电信拨打线索','电信拨通线索','电信意向线索','电信接通率','电信接通标记率','电信接通意向率','总接通率','总标记率','总意向率']];
	
for(let k of Object.keys(provinceMap)) {
  	let {
      tall=0,
      tfavor=0,
      tpinged=0,
      tmark=0,
      tcalled=0,
      all=0,
      favor=0,
      pinged=0,
      mark=0,
      called=0,
      ctccall=0,
      ctccfavor=0,
      ctccpinged=0,
      ctccmark=0,
      ctcccalled=0
    } = provinceMap[k];
    let r = (all == 0 ? 0 : (pinged / all))
    let rm = (pinged == 0 ? 0 : (mark / pinged))
    let rgood = (pinged == 0 ? 0 : (favor / pinged))
    let cr = (ctccall == 0 ? 0 : (ctccpinged / ctccall))
    let crm = (ctccpinged == 0 ? 0 : (ctccmark / ctccpinged))
    let crgood = (ctccpinged == 0 ? 0 : (ctccfavor / ctccpinged))

    let tr = (tall == 0 ? 0 : (tpinged / tall))
    let trm = (tpinged == 0 ? 0 : (tmark / tpinged))
    let trgood = (tpinged == 0 ? 0 : (tfavor / tpinged))
    ps.push([ k, all, called, pinged, favor, r, rm,rgood, ctccall, ctcccalled, ctccpinged, ctccfavor, cr, crm, crgood, tr, trm, trgood])
    console.dir('===2')
  }
console.dir('===2go')
  let buffer2 = xlsx.build([{name: "mySheetName", data: ps}]);
	fs.writeFile('./按省份分析.xlsx', buffer2, function(err) {
	  console.dir(err + '====>')
	      if (err) {
	          throw err;
	      }
	      console.log('Hello3.');
	});
}


function setObj(target, key, Obj ) {
    if(target[ key ]) {
        for(var k in Obj) {
            if(Array.isArray(Obj[k])) target[ key ][ k ] =  (target[ key ][ k ] || []).concat(Obj[k] || []); 
            else target[ key ][ k ] = (target[ key ][ k ] || 0 ) + (Obj[k] || 0)
        }
    } else {
        target[ key ] = Obj;
    }
}

function ISODateRange(date) {
    const startAt = moment(date).format(`YYYY-MM-DD 00:00:00`)
        , endAt = moment(date).add(1, 'd').format(`YYYY-MM-DD 00:00:00`)
    return [new Date(startAt), new Date(endAt)];
}

task();


