
import styles from './document.css';
import { Tabs, Table } from 'antd';
import Highlight from 'react-highlight'
import 'highlight.js/styles/atom-one-light.css';
//import prettyprint from 'prettyprint';
var pretty = require('prettyprintjs')

const TabPane = Tabs.TabPane;

	const cp = [{"value":"内蒙古","label":"内蒙古","children":[{"value":"呼伦贝尔","label":"呼伦贝尔"},{"value":"呼和浩特","label":"呼和浩特"},{"value":"乌海","label":"乌海"},{"value":"兴安盟","label":"兴安盟"},{"value":"海拉尔","label":"海拉尔"},{"value":"赤峰","label":"赤峰"},{"value":"包头","label":"包头"},{"value":"通辽","label":"通辽"},{"value":"阿盟","label":"阿盟"},{"value":"巴彦淖尔","label":"巴彦淖尔"},{"value":"鄂尔多斯","label":"鄂尔多斯"},{"value":"乌兰察布","label":"乌兰察布"},{"value":"锡林郭勒","label":"锡林郭勒"}]},{"value":"山东","label":"山东","children":[{"value":"济南","label":"济南"},{"value":"淄博","label":"淄博"},{"value":"青岛","label":"青岛"},{"value":"枣庄","label":"枣庄"},{"value":"滨州","label":"滨州"},{"value":"莱芜","label":"莱芜"},{"value":"日照","label":"日照"},{"value":"威海","label":"威海"},{"value":"泰安","label":"泰安"},{"value":"济宁","label":"济宁"},{"value":"潍坊","label":"潍坊"},{"value":"烟台","label":"烟台"},{"value":"东营","label":"东营"},{"value":"菏泽","label":"菏泽"},{"value":"临沂","label":"临沂"},{"value":"聊城","label":"聊城"},{"value":"德州","label":"德州"}]},{"value":"安徽","label":"安徽","children":[{"value":"合肥","label":"合肥"},{"value":"芜湖","label":"芜湖"},{"value":"蚌埠","label":"蚌埠"},{"value":"亳州","label":"亳州"},{"value":"池州","label":"池州"},{"value":"巢湖","label":"巢湖"},{"value":"宣城","label":"宣城"},{"value":"六安","label":"六安"},{"value":"宿州","label":"宿州"},{"value":"阜阳","label":"阜阳"},{"value":"滁州","label":"滁州"},{"value":"黄山","label":"黄山"},{"value":"安庆","label":"安庆"},{"value":"铜陵","label":"铜陵"},{"value":"淮北","label":"淮北"},{"value":"马鞍山","label":"马鞍山"},{"value":"淮南","label":"淮南"}]},{"value":"浙江","label":"浙江","children":[{"value":"杭州","label":"杭州"},{"value":"湖州","label":"湖州"},{"value":"嘉兴","label":"嘉兴"},{"value":"温州","label":"温州"},{"value":"宁波","label":"宁波"},{"value":"绍兴","label":"绍兴"},{"value":"台州","label":"台州"},{"value":"丽水","label":"丽水"},{"value":"舟山","label":"舟山"},{"value":"衢州","label":"衢州"},{"value":"金华","label":"金华"}]},{"value":"广东","label":"广东","children":[{"value":"广州","label":"广州"},{"value":"韶关","label":"韶关"},{"value":"揭阳","label":"揭阳"},{"value":"潮州","label":"潮州"},{"value":"中山","label":"中山"},{"value":"东莞","label":"东莞"},{"value":"清远","label":"清远"},{"value":"阳江","label":"阳江"},{"value":"河源","label":"河源"},{"value":"汕尾","label":"汕尾"},{"value":"梅州","label":"梅州"},{"value":"惠州","label":"惠州"},{"value":"云浮","label":"云浮"},{"value":"肇庆","label":"肇庆"},{"value":"茂名","label":"茂名"},{"value":"湛江","label":"湛江"},{"value":"江门","label":"江门"},{"value":"佛山","label":"佛山"},{"value":"汕头","label":"汕头"},{"value":"珠海","label":"珠海"},{"value":"深圳","label":"深圳"}]},{"value":"湖北","label":"湖北","children":[{"value":"武汉","label":"武汉"},{"value":"宜昌","label":"宜昌"},{"value":"黄石","label":"黄石"},{"value":"襄阳","label":"襄阳"},{"value":"恩施","label":"恩施"},{"value":"十堰","label":"十堰"},{"value":"江汉","label":"江汉"},{"value":"荆州","label":"荆州"},{"value":"咸宁","label":"咸宁"},{"value":"黄冈","label":"黄冈"},{"value":"孝感","label":"孝感"},{"value":"荆门","label":"荆门"},{"value":"鄂州","label":"鄂州"},{"value":"随州","label":"随州"}]},{"value":"河南","label":"河南","children":[{"value":"郑州","label":"郑州"},{"value":"洛阳","label":"洛阳"},{"value":"开封","label":"开封"},{"value":"平顶山","label":"平顶山"},{"value":"商丘","label":"商丘"},{"value":"三门峡","label":"三门峡"},{"value":"漯河","label":"漯河"},{"value":"许昌","label":"许昌"},{"value":"濮阳","label":"濮阳"},{"value":"焦作","label":"焦作"},{"value":"新乡","label":"新乡"},{"value":"鹤壁","label":"鹤壁"},{"value":"安阳","label":"安阳"},{"value":"信阳","label":"信阳"},{"value":"南阳","label":"南阳"},{"value":"济源","label":"济源"},{"value":"驻马店","label":"驻马店"},{"value":"周口","label":"周口"}]},{"value":"重庆","label":"重庆","children":[{"value":"重庆","label":"重庆"}]},{"value":"云南","label":"云南","children":[{"value":"西双版纳","label":"西双版纳"},{"value":"昆明","label":"昆明"},{"value":"东川","label":"东川"},{"value":"昭通","label":"昭通"},{"value":"曲靖","label":"曲靖"},{"value":"楚雄","label":"楚雄"},{"value":"玉溪","label":"玉溪"},{"value":"红河","label":"红河"},{"value":"文山","label":"文山"},{"value":"普洱","label":"普洱"},{"value":"大理","label":"大理"},{"value":"保山","label":"保山"},{"value":"德宏","label":"德宏"},{"value":"丽江","label":"丽江"},{"value":"怒江","label":"怒江"},{"value":"迪庆","label":"迪庆"},{"value":"临沧","label":"临沧"}]},{"value":"新疆","label":"新疆","children":[{"value":"乌鲁木齐","label":"乌鲁木齐"},{"value":"克拉玛依","label":"克拉玛依"},{"value":"博州","label":"博州"},{"value":"伊犁","label":"伊犁"},{"value":"巴州","label":"巴州"},{"value":"克州","label":"克州"},{"value":"吐鲁番","label":"吐鲁番"},{"value":"哈密","label":"哈密"},{"value":"昌吉","label":"昌吉"},{"value":"阿克苏","label":"阿克苏"},{"value":"喀什","label":"喀什"},{"value":"和田","label":"和田"},{"value":"奎屯","label":"奎屯"},{"value":"塔城","label":"塔城"},{"value":"阿勒泰","label":"阿勒泰"},{"value":"石河子","label":"石河子"}]},{"value":"黑龙江","label":"黑龙江","children":[{"value":"哈尔滨","label":"哈尔滨"},{"value":"鸡西","label":"鸡西"},{"value":"大庆","label":"大庆"},{"value":"双鸭山","label":"双鸭山"},{"value":"鹤岗","label":"鹤岗"},{"value":"齐齐哈尔","label":"齐齐哈尔"},{"value":"伊春","label":"伊春"},{"value":"大兴安岭","label":"大兴安岭"},{"value":"绥化","label":"绥化"},{"value":"黑河","label":"黑河"},{"value":"牡丹江","label":"牡丹江"},{"value":"七台河","label":"七台河"},{"value":"佳木斯","label":"佳木斯"}]},{"value":"北京","label":"北京","children":[{"value":"北京","label":"北京"}]},{"value":"河北","label":"河北","children":[{"value":"石家庄","label":"石家庄"},{"value":"秦皇岛","label":"秦皇岛"},{"value":"唐山","label":"唐山"},{"value":"邯郸","label":"邯郸"},{"value":"衡水","label":"衡水"},{"value":"廊坊","label":"廊坊"},{"value":"沧州","label":"沧州"},{"value":"承德","label":"承德"},{"value":"张家口","label":"张家口"},{"value":"保定","label":"保定"},{"value":"邢台","label":"邢台"}]},{"value":"上海","label":"上海","children":[{"value":"上海","label":"上海"}]},{"value":"福建","label":"福建","children":[{"value":"福州","label":"福州"},{"value":"厦门","label":"厦门"},{"value":"三明","label":"三明"},{"value":"南平","label":"南平"},{"value":"漳州","label":"漳州"},{"value":"泉州","label":"泉州"},{"value":"莆田","label":"莆田"},{"value":"宁德","label":"宁德"},{"value":"龙岩","label":"龙岩"}]},{"value":"广西","label":"广西","children":[{"value":"南宁","label":"南宁"},{"value":"柳州","label":"柳州"},{"value":"梧州","label":"梧州"},{"value":"玉林","label":"玉林"},{"value":"防城港","label":"防城港"},{"value":"北海","label":"北海"},{"value":"桂林","label":"桂林"},{"value":"百色","label":"百色"},{"value":"崇左","label":"崇左"},{"value":"来宾","label":"来宾"},{"value":"贺州","label":"贺州"},{"value":"贵港","label":"贵港"},{"value":"钦州","label":"钦州"},{"value":"河池","label":"河池"}]},{"value":"湖南","label":"湖南","children":[{"value":"长沙","label":"长沙"},{"value":"株洲","label":"株洲"},{"value":"衡阳","label":"衡阳"},{"value":"常德","label":"常德"},{"value":"岳阳","label":"岳阳"},{"value":"邵阳","label":"邵阳"},{"value":"湘潭","label":"湘潭"},{"value":"张家界","label":"张家界"},{"value":"湘西自治州","label":"湘西自治州"},{"value":"娄底","label":"娄底"},{"value":"怀化","label":"怀化"},{"value":"永州","label":"永州"},{"value":"郴州","label":"郴州"},{"value":"益阳","label":"益阳"}]},{"value":"西藏","label":"西藏","children":[{"value":"拉萨","label":"拉萨"},{"value":"昌都","label":"昌都"},{"value":"山南","label":"山南"},{"value":"日喀则","label":"日喀则"},{"value":"那曲","label":"那曲"},{"value":"阿里","label":"阿里"},{"value":"林芝","label":"林芝"}]},{"value":"陕西","label":"陕西","children":[{"value":"其他","label":"其他"},{"value":"西安","label":"西安"},{"value":"铜川","label":"铜川"},{"value":"宝鸡","label":"宝鸡"},{"value":"咸阳","label":"咸阳"},{"value":"渭南","label":"渭南"},{"value":"汉中","label":"汉中"},{"value":"安康","label":"安康"},{"value":"商洛","label":"商洛"},{"value":"延安","label":"延安"},{"value":"榆林","label":"榆林"}]},{"value":"甘肃","label":"甘肃","children":[{"value":"兰州","label":"兰州"},{"value":"嘉峪关","label":"嘉峪关"},{"value":"金昌","label":"金昌"},{"value":"白银","label":"白银"},{"value":"天水","label":"天水"},{"value":"酒泉","label":"酒泉"},{"value":"张掖","label":"张掖"},{"value":"武威","label":"武威"},{"value":"定西","label":"定西"},{"value":"陇南","label":"陇南"},{"value":"平凉","label":"平凉"},{"value":"庆阳","label":"庆阳"},{"value":"临夏","label":"临夏"},{"value":"甘南","label":"甘南"}]},{"value":"吉林","label":"吉林","children":[{"value":"长春","label":"长春"},{"value":"吉林","label":"吉林"},{"value":"辽源","label":"辽源"},{"value":"松原","label":"松原"},{"value":"白山","label":"白山"},{"value":"通化","label":"通化"},{"value":"四平","label":"四平"},{"value":"白城","label":"白城"},{"value":"延边","label":"延边"}]},{"value":"天津","label":"天津","children":[{"value":"天津","label":"天津"}]},{"value":"山西","label":"山西","children":[{"value":"太原","label":"太原"},{"value":"临汾","label":"临汾"},{"value":"晋中","label":"晋中"},{"value":"吕梁","label":"吕梁"},{"value":"忻州","label":"忻州"},{"value":"朔州","label":"朔州"},{"value":"晋城","label":"晋城"},{"value":"长治","label":"长治"},{"value":"阳泉","label":"阳泉"},{"value":"大同","label":"大同"},{"value":"运城","label":"运城"}]},{"value":"江苏","label":"江苏","children":[{"value":"南京","label":"南京"},{"value":"无锡","label":"无锡"},{"value":"扬州","label":"扬州"},{"value":"盐城","label":"盐城"},{"value":"宿迁","label":"宿迁"},{"value":"淮安","label":"淮安"},{"value":"连云港","label":"连云港"},{"value":"南通","label":"南通"},{"value":"苏州","label":"苏州"},{"value":"常州","label":"常州"},{"value":"徐州","label":"徐州"},{"value":"镇江","label":"镇江"},{"value":"泰州","label":"泰州"}]},{"value":"海南","label":"海南","children":[{"value":"琼海","label":"琼海"},{"value":"文昌","label":"文昌"},{"value":"万宁","label":"万宁"},{"value":"定安","label":"定安"},{"value":"澄迈","label":"澄迈"},{"value":"屯昌","label":"屯昌"},{"value":"琼中","label":"琼中"},{"value":"三亚","label":"三亚"},{"value":"琼山","label":"琼山"},{"value":"海口","label":"海口"},{"value":"白沙","label":"白沙"},{"value":"昌江","label":"昌江"},{"value":"临高","label":"临高"},{"value":"东方","label":"东方"},{"value":"儋州","label":"儋州"},{"value":"乐东","label":"乐东"},{"value":"陵水","label":"陵水"},{"value":"保亭","label":"保亭"},{"value":"五指山","label":"五指山"}]},{"value":"青海","label":"青海","children":[{"value":"西宁","label":"西宁"},{"value":"海东地区","label":"海东地区"},{"value":"海北自治州","label":"海北自治州"},{"value":"黄南自治州","label":"黄南自治州"},{"value":"海南自治州","label":"海南自治州"},{"value":"果洛自治州","label":"果洛自治州"},{"value":"玉树自治州","label":"玉树自治州"},{"value":"海西自治州","label":"海西自治州"},{"value":"格尔木","label":"格尔木"}]},{"value":"江西","label":"江西","children":[{"value":"南昌","label":"南昌"},{"value":"萍乡","label":"萍乡"},{"value":"鹰潭","label":"鹰潭"},{"value":"新余","label":"新余"},{"value":"九江","label":"九江"},{"value":"景德镇","label":"景德镇"},{"value":"赣州","label":"赣州"},{"value":"抚州","label":"抚州"},{"value":"吉安","label":"吉安"},{"value":"上饶","label":"上饶"},{"value":"宜春","label":"宜春"}]},{"value":"四川","label":"四川","children":[{"value":"成都","label":"成都"},{"value":"自贡","label":"自贡"},{"value":"攀枝花","label":"攀枝花"},{"value":"泸州","label":"泸州"},{"value":"德阳","label":"德阳"},{"value":"绵阳","label":"绵阳"},{"value":"广元","label":"广元"},{"value":"遂宁","label":"遂宁"},{"value":"内江","label":"内江"},{"value":"乐山","label":"乐山"},{"value":"南充","label":"南充"},{"value":"宜宾","label":"宜宾"},{"value":"达州","label":"达州"},{"value":"雅安","label":"雅安"},{"value":"阿坝自治州","label":"阿坝自治州"},{"value":"甘孜自治州","label":"甘孜自治州"},{"value":"凉山自治州","label":"凉山自治州"},{"value":"广安","label":"广安"},{"value":"巴中","label":"巴中"},{"value":"眉山","label":"眉山"},{"value":"资阳","label":"资阳"}]},{"value":"贵州","label":"贵州","children":[{"value":"贵阳","label":"贵阳"},{"value":"六盘水","label":"六盘水"},{"value":"遵义","label":"遵义"},{"value":"铜仁","label":"铜仁"},{"value":"黔西南州","label":"黔西南州"},{"value":"毕节","label":"毕节"},{"value":"安顺","label":"安顺"},{"value":"黔东南州","label":"黔东南州"},{"value":"黔南州","label":"黔南州"}]},{"value":"宁夏","label":"宁夏","children":[{"value":"银川","label":"银川"},{"value":"石嘴山","label":"石嘴山"},{"value":"吴忠","label":"吴忠"},{"value":"固原","label":"固原"},{"value":"中卫","label":"中卫"}]},{"value":"辽宁","label":"辽宁","children":[{"value":"沈阳","label":"沈阳"},{"value":"大连","label":"大连"},{"value":"鞍山","label":"鞍山"},{"value":"葫芦岛","label":"葫芦岛"},{"value":"朝阳","label":"朝阳"},{"value":"铁岭","label":"铁岭"},{"value":"盘锦","label":"盘锦"},{"value":"辽阳","label":"辽阳"},{"value":"阜新","label":"阜新"},{"value":"营口","label":"营口"},{"value":"锦州","label":"锦州"},{"value":"丹东","label":"丹东"},{"value":"本溪","label":"本溪"},{"value":"抚顺","label":"抚顺"}]}];
	let citys = [];
	let provinces =[];
	cp.forEach( x => {
		citys = citys.concat(x.children.map( x => x.value));
		provinces.push(x.value);
	});
	let json = pretty({
		citys, provinces
	});
	const error = pretty({
		code: '错误码',
		message: '错误信息'
	})
	const result = pretty({
        ANSWERED: "通话成功",
        BUSY: "被叫忙",
        NO_ANSWER: "被叫无应答",
        REJECT: "被叫拒接",
        HANGUP: "主叫提前挂机",
        INVALID_NUMBER: "空号",
        POWER_OFF: "关机",
        UNAVAILABLE: "暂时无法接听",
        SUSPEND: "停机",
        TP_NO_BINDING: "无绑定关系",
        TP_TIMEOUT: "号码查询接口超时",
        BLACK: "黑名单号码",
        TP_ERROR: "号码查询接口解析错误",
        CALLED_BLACK: "被叫不支持",
        CALLED_FORWARD: "呼叫转移",
        OTHER: "其他失败情形",
    });
	const columns = [{
	  title: '参数',
	  dataIndex: 'params',
	  key: 'params',
	}, {
	  title: '是否必须',
	  dataIndex: 'need',
	  key: 'need',
	}, {
	  title: '类型',
	  dataIndex: 'type',
	  key: 'type',
	},{
	  title: '示例',
	  dataIndex: 'example',
	  key: 'example',
	},{
	  title: '描述',
	  dataIndex: 'descrip',
	  key: 'descrip',
	}];

	const returnColumns = [{
	  title: '名称',
	  dataIndex: 'name',
	  key: 'name',
	}, {
	  title: '类型',
	  dataIndex: 'type',
	  key: 'type',
	}, {
	  title: '示例',
	  dataIndex: 'example',
	  key: 'example',
	},{
	  title: '描述',
	  dataIndex: 'descrip',
	  key: 'descrip',
	}];

	const metaColumns = [{
	  title: '1',
	  dataIndex: 'key',
	  key: 'key',
	  width: '25%'
	}, {
	  title: '2',
	  dataIndex: 'value',
	  key: 'value',
	}];

	const dataSource = {
		auth: [{
			title: '认证接口',
			meta: [{
			  key: '接口路径',
			  value: '/api/token'
			}, {
			  key: '返回类型',
			  value: 'JSON'
			}, {
			  key: '请求方法',
			  value: 'POST'
			}, {
			  key: '特殊说明',
			  value: '合作伙伴需要传递zyxKey 和 zyxSecret，进行鉴权，返回 session 及其session过期日期并及时更新最新session，其他请求需要在header添加{ Authorization : "Bearer  " +session} 进行鉴权;'
			}, {
			  key: '授权参数',
			  value: '不需要'
			}],
			params: [{
			  key: '1',
			  params: 'zyxKey',
			  need: '是',
			  type: 'string',
			  example: 'opKey',
			  descrip: 'zyxKey'
			}, {
			  key: '2',
			  params: 'zyxSecret',
			  need: '是',
			  type: 'string',
			  example: 'Lhxr68ChR7s7rnWL',
			  descrip: 'zyxSecret'
			}],
			returnData: [{
			  key: '1',
			  name: 'session',
			  type: 'string',
			  example: 'eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9.eyJfaWQiOiI1YzhhMTY5NzJhODdmMTFhZWVhYjc4YzYiLCJ6eXhLZXkiOiJvcEtleTEiLCJ6eXhTZWNyZXQiOiI0OTY1MzMyN2RiMDViNmU2MTFhY2RiYjZjYjI3MGE1NCIsImlhdCI6MTU1Mjg3NDY2NywiZXhwIjoxNTUzNDc5NDY3fQ.WuM3K6mhktIeRWfwuvC5H6dACYW1T_E1LKX0Rjzzvb4',
			  descrip: '返回session'
			}],
			returnExample: pretty({ status: "ok",result: { session: "eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9.eyJfaWQiOiI1YzhhMTY5NzJhODdmMTFhZWVhYjc4YzYiLCJ6eXhLZXkiOiJvcEtleTEiLCJ6eXhTZWNyZXQiOiI0OTY1MzMyN2RiMDViNmU2MTFhY2RiYjZjYjI3MGE1NCIsImlhdCI6MTU1Mjg3NDY2NywiZXhwIjoxNTUzNDc5NDY3fQ.WuM3K6mhktIeRWfwuvC5H6dACYW1T_E1LKX0Rjzzvb4" } })
		}],
		url: [{
			title: '预测接口',
			meta: [{
			  key: '接口路径',
			  value: '/api/url/list'
			}, {
			  key: '返回类型',
			  value: 'JSON'
			}, {
			  key: '请求方法',
			  value: 'POST'
			}, {
			  key: '特殊说明',
			  value: '根据地区和url进行数据分布预测，以辅助画像创建和下单'
			}, {
			  key: '授权参数',
			  value: '需要'
			}],
			params: [{
			  key: '1',
			  params: 'url',
			  need: '是',
			  type: 'Array',
			  example: '["xiaoyun.com","goyoo.com"]',
			  descrip: '域名数组'
			}, {
			  key: '2',
			  params: 'province',
			  need: '否',
			  type: 'string',
			  example: '北京市',
			  descrip: '域名数组'
			}],
			returnData: [{
			  key: '1',
			  name: 'name',
			  type: 'string',
			  example: 'baidu.com',
			  descrip: 'url'
			},{
			  key: '2',
			  name: 'code',
			  type: 'string',
			  example: '000225D6',
			  descrip: '域名编码'
			},{
			  key: '3',
			  name: 'count',
			  type: 'string',
			  example: '513332',
			  descrip: '在城市的数量分布，设备数'
			},{
			  key: '4',
			  name: 'province',
			  type: 'string',
			  example: '上海',
			  descrip: '城市'
			}],
			returnExample: pretty({"status":"ok","result":{"urls":[{"_id":"5c448c88c39bbf243612a280","name":"baidu.com","code":"000225D6","count":"513332","province":"上海"}]}})
		}],
		user: [{
			title: '创建直客',
			meta: [{
			  key: '接口路径',
			  value: '/api/user/create'
			}, {
			  key: '返回类型',
			  value: 'JSON'
			}, {
			  key: '请求方法',
			  value: 'POST'
			}, {
			  key: '特殊说明',
			  value: '创建直客账户，直客是最终使用线索的主体，需要进行资质备案和话术备案，线索的去重也是根据直客进行的'
			}, {
			  key: '授权参数',
			  value: '需要'
			}],
			params: [{
			  key: '1',
			  params: 'licenses',
			  need: '是',
			  type: 'Array',
			  example: '["license-pics-1552013717815.png"]',
			  descrip: '资质照数组，需要传递到 { host }/upload 地址，返回文件名称，上传流程参考 { host }/upload/demo'
			}, {
			  key: '2',
			  params: 'company',
			  need: '是',
			  type: 'string',
			  example:'北京微聚合信息技术有限公司',
			  descrip: '公司名称'
			}, {
			  key: '3',
			  params: 'report',
			  need: '否',
			  type: 'string',
			  example: '您好,.....',
			  descrip: '话术报备'
			}, {
			  key: '4',
			  params: 'phone',
			  need: '否',
			  type: 'string',
			  example: '13522110373',
			  descrip: '联系电话'
			}, {
			  key: '5',
			  params: 'name',
			  need: '否',
			  type: 'string',
			  example: '张三',
			  descrip: '联系人'
			}],
			returnData: [{
			  key: '0',
			  name: '_id',
			  type: 'string',
			  example: '5c82269d16ce5f1af321cede',
			  descrip: '直客ID'
			},{
			  key: '1',
			  name: 'licenses',
			  type: 'Array',
			  example: '["license-pics-1552013717815.png"]',
			  descrip: '资质照数组，需要传递到 { host }/upload 地址，返回文件名称，上传流程参考 { host }/upload/demo'
			}, {
			  key: '2',
			  name: 'company',
			  type: 'string',
			  example:'北京微聚合信息技术有限公司',
			  descrip: '公司名称'
			}, {
			  key: '3',
			  name: 'report',
			  type: 'string',
			  example: '您好,.....',
			  descrip: '话术报备'
			}, {
			  key: '4',
			  name: 'phone',
			  type: 'string',
			  example: '13522110373',
			  descrip: '联系电话'
			}, {
			  key: '5',
			  name: 'name',
			  type: 'string',
			  example: '张三',
			  descrip: '联系人'
			}],
			returnExample: pretty({
			    "status": "ok",
			    "result": {
			        "user": {
			            "licenses": [
			                "license-pics-1552013717815.png"
			            ],
			            "_id": "5c90a52c42869a166dad31e5",
			            "company": "opSecret1",
			            "name": "张三",
			            "phone": "12522110373",
			            "report": "您好,.....",
			            "account": "5c8a16972a87f11aeeab78c6",
			            "createdAt": "2019-03-19T08:15:40.102Z",
			            "updatedAt": "2019-03-19T08:15:40.102Z",
			            "__v": 0
			        }
			    }
			})
		},{
			title: '获取直客',
			meta: [{
			  key: '接口路径',
			  value: '/api/user/list'
			}, {
			  key: '返回类型',
			  value: 'JSON'
			}, {
			  key: '请求方法',
			  value: 'POST'
			}, {
			  key: '特殊说明',
			  value: '获取直客列表'
			}, {
			  key: '授权参数',
			  value: '需要'
			}],
			params: [{
			  key: '1',
			  params: 'limit',
			  need: '否',
			  type: 'number',
			  example: 10,
			  descrip: '默认10'
			}, {
			  key: '2',
			  params: 'skip',
			  need: '否',
			  type: 'numbers',
			  example:0,
			  descrip: '默认10'
			}],
			returnData: [{
			  key: '0',
			  name: '_id',
			  type: 'string',
			  example: '5c82269d16ce5f1af321cede',
			  descrip: '直客ID'
			},{
			  key: '1',
			  name: 'licenses',
			  type: 'Array',
			  example: '["license-pics-1552013717815.png"]',
			  descrip: '资质照数组，需要传递到 { host }/upload 地址，返回文件名称，上传流程参考 { host }/upload/demo'
			}, {
			  key: '2',
			  name: 'company',
			  type: 'string',
			  example:'北京微聚合信息技术有限公司',
			  descrip: '公司名称'
			}, {
			  key: '3',
			  name: 'report',
			  type: 'string',
			  example: '您好,.....',
			  descrip: '话术报备'
			}, {
			  key: '4',
			  name: 'phone',
			  type: 'string',
			  example: '13522110373',
			  descrip: '联系电话'
			}, {
			  key: '5',
			  name: 'name',
			  type: 'string',
			  example: '张三',
			  descrip: '联系人'
			},{
			  key: '6',
			  name: 'skip',
			  type: 'number',
			  example: '0',
			  descrip: '跳过直客数'
			},{
			  key: '7',
			  name: 'total',
			  type: 'number',
			  example: '2',
			  descrip: '总直客数'
			}],
			returnExample: pretty({
			    "status": "ok",
			    "result": {
			        "users": [
			            {
			                "licenses": [
			                    "license-pics-1552013717815.png"
			                ],
			                "_id": "5c8b03478e3cce04a36693a5",
			                "company": "demo公司",
			                "name": "demoname",
			                "phone": "13522110373",
			                "report": "您好",
			                "account": "5c8a16972a87f11aeeab78c6",
			                "createdAt": "2019-03-15T01:43:35.368Z",
			                "updatedAt": "2019-03-15T01:43:35.368Z",
			                "__v": 0
			            },
			            {
			                "licenses": [
			                    "license-pics-1552013717815.png"
			                ],
			                "_id": "5c90a52c42869a166dad31e5",
			                "company": "opSecret1",
			                "name": "张三",
			                "phone": "12522110373",
			                "report": "您好,.....",
			                "account": "5c8a16972a87f11aeeab78c6",
			                "createdAt": "2019-03-19T08:15:40.102Z",
			                "updatedAt": "2019-03-19T08:15:40.102Z",
			                "__v": 0
			            }
			        ],
			        "total": 2,
			        "skip": 0
			    }
			})
		},{
			title: '删除直客',
			meta: [{
			  key: '接口路径',
			  value: '/api/user/remove'
			}, {
			  key: '返回类型',
			  value: 'JSON'
			}, {
			  key: '请求方法',
			  value: 'POST'
			}, {
			  key: '特殊说明',
			  value: '删除直客，用于测试或者信息填写错误时，当客户已下单，则不允许删除'
			}, {
			  key: '授权参数',
			  value: '需要'
			}],
			params: [{
			  key: '1',
			  params: 'user',
			  need: '是',
			  type: 'string',
			  example: '5c90a52c42869a166dad31e5',
			  descrip: '直客ID'
			}],
			returnData: [{
			  key: '0',
			  name: 'status',
			  type: 'string',
			  example: 'ok',
			  descrip: '无参数'
			}],
			returnExample: pretty({
			    "status": "ok"
			})
		}],
		group:[{
			title: '创建画像',
			meta: [{
			  key: '接口路径',
			  value: '/api/group/create'
			}, {
			  key: '返回类型',
			  value: 'JSON'
			}, {
			  key: '请求方法',
			  value: 'POST'
			}, {
			  key: '特殊说明',
			  value: '创建画像，填写名称、域名、省份、城市、年龄段、性别字段，具体参数见以下说明，推荐填写直客ID'
			}, {
			  key: '授权参数',
			  value: '需要'
			}],
			params: [{
			  key: '1',
			  params: 'name',
			  need: '是',
			  type: 'string',
			  example: '房地产画像1',
			  descrip: '画像名称'
			}, {
			  key: '2',
			  params: 'hosts',
			  need: '是',
			  type: 'Array',
			  example:'["fang.com","beijing.anjuke.com"]',
			  descrip: '域名数组，建议根据预测接口并和运营充分沟通后填写，有利于及时返数和提高接通率、意向率'
			}, {
			  key: '3',
			  params: 'sex',
			  need: '否',
			  type: 'Array',
			  example: '["男", "女"]',
			  descrip: '性别筛选'
			}, {
			  key: '4',
			  params: 'user',
			  need: '否',
			  type: 'string',
			  example: '5c82269d16ce5f1af321cede',
			  descrip: '直客ID'
			},{
			  key: '5',
			  params: 'province',
			  need: '否',
			  type: 'Array',
			  example: '["北京"]',
			  descrip: '省份，标准见标准说明，全国不填'
			}, {
			  key: '6',
			  params: 'city',
			  need: '否',
			  type: 'Array',
			  example: '["北京市]',
			  descrip: '城市，标准见标准说明，全国不填'
			}, {
			  key: '7',
			  params: 'age',
			  need: '否',
			  type: 'string',
			  example: '["10-20岁","40-50岁","40以上", "20岁以下"]',
			  descrip: '年龄数组,结构如上'
			}],
			returnData: [{
			  key: '0',
			  name: '_id',
			  type: 'string',
			  example: '5c82269d16ce5f1af321cede',
			  descrip: '画像ID'
			},{
			  key: '1',
			  name: 'name',
			  type: 'string',
			  example: '房地产画像1',
			  descrip: '画像名称'
			}, {
			  key: '2',
			  name: 'hosts',
			  type: 'Array',
			  example:'["fang.com","beijing.anjuke.com"]',
			  descrip: '域名数组'
			}, {
			  key: '3',
			  name: 'sex',
			  type: 'Array',
			  example: '["男", "女"]',
			  descrip: '性别筛选'
			}, {
			  key: '4',
			  name: 'province',
			  type: 'Array',
			  example: '["北京市]',
			  descrip: '省'
			}, {
			  key: '5',
			  name: 'name',
			  type: 'Array',
			  example: '["北京市]',
			  descrip: '城市'
			}, {
			  key: '6',
			  name: 'age',
			  type: 'string',
			  example: '["10-20岁","40-50岁","40以上", "20岁以下"]',
			  descrip: '年龄数组'
			}, {
			  key: '7',
			  name: 'account',
			  type: 'string',
			  example: '5c8a16972a87f11aeeab78c6',
			  descrip: '合作方ID'
			},{
			  key: '8',
			  name: 'account',
			  type: 'string',
			  example: '5c82269d16ce5f1af321cede',
			  descrip: '直客ID'
			}],
			returnExample: pretty({
			    "status": "ok",
			    "result": {
			        "group": {
			            "hosts": [
			                "fang.com",
			                "beijing.anjuke.com"
			            ],
			            "province": [
			                "北京"
			            ],
			            "city": [
			                "北京市"
			            ],
			            "age": [
			                "10-20岁"
			            ],
			            "sex": [
			                "男"
			            ],
			            "_id": "5c90b19d42869a166dad31e6",
			            "name": "房地产画像1",
			            "user": "5c82269d16ce5f1af321cede",
			            "account": "5c8a16972a87f11aeeab78c6",
			            "createdAt": "2019-03-19T09:08:45.300Z",
			            "updatedAt": "2019-03-19T09:08:45.300Z",
			            "__v": 0
			        }
			    }
			})
		},{
			title: '获取画像',
			meta: [{
			  key: '接口路径',
			  value: '/api/group/list'
			}, {
			  key: '返回类型',
			  value: 'JSON'
			}, {
			  key: '请求方法',
			  value: 'POST'
			}, {
			  key: '特殊说明',
			  value: '获取画像列表，可以根据时间、直客ID查询'
			}, {
			  key: '授权参数',
			  value: '需要'
			}],
			params: [{
			  key: '1',
			  params: 'limit',
			  need: '否',
			  type: 'number',
			  example: 10,
			  descrip: '默认10'
			}, {
			  key: '2',
			  params: 'skip',
			  need: '否',
			  type: 'numbers',
			  example:0,
			  descrip: '默认10'
			}, {
			  key: '3',
			  params: 'start',
			  need: '否',
			  type: 'string',
			  example:'20190319',
			  descrip: '开始日期'
			},{
			  key: '4',
			  params: 'end',
			  need: '否',
			  type: 'string',
			  example:'20190320',
			  descrip: '结束日期'
			},{
			  key: '5',
			  params: 'user',
			  need: '否',
			  type: 'string',
			  example: '5c82269d16ce5f1af321cede',
			  descrip: '直客ID'
			}],
			returnData: [{
			  key: '0',
			  name: '_id',
			  type: 'string',
			  example: '5c82269d16ce5f1af321cede',
			  descrip: '画像ID'
			},{
			  key: '1',
			  name: 'name',
			  type: 'string',
			  example: '房地产画像1',
			  descrip: '画像名称'
			}, {
			  key: '2',
			  name: 'hosts',
			  type: 'Array',
			  example:'["fang.com","beijing.anjuke.com"]',
			  descrip: '域名数组'
			}, {
			  key: '3',
			  name: 'sex',
			  type: 'Array',
			  example: '["男", "女"]',
			  descrip: '性别筛选'
			}, {
			  key: '4',
			  name: 'province',
			  type: 'Array',
			  example: '["北京市]',
			  descrip: '省'
			}, {
			  key: '5',
			  name: 'name',
			  type: 'Array',
			  example: '["北京市]',
			  descrip: '城市'
			}, {
			  key: '6',
			  name: 'age',
			  type: 'string',
			  example: '["10-20岁","40-50岁","40以上", "20岁以下"]',
			  descrip: '年龄数组'
			}, {
			  key: '7',
			  name: 'account',
			  type: 'string',
			  example: '5c8a16972a87f11aeeab78c6',
			  descrip: '合作方ID'
			},{
			  key: '8',
			  name: 'account',
			  type: 'string',
			  example: '5c82269d16ce5f1af321cede',
			  descrip: '直客ID'
			},{
			  key: '9',
			  name: 'skip',
			  type: 'number',
			  example: '0',
			  descrip: '跳过画像数'
			},{
			  key: '10',
			  name: 'total',
			  type: 'number',
			  example: '1',
			  descrip: '总画像数'
			},{
			  key: '11',
			  name: 'createdAt',
			  type: 'number',
			  example: '1',
			  descrip: '画像创建时间,ISODate'
			}],
			returnExample: pretty({
			    "status": "ok",
			    "result": {
			        "groups": [
			            {
			                "hosts": [
			                    "fang.com",
			                    "beijing.anjuke.com"
			                ],
			                "province": [
			                    "北京"
			                ],
			                "city": [
			                    "北京市"
			                ],
			                "age": [
			                    "10-20岁"
			                ],
			                "sex": [
			                    "男"
			                ],
			                "_id": "5c90b19d42869a166dad31e6",
			                "name": "房地产画像1",
			                "user": "5c82269d16ce5f1af321cede",
			                "account": "5c8a16972a87f11aeeab78c6",
			                "createdAt": "2019-03-19T09:08:45.300Z",
			                "updatedAt": "2019-03-19T09:08:45.300Z",
			                "__v": 0
			            }
			        ],
			        "total": 1,
			        "skip": 0
			    }
			})
		}],
		order:[{
			title: '创建订单',
			meta: [{
			  key: '接口路径',
			  value: '/api/order/create'
			}, {
			  key: '返回类型',
			  value: 'JSON'
			}, {
			  key: '请求方法',
			  value: 'POST'
			}, {
			  key: '特殊说明',
			  value: '创建订单接口，可以根据画像和直客创建订单，或者根据原始订单创建补量订单，订单是运营生产线索、返回线索的依据，是补量的依据，也是后期分析线索效果，生成账单的依据，可以跟踪订单的状态，给客户进行反馈。'
			}, {
			  key: '授权参数',
			  value: '需要'
			}],
			params: [{
			  key: '1',
			  params: 'group',
			  need: '是',
			  type: 'string',
			  example: '5c90b19d42869a166dad31e6',
			  descrip: '画像ID'
			}, {
			  key: '2',
			  params: 'user',
			  need: '是',
			  type: 'string',
			  example:"5c82269d16ce5f1af321cede",
			  descrip: '直客ID'
			}, {
			  key: '3',
			  params: 'count',
			  need: '是',
			  type: 'number',
			  example: 500,
			  descrip: '线索预购数量'
			},{
			  key: '4',
			  params: 'origin',
			  need: '否',
			  type: 'string',
			  example:'5c8b03ec7f153804ede41e38',
			  descrip: '原始订单ID,发起补量申请使用'
			}],
			returnData: [{
			  key: '0',
			  name: '_id',
			  type: 'string',
			  example: '5c90c5bf42869a166dad31e7',
			  descrip: '订单ID'
			},{
			  key: '1',
			  name: 'group',
			  type: 'string',
			  example: '5c8b02a48e3cce04a36693a4',
			  descrip: '画像ID'
			}, {
			  key: '2',
			  name: 'account',
			  type: 'string',
			  example:"5c82269d16ce5f1af321cede",
			  descrip: '合作方ID'
			}, {
			  key: '3',
			  name: 'count',
			  type: 'number',
			  example: 500,
			  descrip: '线索预购数量'
			},{
			  key: '4',
			  name: 'type',
			  type: 'string',
			  example:'data',
			  descrip: '订单类别，默认data，为数据订单，目前只开放这一种'
			},{
			  key: '5',
			  name: 'status',
			  type: 'string',
			  example:'审核中',
			  descrip: '订单状态，enum ["审核中","执行中","已关闭"]'
			},{
			  key: '6',
			  name: 'history',
			  type: 'Array',
			  example:'[{ status:"审核中", date: "2019-03-19T10:34:39.469Z" }]',
			  descrip: '订单状态记录'
			},{
			  key: '7',
			  name: 'code',
			  type: 'string',
			  example:'D20190319001',
			  descrip: '订单编号'
			},{
			  key: '8',
			  name: 'subOrder',
			  type: 'Array',
			  example:'["5c90c5bf42869a166dad31e1"]',
			  descrip: '订单录入批次ID数组'
			},{
			  key: '9',
			  name: 'origin',
			  type: 'string',
			  example:'5c8b03ec7f153804ede41e38',
			  descrip: '原始订单ID, 补量订单特殊字段'
			},{
			  key: '10',
			  name: 'award',
			  type: 'boolean',
			  example: 'true',
			  descrip: '标识是否为补量订单，true 为 是,其他情况 为非补量订单'
			},{
			  key: '11',
			  name: 'awardCount',
			  type: 'number',
			  example:0,
			  descrip: '订单需要补数数量，默认0，订单关闭时且满足补数条件时有意义，会根据返数情况和拨打情况实时变化'
			}],
			returnExample: pretty({
			    "status": "ok",
			    "result": {
			        "order": {
			            "award": false,
			            "clue": 0,
			            "subOrder": [],
			            "_id": "5c90c5bf42869a166dad31e7",
			            "group": "5c8b02a48e3cce04a36693a4",
			            "account": "5c8a16972a87f11aeeab78c6",
			            "user": "5c90a52c42869a166dad31e5",
			            "type": "data",
			            "count": 500,
			            "status": "审核中",
			            "code": "D20190319001",
			            "history": [],
			            "createdAt": "2019-03-19T10:34:39.469Z",
			            "updatedAt": "2019-03-19T10:34:39.469Z",
			            "__v": 0
			        }
			    }
			})
		},{
			title: '获取订单',
			meta: [{
			  key: '接口路径',
			  value: '/api/order/list'
			}, {
			  key: '返回类型',
			  value: 'JSON'
			}, {
			  key: '请求方法',
			  value: 'POST'
			}, {
			  key: '特殊说明',
			  value: '获取订单列表，支持按照id、分页、时间、类型、用户查询'
			}, {
			  key: '授权参数',
			  value: '需要'
			}],
			params: [{
			  key: '1',
			  params: 'limit',
			  need: '否',
			  type: 'number',
			  example: 10,
			  descrip: '默认10'
			}, {
			  key: '2',
			  params: 'skip',
			  need: '否',
			  type: 'numbers',
			  example:0,
			  descrip: '默认10'
			},{
			  key: '3',
			  params: 'id',
			  need: '否',
			  type: 'string',
			  example: '5c90c5bf42869a166dad31e7',
			  descrip: '订单ID'
			}, {
			  key: '4',
			  params: 'user',
			  need: '是',
			  type: 'string',
			  example:"5c90a52c42869a166dad31e5",
			  descrip: '直客ID'
			}, {
			  key: '5',
			  params: 'start',
			  need: '否',
			  type: 'string',
			  example:'20190319',
			  descrip: '开始日期'
			},{
			  key: '6',
			  params: 'end',
			  need: '否',
			  type: 'string',
			  example:'20190320',
			  descrip: '结束日期'
			},{
			  key: '7',
			  params: 'award',
			  need: '否',
			  type: 'string',
			  example:'true or false',
			  descrip: '是否补量'
			}],
			returnData: [{
			  key: '0',
			  name: '_id',
			  type: 'string',
			  example: '5c90c5bf42869a166dad31e7',
			  descrip: '订单ID'
			},{
			  key: '1',
			  name: 'group',
			  type: 'string',
			  example: '5c8b02a48e3cce04a36693a4',
			  descrip: '画像ID'
			}, {
			  key: '2',
			  name: 'account',
			  type: 'string',
			  example:"5c82269d16ce5f1af321cede",
			  descrip: '合作方ID'
			}, {
			  key: '3',
			  name: 'count',
			  type: 'number',
			  example: 500,
			  descrip: '线索预购数量'
			},{
			  key: '4',
			  name: 'type',
			  type: 'string',
			  example:'data',
			  descrip: '订单类别'
			},{
			  key: '5',
			  name: 'status',
			  type: 'string',
			  example:'审核中',
			  descrip: '订单状态'
			},{
			  key: '6',
			  name: 'history',
			  type: 'Array',
			  example:'[{ status:"审核中", date: "2019-03-19T10:34:39.469Z" }]',
			  descrip: '订单状态记录'
			},{
			  key: '7',
			  name: 'code',
			  type: 'string',
			  example:'D20190319001',
			  descrip: '订单编号'
			},{
			  key: '8',
			  name: 'subOrder',
			  type: 'Array',
			  example:'["5c90c5bf42869a166dad31e1"]',
			  descrip: '订单录入批次ID数组'
			},{
			  key: '9',
			  name: 'origin',
			  type: 'string',
			  example:'5c8b03ec7f153804ede41e38',
			  descrip: '原始订单ID, 补量订单特殊字段'
			},{
			  key: '10',
			  name: 'award',
			  type: 'boolean',
			  example: 'true',
			  descrip: '标识是否为补量'
			},{
			  key: '11',
			  name: 'awardCount',
			  type: 'number',
			  example:0,
			  descrip: '订单需要补数数量'
			}],
			returnExample: pretty({
			    "status": "ok",
			    "result": {
			        "orders": [
			            {
			                "award": false,
			                "clue": 0,
			                "subOrder": [],
			                "_id": "5c90c5bf42869a166dad31e7",
			                "group": "5c8b02a48e3cce04a36693a4",
			                "account": "5c8a16972a87f11aeeab78c6",
			                "user": "5c90a52c42869a166dad31e5",
			                "type": "data",
			                "count": 500,
			                "status": "审核中",
			                "code": "D20190319001",
			                "history": [],
			                "createdAt": "2019-03-19T10:34:39.469Z",
			                "updatedAt": "2019-03-19T10:34:39.469Z",
			                "__v": 0
			            }
			        ],
			        "total": 1,
			        "skip": 0
			    }
			})
		}],
		clue: [{
			title: '获取线索',
			meta: [{
			  key: '接口路径',
			  value: '/api/clue/list'
			}, {
			  key: '返回类型',
			  value: 'JSON'
			}, {
			  key: '请求方法',
			  value: 'POST'
			}, {
			  key: '特殊说明',
			  value: '获取线索列表，支持按照画像、订单、批次、分页、时间、类型、用户、id查询, 此接口拉取入库回调通知，具体询问开发者'
			}, {
			  key: '授权参数',
			  value: '需要'
			}],
			params: [{
			  key: '1',
			  params: 'limit',
			  need: '否',
			  type: 'number',
			  example: 10,
			  descrip: '默认10'
			}, {
			  key: '2',
			  params: 'skip',
			  need: '否',
			  type: 'numbers',
			  example:0,
			  descrip: '默认10'
			},{
			  key: '3',
			  params: 'id',
			  need: '否',
			  type: 'string',
			  example: '5c90c5bf42869a166dad31e7',
			  descrip: '线索ID、即code'
			}, {
			  key: '4',
			  params: 'user',
			  need: '是',
			  type: 'string',
			  example:"5c90a52c42869a166dad31e5",
			  descrip: '直客ID'
			}, {
			  key: '5',
			  params: 'start',
			  need: '否',
			  type: 'string',
			  example:'20190319',
			  descrip: '开始日期'
			},{
			  key: '6',
			  params: 'end',
			  need: '否',
			  type: 'string',
			  example:'20190320',
			  descrip: '结束日期'
			},{
			  key: '7',
			  params: 'production',
			  need: '否',
			  type: 'string',
			  example:'5c8f3d85a8744715378b118f',
			  descrip: '线索批次ID'
			}],
			returnData: [{
			  key: '00',
			  name: '_id',
			  type: 'string',
			  example: '5c90c5bf42869a166dad31e7',
			  descrip: '线索ID'
			},{
			  key: '0',
			  name: 'code',
			  type: 'string',
			  example: '5c90c5bf42869a166dad31e7',
			  descrip: '线索别名、一般和_id 一致'
			},{
			  key: '1',
			  name: 'group',
			  type: 'string',
			  example: '5c8b02a48e3cce04a36693a4',
			  descrip: '画像ID'
			}, {
			  key: '2',
			  name: 'account',
			  type: 'string',
			  example:"5c82269d16ce5f1af321cede",
			  descrip: '合作方ID'
			}, {
			  key: '3',
			  name: 'type',
			  type: 'number',
			  example: 500,
			  descrip: '线索类型'
			},{
			  key: '4',
			  name: 'from',
			  type: 'string',
			  example:'ctcc',
			  descrip: '运营商来源、["ctcc"、"cmcc"、"cucc"] 分别对应电信、移动、联通'
			},{
			  key: '5',
			  name: 'city',
			  type: 'string',
			  example:'荆州',
			  descrip: '城市'
			},{
			  key: '6',
			  name: 'province',
			  type: 'string',
			  example:'湖北',
			  descrip: '省份'
			},{
			  key: '7',
			  name: 'virtualHost',
			  type: 'string',
			  example:'域名信息(来自画像) md5 编码',
			  descrip: '域名编码'
			},{
			  key: '8',
			  name: 'subOrder',
			  type: 'Array',
			  example:'["5c91e834b4ab890007bcc28b"]',
			  descrip: '线索营销记录、即话单信息'
			}],
			returnExample: pretty({
			    "status": "ok",
			    "result": {
			        "clues": [
			            {
			                "account": "5c8a141b2a87f11aeeab78c4",
			                "user": "5c8f02c3351fdc0007e4507b",
			                "code": "5c8f3d85a8744715378b1190",
			                "type": "group",
			                "from": "ctcc",
			                "group": "5c8b6e476280850007aeb356",
			                "city": "昆明",
			                "province": "云南",
			                "virtualHost": "9fc7b57516804f77bd05a72f75cdd15c",
			                "order": "5c8f0617351fdc0007e4507d",
			                "subOrder": "5c8f3d85a8744715378b118f",
			                "calledHistory": [
			                    "5c90829fb0ef61000746fab1",
			                    "5c909a7ab0ef61000746fab7",
			                    "5c909a92b0ef61000746fab8",
			                    "5c91b27059af7a0007d912b4",
			                    "5c91e8cfb4ab890007bcc28e",
			                    "5c91ea3fb4ab890007bcc298"
			                ],
			                "_id": "5c8f3d85a8744715378b1190"
			            }
			        ],
			        "total": 20,
			        "skip": 0
			    }
			})
		}],
		calltask: [{
			title: '小号绑定',
			meta: [{
			  key: '接口路径',
			  value: '/api/call/bind'
			}, {
			  key: '返回类型',
			  value: 'JSON'
			}, {
			  key: '请求方法',
			  value: 'POST'
			}, {
			  key: '特殊说明',
			  value: '客户营销需要绑定小号，提交主叫和线索code,返回虚拟号进行拨打即可触达线索'
			}, {
			  key: '授权参数',
			  value: '需要'
			}],
			params: [{
			  key: '1',
			  params: 'clue',
			  need: '是',
			  type: 'string',
			  example: "5c8f3d85a8744715378b1190",
			  descrip: '线索别名，code字段'
			}, {
			  key: '2',
			  params: 'caller',
			  need: '是',
			  type: 'string',
			  example: '13522110373',
			  descrip: '主叫号码'
			},{
			  key: '3',
			  params: 'callback_data',
			  need: '否',
			  type: 'string',
			  example:'xxx',
			  descrip: '自定义参数、保存在话单结构上、可自定义'
			}],
			returnData: [{
			  key: '00',
			  name: '_id',
			  type: 'string',
			  example: '5c8f4d8fa0b34c190d96fd9e',
			  descrip: '话单ID'
			},{
			  key: '0',
			  name: 'code',
			  type: 'clueType',
			  example: 'group',
			  descrip: '线索类型、现在只支持 group,画像取号'
			},{
			  key: '1',
			  name: 'from',
			  type: 'string',
			  example: 'ctcc',
			  descrip: '运营商来源、["ctcc"、"cmcc"、"cucc"] 分别对应电信、移动、联通'
			}, {
			  key: '2',
			  name: 'bindID',
			  type: 'string',
			  example:"3319031815493514263088",
			  descrip: '绑定ID,虚拟号绑定唯一识别码'
			}, {
			  key: '3',
			  name: 'caller',
			  type: 'number',
			  example: 13522110373,
			  descrip: '主叫'
			},{
			  key: '33',
			  name: 'called',
			  type: 'number',
			  example: 13264283452,
			  descrip: '被叫'
			},{
			  key: '4',
			  name: 'from',
			  type: 'string',
			  example:'ctcc',
			  descrip: '运营商来源、["ctcc"、"cmcc"、"cucc"] 分别对应电信、移动、联通'
			},{
			  key: '5',
			  name: 'account',
			  type: 'string',
			  example:"5c82269d16ce5f1af321cede",
			  descrip: '合作方ID'
			}, ,{
			  key: '6',
			  name: 'clue',
			  type: 'string',
			  example:'5c8f3d85a8744715378b1191',
			  descrip: '线索ID'
			},{
			  key: '7',
			  name: 'startTime',
			  type: 'number',
			  example:'1552895375405',
			  descrip: '开始时间'
			}],
			returnExample: pretty({
			    "status": "ok",
			    "data": {
			        "_id": "5c91f3c3f5928e00076834a6",
			        "clueType": "group",
			        "user": "5c8f02c3351fdc0007e4507b",
			        "from": "ctcc",
			        "bindID": "3319032016031514444333",
			        "unikey": "TY00001720190306000175",
			        "caller": 13522110373,
			        "called": 13264282405,
			        "account": "5c8a141b2a87f11aeeab78c4",
			        "clue": "5c8f3d85a8744715378b1190",
			        "startTime": 1553068995729,
			        "createdAt": "2019-03-20T08:03:15.731Z",
			        "updatedAt": "2019-03-20T08:03:15.731Z",
			        "__v": 0
			    }
			})
		},{
			title: '话单获取',
			meta: [{
			  key: '接口路径',
			  value: '/api/call/list'
			}, {
			  key: '返回类型',
			  value: 'JSON'
			}, {
			  key: '请求方法',
			  value: 'POST'
			}, {
			  key: '特殊说明',
			  value: '可以根据主叫、线索ID、开始时间、结束时间、bindID、callback_data获取话单列表'
			}, {
			  key: '授权参数',
			  value: '需要'
			}],
			params: [{
			  key: '1',
			  params: 'limit',
			  need: '否',
			  type: 'number',
			  example: 10,
			  descrip: '默认10'
			}, {
			  key: '2',
			  params: 'skip',
			  need: '否',
			  type: 'numbers',
			  example:0,
			  descrip: '默认10'
			}, {
			  key: '11',
			  params: 'clue',
			  need: '否',
			  type: 'string',
			  example: "5c8f3d85a8744715378b1190",
			  descrip: '线索ID'
			}, {
			  key: '22',
			  params: 'caller',
			  need: '是',
			  type: 'string',
			  example: '13522110373',
			  descrip: '主叫号码'
			},{
			  key: '33',
			  params: 'callback_data',
			  need: '否',
			  type: 'string',
			  example:'xxx',
			  descrip: '自定义参数、保存在话单结构上、可自定义'
			},{
			  key: '43',
			  params: 'start',
			  need: '否',
			  type: 'string',
			  example:'20190319',
			  descrip: '开始日期'
			},{
			  key: '5',
			  params: 'end',
			  need: '否',
			  type: 'string',
			  example:'20190320',
			  descrip: '结束日期'
			},],
			returnData: [{
			  key: '00',
			  name: '_id',
			  type: 'string',
			  example: '5c8f4d8fa0b34c190d96fd9e',
			  descrip: '话单ID'
			},{
			  key: '0',
			  name: 'code',
			  type: 'clueType',
			  example: 'group',
			  descrip: '线索类型、现在只支持 group,画像取号'
			},{
			  key: '1',
			  name: 'from',
			  type: 'string',
			  example: 'ctcc',
			  descrip: '运营商来源、["ctcc"、"cmcc"、"cucc"] 分别对应电信、移动、联通'
			}, {
			  key: '2',
			  name: 'bindID',
			  type: 'string',
			  example:"3319031815493514263088",
			  descrip: '绑定ID,虚拟号绑定唯一识别码'
			}, {
			  key: '3',
			  name: 'caller',
			  type: 'number',
			  example: 13522110373,
			  descrip: '主叫'
			},{
			  key: '33',
			  name: 'called',
			  type: 'number',
			  example: 13264283452,
			  descrip: '被叫'
			},{
			  key: '4',
			  name: 'from',
			  type: 'string',
			  example:'ctcc',
			  descrip: '运营商来源、["ctcc"、"cmcc"、"cucc"] 分别对应电信、移动、联通'
			},{
			  key: '5',
			  name: 'account',
			  type: 'string',
			  example:"5c82269d16ce5f1af321cede",
			  descrip: '合作方ID'
			}, ,{
			  key: '6',
			  name: 'clue',
			  type: 'string',
			  example:'5c8f3d85a8744715378b1191',
			  descrip: '线索ID'
			},{
			  key: '7',
			  name: 'startTime',
			  type: 'number',
			  example:'1552895375405',
			  descrip: '开始时间'
			},{
			  key: '8',
			  name: 'updateTime',
			  type: 'number',
			  example:'1552895391270',
			  descrip: '结束时间'
			},{
			  key: '9',
			  name: 'duration',
			  type: 'number',
			  example:'10',
			  descrip: '通话时长/s'
			},{
			  key: '10',
			  name: 'minutes',
			  type: 'number',
			  example:'1',
			  descrip: '通话时长/min'
			},{
			  key: '11',
			  name: 'result',
			  type: 'string',
			  example:'1',
			  descrip: '通话结果，字段标准见标准说明'
			},{
			  key: '12',
			  name: 'url',
			  type: 'string',
			  example:'1',
			  descrip: '通话录音'
			},{
			  key: '13',
			  name: 'status',
			  type: 'string',
			  example:'1',
			  descrip: '1 or 2  运营商回调状态，1为正常，2为非正常，非正常情况下时长一般为0、一般不影响计费和扣时，但会影响话单统计，最终以拉取结果为准，如果需要缓冲需要多次拉取并更新，一般以天为周期'
			}],
			returnExample: pretty({
			    "status": "ok",
			    "result": {
			        "calltasks": [
			            {
			                "_id": "5c8f4d8fa0b34c190d96fd9e",
			                "clueType": "group",
			                "from": "ctcc",
			                "bindID": "3319031815493514263088",
			                "unikey": "TY00001720190306000176",
			                "caller": 18252066520,
			                "called": 13264283452,
			                "account": "5c8a141b2a87f11aeeab78c4",
			                "clue": "5c8f3d85a8744715378b1191",
			                "startTime": 1552895375405,
			                "createdAt": "2019-03-18T07:49:35.414Z",
			                "updatedAt": "2019-03-18T07:49:51.273Z",
			                "__v": 0,
			                "duration": 0,
			                "minutes": 0,
			                "result": "OTHER",
			                "updateTime": 1552895391270,
			                "url": null
			            }
			        ],
			        "total": 75,
			        "skip": 0
			    }
			})
		}]
	}
let showData = {};
for(let k in dataSource) {
	showData[k] = dataSource[k].map( x => {
  	return (<div><div className={styles.title}><h4>{x.title}</h4></div>
			  	<Table dataSource={x.meta} columns={metaColumns} pagination={false} size="middle" showHeader={false}  bordered style={{ marginBottom: '20px' }}/>
			  	<h4>请求参数</h4>
			  	<Table dataSource={x.params} columns={columns} pagination={false} size="middle" bordered style={{ marginBottom: '20px' }}/>
			  	<h4>响应参数</h4>
			  	<Table dataSource={x.returnData} columns={returnColumns} pagination={false} size="middle" bordered style={{ marginBottom: '20px' }}/>
			  	<div className={styles.back}>
			  		<h4>返回示例</h4>
			  		<Highlight className='json-of-snippet'>
					{ x.returnExample }
					</Highlight>
			 </div></div>)
  })
}
export default function() {

  return (
    <div className={styles.container}>
    	<div style={{ padding: "20px 0px"}}>
	    	<h2 style={{ padding: "15px 0px"}}>API 说明文档</h2>
	      	<Tabs
	          defaultActiveKey="1"
	          tabPosition={'left'}
	          style={{ minHeight: 500 }}
	        >
	          <TabPane tab="前言与概述" key="1">
	          	<h3>小云API能做什么？</h3>
	          	<p>小云为企业提供了一个大数据AI精准营销的基本框架。在此平台上，拥有无限的应用扩展机会。基于小云开放平台，企业和第三方开发者均可把小云的数据精准营销能力变成自己产品和解决方案的一部分。最终通过加入小云开放平台，获得强大的大数据AI精准营销能力，帮助您快速获得客户和收入。
				</p><p>在小云开放平台上，我们为您提供了大数据预测、画像、订单、线索、呼叫、加好友、标记回传、话单分析等一系列接口， 广大的企业和第三方开发者只需登录此平台并申即可通过授权令牌调用数据接口进行操作和营销。</p>
				<p>我们的目标是使您能够完全聚焦在自己的应用开发层面上， 也非常鼓励企业和第三方开发者依照小云开放平台的大数据AI精准营销的特性， 开发出具有创新、解决企业迫切需求的应用。 另外，小云和企业与第三方开发者共享在小云开发平台上的客户和收益。</p>
				<p>小云开放平台除了提供数据接口的开发文档， 同时还提供了必要的图标资源和SDK资源，目前我们提供了包括等平台语言的SDK资源， 在未来一个阶段我们将继续完善其它主流开发语言的SDK资源，供广大开发者进行参考。 我们也非常鼓励开发者能够提供非官方的SDK资源，您可以与我们联系，我们将对提供有效SDK资源的开发者进行奖励。</p>
				<h3>接入流程</h3>
				<p>针对现有成熟业务模式和合作方式，常规开发和业务流如下：</p>
				<h4>1、获取开发者账户</h4>
				<p>开发者需要首先获取开发者测试账户,获取开发权限，然后进行开发和调试，最后可以集成到您自身业务中,也可以做营销类创新应用，获取 token 后即可进行其他接口操作，具体使用方法查看 认证接口 说明。</p>
				<h4>2、报备直客账户</h4>
				<p>由于小云营销数据都是脱敏数据，应运营商要求需要对营销者行业和资质进行审核，对使用者营销话术进行备案。具体使用方法查看 直客接口 说明。</p>
				<h4>3、URL预测</h4>
				<p>小云营销涉及行业广泛，不同行业主流媒体落地页、APP良莠不齐，但是都可作为小云营销线索来源，小云营销为保证效果和订单数据需求合理性，也为满足客户需求和过滤无效和不合理客户，您作为代理商或开发者，有必要需要对客户提交url进行预测，以判断是否满足小云营销线索建模和生产标准，具体产品形态可自主决定，具体使用方法查看 预测接口 说明。</p>
				<h4>4、创建画像</h4>
				<p>画像是小云营销数据运营进行建模和返回线索的标准，和线索最终交付比和意向率关系密切，需要您（代理商或开发者）认真进行说明，并在产品上进行引导，帮助客户理解和找到理想的url，我们自主开发了一个方便直客获取url的小工具，仅供参考（下载地址：https://pan.baidu.com/s/1G-lnZQi-esdHcCi28kkSSQ ， 提取码： hb3e），除了最终url,客户还可以填写对需要线索的地区（省市信息）、性别、年龄进行规定，生成一个画像，具体使用方法查看 画像接口 说明。</p>
				<h4>5、下单</h4>
				<p>客户确定完画像即可在后台下单，一个订单规定了一个画像需要的线索数量，是您（代理商或开发者）和小云进行结算的基本单位，也是小云进行线索补量 的基本单位（补量规则这边是统一的，也可以进行协商），所以建议您直接把客户订单平移至小云后台，以免补量算法不一致造成纠纷，订单状态和返回线索情况可以通过接口进行跟踪，具体使用方法查看 线索接口 说明。</p>
				<h4>6、线索分批返回</h4>
				<p>客户下单后小云运营需要进行建模、优化、筛选、入库、出库等一系列流程，为保证生产线索的实效性和意向率，线索会分批返回，第一批原则上三天内返回，如果因画像和行业问题不能及时交付的会协调关闭订单，每批返回线索可以可以通过定时任务进行订单查询，也可以选择回调通知再拉去数据的方式返回，具体使用方法查看 下单接口 、线索接口 说明。</p>
				<h4>7、线索营销</h4>
				<p>线索返回后可以对线索进行拨打，拨打前需要通过绑定接口取到虚拟小号，然后拨打小号即可触到线索用户，通话结束后线索和主叫会自动解绑，针对不同线索来源需要不同的话术和沟通模式，以增加意向率和成交率，具体情况和行业关系密切，可以联系代理商获取成功案例作为参考，具体使用方法查看 营销接口 说明。</p>
				<h4>8、话单返回及分析</h4>
				<p>线索营销后返回话单详情，内容包括通话主叫、被叫、通话状态、时长、录音等信息，交互方式可以写定时任务主动拉取，也可以实时回调返回，您（代理商或开发者）可以对话单进行分析，补量依据、接通率、意向率等统计数据来源于话单进行分析，您可自定义自己分析维度，也可以拉去官方分析结果和优化意见，接口待开发，具体使用方法查看 营销接口 说明。</p>
				<h3>结语</h3>
				<p>为了更好服务商家, 目前支持开发和协作开发模式, 代理商开发者可以与小云协商进行开发更多赋能接口和方便您业务逻辑的接口，合作联系： 13522110373</p>
			  </TabPane>
			  <TabPane tab="认证接口" key="2">
			  {
			  		showData['auth']
			  }
			  </TabPane>
			  <TabPane tab="预测接口" key="3">
			  {
			  		showData['url']
			  }
			  </TabPane>
			  <TabPane tab="直客接口" key="4">
			  	{
			  		showData['user']
			  	}
			  </TabPane>
	          <TabPane tab="画像接口" key="5">
	          {
	          		showData['group']
	          }
	          </TabPane>
	          <TabPane tab="订单接口" key="6">
	          {
	          		showData['order']
	          }
	          </TabPane>
	          <TabPane tab="线索接口" key="7">
	          {
	          		showData['clue']
	          }
	          </TabPane>
	          <TabPane tab="营销接口" key="8">
	          {
					showData['calltask']
	          }
	          </TabPane>
	          <TabPane tab="错误说明" key="9">
	          	<div className={styles.title}><h4>HTTP异常状态</h4></div>
	          	<div>
	          	 <p>400 参数、传递错误</p>
	          	 <p>500 服务器问题</p>
	          	 <p>401 权限问题</p>
	          	 <p>504 服务超时</p>
	          	</div>
	          	<div className={styles.title}><h4>异常返回信息</h4></div>
	          	<Highlight className='json-of-snippet'>
					{ error }
				</Highlight>
	          </TabPane>
	          <TabPane tab="标准说明" key="10">
		        <div>
		          	<div className={styles.title}><h4>省份、城市字段</h4></div>
		          	<Highlight className='json-of-snippet'>
						{ json }
					</Highlight>
					<div className={styles.title}><h4>通话结果</h4></div>
		          	<Highlight className='json-of-snippet'>
						{ result }
					</Highlight>
				</div>
	          </TabPane>
	        </Tabs>
    	</div>
    </div>
  );
}
