import styles from './index.css';
import { Layout, Menu, Breadcrumb } from 'antd';
const SubMenu = Menu.SubMenu;
const { Header, Content, Footer } = Layout;

function BasicLayout(props) {

  function handleClick(e) {
  	window.location.href =  e.key == 'home' ? '/' : (e.key === 'registration' ? 'game' : e.key);
  }

  function goNews(type) {
  	window.location.hash = type;
  	window.location.reload();
  }

  //let key = props.location.hash.
  let pathname = props.location.pathname;
  pathname = pathname.substr(1, pathname.length);

  let key = pathname.length ? pathname : 'home';

  return (
	  <div className="layout">
	    <div className="header" style={{ "borderBottom": '1px solid #e8e8e8' }}>
	      <div className={styles.container}>
	        <div className={styles.logo} />
	        <div className={styles.main}>
	        	<h2>开放平台</h2>
	        </div>
		    <Menu
		        theme="light"
		        mode="horizontal"
		        defaultSelectedKeys={[key]}
		        style={{ lineHeight: '64px', display: 'flex', 'justifyContent': 'space-between', background: '#fff', border: 'none' }}
		        onClick={handleClick}
		    >
		        <Menu.Item key="home">首页</Menu.Item>
		        <Menu.Item key="document">文档中心</Menu.Item>
		        <Menu.Item key="news">平台公告</Menu.Item>
		        <Menu.Item key="resource">资源下载</Menu.Item>
		        <Menu.Item key="about">关于我们</Menu.Item>
		    </Menu>
	      </div>
	    </div>
	    <div style={{ minHeight: '280px' }}>
	       <div style={{ background: '#fff', minHeight: 280 }}>{ props.children }</div>
	    </div>
	    <div style={{ background: "#333333", color: '#fff' }}>
	    	<div className={styles.container}  style={{ background: "#333333", lineHeight: '29px', display: 'flex', 'justifyContent': 'space-between', alignItems:"start", padding: '50px 22px', flexWrap: 'wrap-reverse' }} >
	    	    <div className={styles.footerItem}>
	    	    	<span>开放平台</span>
	    	    	<ul>
	    	    		<li><a onClick = { goNews.bind(this, 'news?type=competition') } >平台简介</a></li>
	    	    		<li><a onClick = { goNews.bind(this, 'news?type=album') } >文档中心</a></li>
	    	    		<li><a onClick = { goNews.bind(this, 'news?type=videos') } >平台公告</a></li>
	    	    	</ul>
	    	    </div>
	    	    <div className={styles.footerItem}>
	    	    	<span>联系我们</span>
	    	    	<ul>
	    	    		<li><a>电话：400-060-6869</a></li>
	    	    		<li><a>邮件：liusong@xiaoyun.com</a></li>
	    	    		<li><a>地址：北京市东城区东四北大街107号科林大厦B座103</a></li>
	    	    	</ul>
	    	    </div>
	    	    <div className={styles.footerItem}>
	    	    	<span>相关链接</span>
	    	    	<ul>
	    	    		<li><a href="http://xiaoyun.com" target="_blank">小云营销官网</a></li>
	    	    		<li><a href="http://remarketing-agent.yoo.yunpro.cn/" target="_blank">小云营销渠道后台</a></li>
	    	    		<li><a href="http://remarketing-admin.yoo.yunpro.cn/" target="_blank">小云营销直客后台</a></li>
	    	    	</ul>
	    	    </div>
	    	    <div className={styles.footerImageItem}>
	    	    	<span>关注我们</span>
	    	    	<div className={styles.footerImageItemMain}>
	    	    		<div><img src="http://openapi.wjh.xiaoyun.com/file/code.png"/><span>微信公众号</span></div>
	    	    	</div>
	    	    </div>
	    	</div>
	    </div>
	    <div style={{ background: "#2D2D2D", color: '#fff' }}>
	    	<div className={styles.container}  style={{ background: "#2D2D2D" ,display: 'flex', flexDirection: 'column', padding: '10px 22px'  }} >
	    	    <p style={{ margin: '2px 0'}}>©2014-2019 All Rights Reserved 北京微聚合信息技术有限公司 版权所有</p>
	    	</div>
	    </div>
	  </div>
  );
}
export default BasicLayout;
