const mongoose = require('mongoose');
const connect = require('../connect');
const {
    ObjectId
} = mongoose.SchemaTypes;

const schema = mongoose.Schema({
    account: {
        type: ObjectId,
        required: true,
        ref: 'account'
    },
    name: String,
    user: {
        type: ObjectId,
        ref: 'user'
    },
    hosts:[{
        type:String
    }],
    province: [String],
    city: [String],
    age:[String],
    sex:[String]
}, {
    timestamps: true
});
module.exports = connect.db.model('group', schema);