const mongoose = require('mongoose');
const connect = require('../connect');
const generateCode = require('utils/generate-code');
const {
    ObjectId
} = mongoose.SchemaTypes;
const counter = require('db/mongo/open/counter');

const schema = mongoose.Schema({
    account: {
        type: ObjectId,
        required: true,
        ref: 'account'
    },
    user: {
        type: ObjectId,
        required: true,
        ref: 'user'
    },
    unikey: { 
        type: String,
        required: true,
    },
    award: Boolean,             // 是否补量
    code: {
        type: String,           
        required: true,
        unique: true
    },
    type: { 
        type: String,
        required: true,
        enum: ['slot','group']  // 自媒体 精选画像
    },
    retrive: {
        type: Boolean
    },
    retriveDate: {
        type: Date
    },
    from: {  // 来源
        type: String,
        required: true,
        enum: ['cmcc', 'ctcc', 'cucc', 'unknow']  // 移动 电信 联通 未知
    },
    group: {  // 画像
        type: ObjectId,
        required: false,
        ref: 'group'
    },
    sex: { 
        type: String,
        required: false,
    },
    age: { 
        type: String,
        required: false,
    },
    city: { 
        type: String,
        required: false,
    },
    province: { 
        type: String,
        required: false,
    },
    host: { 
        type: String,
        required: false,
    },
    virtualHost: String,
    lastCall: {
        type: Date,
        required: false
    },
    order: {                // 订单
        type: ObjectId,
        required: true,
        ref: 'order'
    },
    subOrder: {             // 子订单
        type: ObjectId,
        required: false,
        ref: 'order_production'
    },
    calledHistory: [{
        type: ObjectId,
        ref: 'calltask'
    }]
    /*tagHistory: [{
        type: ObjectId,
        ref: 'tag_history'
    }],*/
}, {
    timestamps: true
});

schema.index({ createdAt: -1 });
schema.index({ calledHistory: -1 });
schema.index({ selfTag: -1 });
schema.index({ systemTag: -1 });
schema.index({ selfTag: -1, systemTag: -1 });

schema.pre('save', function (next) {
    const doc = this;
    console.dir(doc._id);
    if(!doc.isNew) next();
    else {
        doc.code = doc._id + '';
        next();
    }
});
module.exports = connect.db.model('clue', schema);