const jwt = require('jsonwebtoken');
const config = require('config');
const hash = require('utils/hash');
const tools = require('utils/tools');
const _ = require('lodash');
const mongoose = require('mongoose');
const Url = require('db/mongo/tag_url/domain');
const {
    ObjectId
} =  require('mongoose').Types;


// 获取预测
exports.list = async (ctx, next) => {
    let {
        url,
        province
    } = ctx.request.body;
    let account = ctx.state.user;
    ctx.assert(account, 401, '权限错误', {
        code: 1
    });
    ctx.assert(url && url.length, 500, '参数错误，url', {
        code: 1
    });
    let names = Array.isArray(url) ? url : [ url ];
    ctx.assert(names.length > 0 && names.length < 10, 500, '参数错误，url 数组不能超过10个', {
        code: 1
    });
    let conditions = { name: { $in: names } }
    if(province && province.length) conditions.province = province;
    let list = await Url.find(conditions, { name: 1, code: 1, count: 1, province: 1 }, { limit: 500, skip: 0  });
    ctx.body = {
        status: 'ok',
        result: {
            urls: list
        }
    }
}

