const jwt = require('jsonwebtoken');
const config = require('config');
const hash = require('utils/hash');
const tools = require('utils/tools');
const _ = require('lodash');
const mongoose = require('mongoose');
const groupContrl = require('./group');
const Order = require('db/mongo/open/order');
const Clue = require('db/mongo/open/clue');
const Group = require('db/mongo/open/group');
const User = require('db/mongo/open/user');
const {
    ObjectId
} =  require('mongoose').Types;
const Types = ['data', 'media', 'msg', 'record', 'imei']
// 获取订单列表
exports.list = async (ctx, next) => {
    let {
        id=0,
        skip=0,
        limit=10,
        start,
        award,
        end,
        user
    } = ctx.request.body;
    let account = ctx.state.user;
    skip = parseInt(skip);
    limit = parseInt(limit);
    ctx.assert(!isNaN(skip), 500, '参数错误，skip', {
        code: 1
    });
    ctx.assert(!isNaN(limit), 500, '参数错误，limit', {
        code: 1
    });
    if(start || end) {
      ctx.assert(/^\d{8}$/.test(start) && /^\d{8}$/.test(end), 500, '参数错误，start end', {
        code: 1
      });
    }
    let conditions = tools.generateDateQuery(start, end);

    if(user) {
        ctx.assert(tools.valid(user), 500, '参数错误，user', {
            code: 1
        });
        let userObj = await User.findById(user);
        ctx.assert(userObj && userObj.account + '' === ctx.state.user._id + '', 500, '参数错误，user', {
            code: 1
        });
        conditions.user = user;
    }

    if(id) {
        ctx.assert(tools.valid(id), 500, '参数错误，id', {
            code: 1
        });
        conditions._id = id;  
    }

    if(award == true || award == false) {
        conditions.award = award;
    }
    
    let orders = await Order.find(conditions, null, {
        skip,
        limit
    }).populate('origin', 'account user code meta awardCount type award count clue group subOrder status meta').populate('subOrder', 'count createdAt');

    let total = await Order.count(conditions);

    ctx.body = {
        status: 'ok',
        result: {
            orders,
            total,
            skip
        }
    }
}
/*
(async function (argument) {
    let as = await Order.find();
    for(let a of as) {
        let { code, _id } = a
        console.dir(code);
        let aa = await Order.updateOne({
            _id
        },{
            $set: { code: 'O' + code}
        })
        console.dir(aa);
    }
})()*/

exports.check = async(ctx, next) => {
    let {
        order                                                                                                                                                             
    } = ctx.request.body;
    ctx.assert(tools.valid(order), 500, '参数错误，user', {
        code: 1
    });
    let orderObj = await Order.findById(order);
    ctx.assert(orderObj , 500, '参数错误，order', {
        code: 1
    });
    if(orderObj.status == '审核中') {
        orderObj.status = '执行中';
        orderObj.history = orderObj.history.concat([{
                status: '执行中',
                date: new Date()
            }])
        await orderObj.save();
    }
    ctx.body = {
        status: 'ok'
    }
}

exports.close = async(ctx, next) => {
    let {
        order
    } = ctx.request.body;
    ctx.assert(tools.valid(order), 500, '参数错误，order', {
        code: 1
    });
    let orderObj = await Order.findById(order);
    ctx.assert(orderObj , 500, '参数错误，order', {
        code: 1
    });
    if(orderObj.status == '已关闭') {
        ctx.body = {
          status: 'ok'
        }
    } else {
        let count = await Clue.count({ order: ObjectId(order) });
        orderObj.clue = count;
        orderObj.status = '已关闭';
        orderObj.history = orderObj.history.concat([{
                status: '已关闭',
                date: new Date()
            }])
        await orderObj.save();
    }
    ctx.body = {
        status: 'ok'
    }
}

exports.all = async (ctx, next) => {
    let {
        id=0,
        skip=0,
        limit=10,
        start,
        award,
        end
    } = ctx.request.body;

    skip = parseInt(skip);
    limit = parseInt(limit);
    ctx.assert(!isNaN(skip), 500, '参数错误，skip', {
        code: 1
    });
    ctx.assert(!isNaN(limit), 500, '参数错误，limit', {
        code: 1
    });
    if(start || end) {
      ctx.assert(/^\d{8}$/.test(start) && /^\d{8}$/.test(end), 500, '参数错误，start end', {
        code: 1
      });
    }
    let conditions = tools.generateDateQuery(start, end);

    if(id) {
        ctx.assert(tools.valid(id), 500, '参数错误，id', {
            code: 1
        });
        conditions._id = id;  
    }

    if(award == true || award == false) {
        conditions.award = award;
    }
    
    let orders = await Order.find(conditions, null, {
        skip,
        limit,
        sort: {
            createdAt: -1
        }
    }).populate('origin', 'account user code meta awardCount type award count clue group subOrder status meta').populate(
        'account', 'company nickname phone zyxKey'
    ).populate('user', 'company name').populate('group', 'hosts province sex city age name');

    let total = await Order.count(conditions);

    ctx.body = {
        status: 'ok',
        result: {
            orders,
            total,
            skip
        }
    }
}


exports.check = async(ctx, next) => {
    let {
        order                                                                                                                                                             
    } = ctx.request.body;
   ctx.assert(tools.valid(order), 500, '参数错误，user', {
        code: 1
    });
    let orderObj = await Order.findById(order);
    ctx.assert(orderObj , 500, '参数错误，order', {
        code: 1
    });
    if(orderObj.status == '审核中') {
        orderObj.status = '执行中';
        orderObj.history = orderObj.history.concat([{
                status: '执行中',
                date: new Date()
            }])
        await orderObj.save();
    }
    ctx.body = {
        status: 'ok'
    }
}


//创建订单
exports.create = async (ctx, next) => {
    let {
        group,
        user,
        count=500,
        type='data',
        origin,
    } = ctx.request.body;
    let account = ctx.state.user._id;

    ctx.assert(tools.valid(group), 500, '参数错误，group', {
        code: 1
    });
    ctx.assert(Types.indexOf(type) >= 0, 500, '参数错误，type', {
        code: 1
    });
     
    ctx.assert(tools.valid(user), 500, '参数错误，user', {
        code: 1
    });

    let userObj = await User.findById(user);
    ctx.assert(userObj && userObj.account + '' === ctx.state.user._id + '', 500, '参数错误，user', {
        code: 1
    });
    let groupObj = await groupContrl.findById(group)
    ctx.assert(groupObj && groupObj.account + '' === account + '', 500, '参数错误，group', {
        code: 1
    });
    if(groupObj.user) {
        ctx.assert(groupObj && groupObj.user + '' === user + '', 500, '参数错误，group 和 user 不匹配', {
            code: 1
        });
    }
    count = parseInt(count);
    ctx.assert(count && !isNaN(count) && count > 0 , 500, '参数错误，count', {
        code: 1
    });

    let data = {
        group,
        account,
        user,
        type,
        count,
        status:'审核中',
        code: 'unknown',
        history:[{
            status: '审核中',
            date: new Date()
        }]
    };

    if(origin) {
        ctx.assert(tools.valid(origin), 500, '参数错误，origin', {
            code: 1
        });
        let orderObj = await Order.findById(origin);
        ctx.assert(orderObj && orderObj.user + '' === user , 500, '参数错误，origin', {
            code: 1
        });
        data.origin = origin;
        data.award = true;
    }
    
    let order = await new Order(data).save();

    ctx.body = {
        status: 'ok',
        result: {
            order
        }
    }
}




// 修改画像
/*(async function (argument) {
    let orders = [
    {
        code:"OD20190327005",
        hosts:[{
            from: 'mobile.mlnglobal.com',
            replace: 'kh.10jqka.com.cn'
        }]
    },
    {
        code:"OD20190329001",
        hosts:[{
            from: 'newhouse.fang.com',
            replace: 'kh.10jqka.com.cn'
        }]
    },
    {
        code:"OD20190402001",
        hosts:[{
            from: 'fang.anjuke.com',
            replace: 'kh.10jqka.com.cn'
        }]
    },
    {
        code:"OD20190419008",
        hosts:[{
            from: 'huaian.jiwu.com',
            replace: 'kh.10jqka.com.cn'
        }]
    },
    {
        code:"OD20190422006",
        hosts:[{
            from: 'www.yiddtea.com',
            replace: 'kh.10jqka.com.cn'
        }]
    },
    {
        code:"OD20190422008",
        hosts:[{
            from: 'www.runzeyufu.com',
            replace: 'kh.10jqka.com.cn'
        }]
    },
    {
        code:"OD20190423001",
        hosts:[{
            from: 'yt.newhouse.fang.com',
            replace: 'kh.10jqka.com.cn'
        }]
    },
    {
        code:"OD20190423002",
        hosts:[{
            from: 'www.haozu.com',
            replace: 'kh.10jqka.com.cn'
        }]
    },{
        code:"OD20190423003",
        hosts:[{
            from: 'fang.anjuke.com',
            replace: 'kh.10jqka.com.cn'
        }]
    }];


    for(let o of orders) {
        let { code, hosts, province, city } = o;
        // console.dir(hosts);
        let order = await Order.findOne({ code });
        let { group } = order;
        let conditions = {};
        let setObj = {};
        if(hosts) {
            conditions['hosts'] = { '$in': hosts.map( x => 
                x.from
            ) } 
            setObj['$push'] = { hosts: {
                $each: hosts.map( x =>  x.replace)
            } }
        }

        if(province !== undefined ){
            conditions.province = province.from;
            if(setObj['$set'])
                setObj['$set']['province'] = province.to ;
            else
                setObj['$set'] = { province: province.to };
        }

        if(city !== undefined) {
            conditions.city = city.from

            if(setObj['$set'])
                setObj['$set']['city'] = city.to ;
            else
                setObj['$set'] = { city: city.to };
        }

        //console.dir(conditions);
        console.dir(setObj);
        conditions._id = group;
        //let rep = await Group.updateOne(conditions, setObj);
        console.dir(rep);
        //console.dir(setObj);
    }
})()*/
