
const _ = require('lodash')
const mapping = [
    {
        "p": "直辖市",
        "c": [
            "北京",
            "天津",
            "上海",
            "重庆"
        ]
    },
    {
        "p": "河北",
        "c": [
            "石家庄",
            "唐山",
            "秦皇岛",
            "邯郸",
            "邢台",
            "保定",
            "张家口",
            "承德",
            "沧州",
            "廊坊",
            "衡水"
        ]
    },
    {
        "p": "山西",
        "c": [
            "太原",
            "大同",
            "阳泉",
            "长治",
            "晋城",
            "朔州",
            "晋中",
            "运城",
            "忻州",
            "临汾",
            "吕梁"
        ]
    },
    {
        "p": "内蒙古",
        "c": [
            "呼和浩特",
            "包头",
            "乌海",
            "赤峰",
            "通辽",
            "鄂尔多斯",
            "呼伦贝尔",
            "巴彦淖尔",
            "乌兰察布",
            "兴安",
            "锡林郭勒",
            "阿拉善"
        ]
    },
    {
        "p": "辽宁",
        "c": [
            "沈阳",
            "大连",
            "鞍山",
            "抚顺",
            "本溪",
            "丹东",
            "锦州",
            "营口",
            "阜新",
            "辽阳",
            "盘锦",
            "铁岭",
            "朝阳",
            "葫芦岛"
        ]
    },
    {
        "p": "吉林",
        "c": [
            "长春",
            "吉林",
            "四平",
            "辽源",
            "通化",
            "白山",
            "松原",
            "白城",
            "延边"
        ]
    },
    {
        "p": "黑龙江",
        "c": [
            "哈尔滨",
            "齐齐哈尔",
            "鸡西",
            "鹤岗",
            "双鸭山",
            "大庆",
            "伊春",
            "佳木斯",
            "七台河",
            "牡丹江",
            "黑河",
            "绥化",
            "大兴安岭"
        ]
    },
    {
        "p": "江苏",
        "c": [
            "南京",
            "无锡",
            "徐州",
            "常州",
            "苏州",
            "南通",
            "连云港",
            "淮安",
            "盐城",
            "扬州",
            "镇江",
            "泰州",
            "宿迁"
        ]
    },
    {
        "p": "浙江",
        "c": [
            "杭州",
            "宁波",
            "温州",
            "嘉兴",
            "湖州",
            "绍兴",
            "金华",
            "衢州",
            "舟山",
            "台州",
            "丽水"
        ]
    },
    {
        "p": "安徽",
        "c": [
            "合肥",
            "芜湖",
            "蚌埠",
            "淮南",
            "马鞍山",
            "淮北",
            "铜陵",
            "安庆",
            "黄山",
            "滁州",
            "阜阳",
            "宿州",
            "巢湖",
            "六安",
            "亳州",
            "池州",
            "宣城"
        ]
    },
    {
        "p": "福建",
        "c": [
            "福州",
            "厦门",
            "莆田",
            "三明",
            "泉州",
            "漳州",
            "南平",
            "龙岩",
            "宁德"
        ]
    },
    {
        "p": "江西",
        "c": [
            "南昌",
            "景德镇",
            "萍乡",
            "九江",
            "新余",
            "鹰潭",
            "赣州",
            "吉安",
            "宜春",
            "抚州",
            "上饶"
        ]
    },
    {
        "p": "山东",
        "c": [
            "济南",
            "青岛",
            "淄博",
            "枣庄",
            "东营",
            "烟台",
            "潍坊",
            "济宁",
            "泰安",
            "威海",
            "日照",
            "莱芜",
            "临沂",
            "德州",
            "聊城",
            "滨州",
            "菏泽"
        ]
    },
    {
        "p": "河南",
        "c": [
            "郑州",
            "开封",
            "洛阳",
            "平顶山",
            "安阳",
            "鹤壁",
            "新乡",
            "焦作",
            "濮阳",
            "许昌",
            "漯河",
            "三门峡",
            "南阳",
            "商丘",
            "信阳",
            "周口",
            "驻马店",
            "济源"
        ]
    },
    {
        "p": "湖北",
        "c": [
            "武汉",
            "黄石",
            "十堰",
            "宜昌",
            "襄樊",
            "鄂州",
            "荆门",
            "孝感",
            "荆州",
            "黄冈",
            "咸宁",
            "随州",
            "恩施",
            "仙桃",
            "潜江",
            "天门",
            "神农架"
        ]
    },
    {
        "p": "湖南",
        "c": [
            "长沙",
            "株洲",
            "湘潭",
            "衡阳",
            "邵阳",
            "岳阳",
            "常德",
            "张家界",
            "益阳",
            "郴州",
            "永州",
            "怀化",
            "娄底",
            "湘西"
        ]
    },
    {
        "p": "广东",
        "c": [
            "广州",
            "韶关",
            "深圳",
            "珠海",
            "汕头",
            "佛山",
            "江门",
            "湛江",
            "茂名",
            "肇庆",
            "惠州",
            "梅州",
            "汕尾",
            "河源",
            "阳江",
            "清远",
            "东莞",
            "中山",
            "潮州",
            "揭阳",
            "云浮"
        ]
    },
    {
        "p": "广西",
        "c": [
            "南宁",
            "柳州",
            "桂林",
            "梧州",
            "北海",
            "防城港",
            "钦州",
            "贵港",
            "玉林",
            "百色",
            "贺州",
            "河池",
            "来宾",
            "崇左"
        ]
    },
    {
        "p": "海南",
        "c": [
            "海口",
            "三亚",
            "五指山",
            "琼海",
            "儋州",
            "文昌",
            "万宁",
            "东方"
        ]
    },
    {
        "p": "四川",
        "c": [
            "成都",
            "自贡",
            "攀枝花",
            "泸州",
            "德阳",
            "绵阳",
            "广元",
            "遂宁",
            "内江",
            "乐山",
            "南充",
            "眉山",
            "宜宾",
            "广安",
            "达川",
            "雅安",
            "巴中",
            "资阳",
            "阿坝",
            "甘孜",
            "凉山"
        ]
    },
    {
        "p": "贵州",
        "c": [
            "贵阳",
            "六盘水",
            "遵义",
            "安顺",
            "铜仁",
            "黔西南",
            "毕节",
            "黔东南",
            "黔南"
        ]
    },
    {
        "p": "云南",
        "c": [
            "昆明",
            "曲靖",
            "玉溪",
            "保山",
            "昭通",
            "丽江",
            "普洱",
            "临沧",
            "楚雄",
            "红河",
            "文山",
            "西双版纳",
            "大理",
            "德宏",
            "怒江傈",
            "迪庆"
        ]
    },
    {
        "p": "西藏",
        "c": [
            "拉萨",
            "昌都",
            "山南",
            "日喀则",
            "那曲",
            "阿里",
            "林芝"
        ]
    },
    {
        "p": "陕西",
        "c": [
            "西安",
            "铜川",
            "宝鸡",
            "咸阳",
            "渭南",
            "延安",
            "汉中",
            "榆林",
            "安康",
            "商洛"
        ]
    },
    {
        "p": "甘肃",
        "c": [
            "兰州",
            "嘉峪关",
            "金昌",
            "白银",
            "天水",
            "武威",
            "张掖",
            "平凉",
            "酒泉",
            "庆阳",
            "定西",
            "陇南",
            "临夏",
            "甘南"
        ]
    },
    {
        "p": "青海",
        "c": [
            "西宁",
            "海东",
            "海北",
            "黄南",
            "海南",
            "果洛",
            "玉树",
            "梅西"
        ]
    },
    {
        "p": "宁夏",
        "c": [
            "银川",
            "石嘴山",
            "吴忠",
            "固原",
            "中卫"
        ]
    },
    {
        "p": "新疆",
        "c": [
            "乌鲁木齐",
            "克拉玛依",
            "吐鲁番",
            "哈密",
            "昌吉",
            "博尔塔拉",
            "巴音郭楞",
            "阿克苏",
            "克孜勒苏",
            "喀什",
            "和田",
            "伊犁",
            "塔城",
            "阿勒泰",
            "石河子",
            "阿拉尔",
            "图木舒克",
            "五家渠"
        ]
    },
    {
        "p": "地区",
        "c": [
            "香港",
            "澳门",
            "台湾"
        ]
    }
];
const config = {
    '北京': { code: '010', info: '北京联通' },
    '上海': { code: '021', info: '上海联通' },
    '江苏': { code: '025', info: '南京联通' },
    '海南': { code: '0898', info: '海口联通' },
    '广西': { code: '0771', info: '南宁联通' },
    '青海': { code: '0971', info: '西宁联通' },
    '陕西': { code: '029', info: '西安联通' },
    '甘肃': { code: '0931', info: '兰州联通' },
    '宁夏': { code: '0954', info: '固原联通' },
    '云南': { code: '0871', info: '昆明联通' },
    '四川': { code: '023', info: '重庆联通' },
    '重庆': { code: '023', info: '重庆联通' },
    '广东': { code: '020', info: '广州联通' },
    '湖北': { code: '027', info: '武汉联通' },
    '安徽': { code: '0551', info: '合肥联通' },
    '浙江': { code: '0571', info: '杭州联通' },
    '福建': { code: '0591', info: '福州联通' },
    '江西': { code: '0791', info: '南昌联通' },
	// '辽宁': { code: '024', info: '沈阳联通' },
	//'天津': { code: '022', info: '天津联通' },
};

module.exports = function area(province, city) {
    var p
    if (city) {
        p = findProvince(city)
        if (p) {
            province = p
        } else {
            if (!province) province = randomProvince()
        }
    }
    let code = config[province] ? config[province].code : config[randomProvince()].code;

    console.log(province, city, code)
    return code
}


function findProvince(city) {
    if (['北京', '上海', '天津', '重庆'].indexOf(city) > -1) return city
    const p = _.find(mapping, (o) => {
        return _.includes(o.c, city)
    })
    
    return p ? p.p : ''
}

function randomProvince() {
    let p = Object.keys(config)
    return p[_.random(0, p.length - 1)]
}

if (!module.parent) {
    console.log(findProvince('深圳'))
    console.log(findProvince('纽约'))
    console.log(findProvince('上海'))
    console.log(randomProvince())
}
