require('colors');
require('app-module-path/register');
const api = require('./utils/api');
const config = require('config');
const Koa = require('koa');
const compress = require('koa-compress');
const koaBody = require('koa-body');
const cors = require('kcors');
const bodyParser = require('koa-bodyparser');
const logger = require('koa-logger');
const path = require('path');
const mongoose = require('mongoose');
const error = require('middleware/error');
const jwt = require('middleware/jwt');
const mountRoutes = require('utils/mount-routes');
// const { uploadFile } = require('utils/upload');
const fs = require('fs');
var crypto = require('crypto');
global.Promise = mongoose.Promise = require('bluebird');

const Router = require('koa-router');
const multer = require('koa-multer');
const AGENT_BUCKET = 'remarketing-agent';
const Minio = require('minio');
const websockify = require('koa-websocket');
const { createAuto } = require('controllers/clue');



const app = websockify(new Koa());

app.ws.use(createAuto);



const file = `
      <h1>upload demo</h1>
      <form method="POST" action="/upload" enctype="multipart/form-data">
        <p>file upload</p>
        <span>picName:</span><input name="picName" type="text" /><br/>
        <input name="license-pics" type="file" /><br/><br/>
        <button type="submit">submit</button>
      </form>`;

const bucket = 'open-api';

const minioClient = new Minio.Client({
  endPoint: 'minio.xiaoyun.com',
  port: 80,
  useSSL: false,
  accessKey: 'D1CSX8QB0BTCDRTSK32E',
  secretKey: 'GV/4BEPn7GQcbxHYD4X2mIIVpXhFPywxsHJRxdgT'
});

const storage = multer.diskStorage({
  destination: function (req, file, cb) {
    cb(null, path.join(__dirname, './public/uploads'))
  },
  filename: function (req, file, cb) {
    cb(null, `${file.fieldname}-${Date.now()}.png`)
  }
})

const licensePic = multer({ storage: storage }).single('license-pics')

function createBucketAndUpload(bucketName, objectName, filePath) {
    console.dir(arguments);
    minioClient.bucketExists(bucketName, function(err, exists) {
        if (err) {
            return console.log(err)
        }

        if (exists)  {
            console.log(bucketName, objectName, filePath);
            return uploadToMinio(bucketName, objectName, filePath);
        }

        // Make a bucket called remarketing-agent.
        minioClient.makeBucket(bucketName, 'us-east-1', function(err) {
            if (err) return console.log(err)

            console.log('Bucket created successfully in "us-east-1".')

            uploadToMinio(bucketName, objectName, filePath);
        });

    });
}

function uploadToMinio(bucketName, objectName, filePath) {
    // Using fPutObject API upload your file to the bucket remarketing-agent.
    minioClient.fPutObject(bucketName, objectName, filePath, { 'Content-Type': 'application/octet-stream' }, function(err, etag) {
        if (err) return console.log(err)
        console.log(`${objectName} uploaded successfully.`)
    });
}

function downloadFromMinio(bucketName, objectName, filePath) {
    if (fs.existsSync(filePath)) return console.log(`${objectName} exists`)
    minioClient.fGetObject(bucketName, objectName, filePath, function(err) {
        if (err) {
            return console.log(err)
        }
        console.log(`${objectName} download success`)
    })
}


const router = new Router();

/*// /home
router.get('/', async (ctx, next) => {
	 const _content = fs.readFileSync(
        path.resolve(__dirname, 'dist/' + 'index.html'),
        'binary'
    );
    ctx.res.writeHead(200)
    ctx.res.write(_content, 'binary')
    ctx.res.end();
})
*/

router.get('/upload/demo', ctx => {
    ctx.body = file;
});

router.post('/upload', licensePic, async (ctx, next) => {
  createBucketAndUpload(bucket, ctx.req.file.filename, ctx.req.file.path);
  //return res.send({ status: 'ok', file: `static/uploads/${req.file.filename}` });
  ctx.body = {
    filename: ctx.req.file.filename  //返回文件名 
  }
})

router.get('/file/:name', async(ctx, next) => {
    //const filePath = path.join(__dirname, `./public/uploads/${ctx.params.name}`);
    let stream =  await minioClient.getObject(bucket, ctx.params.name);
    ctx.type = 'jpg';
    ctx.body = stream;
});

app.use(cors());
app.use(router.routes());
app.use(logger());

app.use(error());

app.use(require('koa-static')(__dirname + '/dist'))
app.use(jwt());

app.use(bodyParser({}));
app.use(mountRoutes().routes());
const { PORT = 8080 } = process.env;
app.listen(PORT, () => {
    console.log(`server start at ${PORT}`);
});


process.on('unhandledRejection', (err, promise) => {
    console.error('Unhandled rejection (promise: ', promise, ', reason: ', err, ').');
});