const connect = require('../connect');
const mongoose = require('mongoose');
const {
    ObjectId
} = mongoose.SchemaTypes;

const schema = mongoose.Schema({
    unikey: String,
    province: {
        name: String,
        code: String,
     },
    city: {
        name: String,
        code: String,
    },
    url: String,
    repoId: { type: ObjectId, ref: 'repo' },
    repoCode: String,
    source: {
        name: String,
        code: String,
    },
    sellRecord: Array,
    undoRecord: Array,
    logs: Array,
    filename: String,
    operatorId: { type: ObjectId, ref: 'user' },
}, {
    timestamps: true
})

module.exports = connect.stockDb.model('unikey', schema);