const mongoose = require('mongoose');
const connect = require('../connect');
const {
    ObjectId
} = mongoose.SchemaTypes;

const schema = mongoose.Schema({
    account: {
        type: ObjectId,
        required: true,
        ref: 'account'
    },
    user: {
        type: ObjectId,
        required: true,
        ref: 'user'
    },
    order: {           // 基础订单
        type: ObjectId,
        required: true,
        ref: 'order'
    },
    count: {           // 数量
        type: Number,
        required: false
    },
    group: {           // 基础画像
        type: ObjectId,
        required: true,
        ref: 'group'
    },
    tags:[String],
    retrive: {
        type: Boolean
    },
    retriveDate: {
        type: Date
    },
    meta: String
}, {
    timestamps: true
});

module.exports = connect.db.model('order_production', schema);