const mongoose = require('mongoose');
const connect = require('../connect');
const moment = require('moment');
const generateCode = require('utils/generate-code');
const {
    ObjectId
} = mongoose.SchemaTypes;
const counter = require('db/mongo/open/counter');

const schema = mongoose.Schema({
    account: {
        type: ObjectId,
        required: true,
        ref: 'account'
    },
    user: {
        type: ObjectId,
        required: true,
        ref: 'user'
    },
    code: {         // 订单编号
        type: String,
        required: true
    },
    meta: String,   // 备注
    origin: {       // 补量订单父级来源
        type: ObjectId,
        ref: 'order',
        required: false
    },
    awardCount: Number,  // 需要补数线索数
    type: {
        type: String,
        required: true,
        enum: ['data', 'media', 'msg', 'record', 'imei']   //  数据 自媒体 短信 话单 imei
    },
    award: {                                       //  补量订单
        type: Boolean,
        default: false
    },
    count: {                                       // 预购数量
        type: Number,
        required: true
    },
    clue: {                                        // 返回 发送 线索数量
        type: Number,
        required: false,
        default: 0
    },
    group: {        // 数据画像
        type: ObjectId,
        required: false,
        ref: 'group'
    },
    subOrder: [{   // 拆分订单
        type: ObjectId,
        ref: 'order_production'
    }],
    status: {      // 数据 当前状态 进展
        type: String,
        required: true,
        enum: ['审核中', '执行中', '已关闭', '已拒绝']
    },
    meta: String,
    check: Boolean,
    checkDate: Date,
    history:[{     // 生产历史
       date: Date,
       operator: String,
       status: String
    }]
}, {
    timestamps: true
});
schema.index({ createdAt: -1 });
schema.index({ order: -1 });
schema.index({ type: -1 });

schema.pre('save', function (next) {
    const doc = this;
    let date = moment().format('YYYYMMDD');
    let map = {
        'data': 'OD',
        'msg': 'OM',
        'record': 'OR',
        'imei': 'OI'
    }
    let suffix = ((map[doc.type] || 'U') + date);
    if(!doc.isNew) next();
    else
        counter.findOneAndUpdate({ type: 'order' + date  }, { $inc: { seq: 1 } }, { upsert: 1 },  function(error, counter) {
            if(error)
            return next(error);
            doc.code = suffix + (counter && counter.seq ? generateCode(3, counter.seq) : '000'); 
            next();
        }) 
});

module.exports = connect.db.model('order', schema);