const jwt = require('jsonwebtoken');
const config = require('config');
const hash = require('utils/hash');
const tools = require('utils/tools');
const _ = require('lodash');
const api = require('utils/api');
const mongoose = require('mongoose');
const clueContrl = require('./clue');
const groupContrl = require('./group');
const Clue = require('db/mongo/open/clue');
const CallTask = require('db/mongo/open/calltask');
const cache = require('./cache');
//const callTaskContrl = require('./callTask');
const HOST = config.HOST;
const STAMP = 1000 * 60;
const {
    ObjectId
} =  require('mongoose').Types;
const areaCode = require('utils/area');
const INFINITE = 1000000000;
async function unbindWhenCall( phone ) {
    let calltasks = await CallTask.find({ caller: phone + '', result: { $exists: false } }, null, {
        skip: 0,
        limit: INFINITE
    });
    console.log('拨打前解绑：*******' +  calltasks.length)
    if(!calltasks.length) return;
    for( let calltask of calltasks ) {
        let { bindID, _id } = calltask;
        let rep = await api({
            method: 'GET',
            url: HOST + '/unbinding',
            qs: {
               bindID
            },
            json: true
        });

        console.log(rep)
        if((rep && rep.status === 'ok') || rep.msg === 'already unbinded') {
            let callTaskObj = await CallTask.findOneAndUpdate({ _id }, { $set: {
                updateTime: Date.now(),
                duration: 0,
                url: null,
                result: 'OTHER',
                minutes: 0,
                trigger: 'beforecall',
                status: 2
            }}, { new: true }) 

            console.dir(`准备回调`);
            let account = await cache.openAccountCache(callTaskObj.account);
            console.dir(account);
            console.dir(`获取host`)
            let host = account && account.calltaskNotityUrl ? account.calltaskNotityUrl : null;
            console.dir(`host:${host}`);
            if(host) {
                await api({
                    method: 'POST',
                    url: host,
                    body: callTaskObj,
                    json: true
                });
            }
        }
    }
    console.log('拨打前解绑结束：*******' )
    return;
}

async function unbind() {
    console.dir('自动解绑任务')
    let calltasks = await CallTask.find({ startTime: { $lt: Date.now() - 1000 * 60 * 30 }, result: { $exists: false } }, null, {
        skip: 0,
        limit: INFINITE
    });
    console.dir(calltasks ? calltasks.length : 0 + '个解绑任务');
    for( let calltask of calltasks ) {
        let { bindID, _id } = calltask;
        let rep = await api({
            method: 'GET',
            url: HOST + '/unbinding',
            qs: {
               bindID
            },
            json: true
        });
        console.log('auto unbinding job result')
        console.log(rep)
        if((rep && rep.status === 'ok') || rep.msg === 'already unbinded') {
            let callTaskObj = await CallTask.findOneAndUpdate({ _id }, { $set: {
                updateTime: Date.now(),
                duration: 0,
                url: null,
                result: 'OTHER',
                minutes: 0,
                trigger: 'cron',
                status: 2
            }}, { new: true }) 

            console.dir(`准备回调`);
            let account = await cache.openAccountCache(callTaskObj.account);
            console.dir(account);
            console.dir(`获取host`)
            let host = account && account.calltaskNotityUrl ? account.calltaskNotityUrl : null;
            console.dir(`host:${host}`);
            if(host) {
                await api({
                    method: 'POST',
                    url: host,
                    body: callTaskObj,
                    json: true
                });
            }
        }

    }
}

console.dir(process.env.NODE_ENV);
if(process.env.NODE_ENV == 'production')
setInterval(async () => {
    await unbind();
}, STAMP);

// 获取订单列表
exports.bind = async (ctx, next) => {
    let {
        clue,
        caller,
        callback_data
    } = ctx.request.body;
    console.dir(ctx.request.body)
    let clueObj = await clueContrl.findByCode(clue);
    ctx.assert(clueObj && clueObj.account + '' === ctx.state.user._id + '', 500, '参数错误，clue', {
        code: 1
    });
    ctx.assert(/^1(3|4|5|7|8|9)\d{9}$/.test(caller), 500, '参数错误，caller', {
        code: 1
    });

    let { unikey, from: operator, province, city, account, type: clueType, _id, user } = clueObj;
    await unbindWhenCall(caller + '');
    let provinceCode = areaCode(province, city);
    try {
        let rep = await api({
            method: 'POST',
            url: HOST + '/binding',
            body: {
                caller: caller + '',
                unikey: unikey,
                province: provinceCode,
                operator
            },
            json: true
        });
        console.dir(rep);
        let { bindID, volan } = rep; 
        console.dir('请求绑定成功' + caller ); 
        let callTask = await new CallTask({ clueType, user, callback_data, from: operator, bindID, unikey, caller, called: volan, account, clue: _id, account, startTime: Date.now() }).save();
        await Clue.updateOne({
            _id
        }, {
            $push: {
                calledHistory: callTask._id
            }
        });
        console.dir('初始化话单成功' + caller ); 
        ctx.body = {
            status: 'ok',
            data: callTask
        }
    } catch( error ) {
        console.dir(error);
        ctx.assert(!error, 500, '运营商拒绝服务', {
            code: 1
        });
    }
}

exports.list = async (ctx, next) => {
    let {
        skip=0,
        limit=10,
        clue,
        callback_data,
        caller,
        start,
        bindID,
        end 
    } = ctx.request.body;
    let account = ctx.state.user;
    skip = parseInt(skip);
    limit = parseInt(limit);
    ctx.assert(!isNaN(skip), 500, '参数错误，skip', {
        code: 1
    });
    ctx.assert(!isNaN(limit), 500, '参数错误，limit', {
        code: 1
    });
    ctx.assert(limit <= 500, 500, '参数错误，limit <= 500', {
        code: 1
    });
    if(start || end) {
      ctx.assert(/^\d{8}$/.test(start) && /^\d{8}$/.test(end), 500, '参数错误，start end', {
        code: 1
      });
    }

    let conditions = tools.generateDateQuery(start, end);
    conditions.account = account._id;

    if(clue) conditions.clue = clue;
    if(callback_data) conditions.callback_data = callback_data;
    if(bindID) {
        conditions.bindID = bindID;
    }
    if(caller) conditions.caller = caller;
    let calltasks = await CallTask.find(conditions, null, {
        skip,
        limit
    });
    let total = await CallTask.count(conditions);
    ctx.body = {
        status: 'ok',
        result: {
            calltasks,
            total,
            skip
        }
    }
}