const jwt = require('jsonwebtoken');
const config = require('config');
const hash = require('utils/hash');

const OpenAccount = require('db/mongo/open/account');
const _ = require('lodash');
const NodeCache = require('node-cache');
const mongoose = require('mongoose');
const {
    ObjectId
} =  require('mongoose').Types;

const rmkCache = new NodeCache();

exports.openAccountCache = async(openAccount) => {
  let temp = openAccount + '';
  if(rmkCache.get(temp)) return rmkCache.get(temp);
  else {
      let obj = await OpenAccount.findById(temp);
      let info = (obj ? obj.toJSON() : null);
      rmkCache.set(temp, obj);
      return obj;
  }
}