const jwt = require('jsonwebtoken');
const config = require('config');
const hash = require('utils/hash');
const tools = require('utils/tools');
const _ = require('lodash');
const mongoose = require('mongoose');
const Account = require('db/mongo/open/account');
const {
    ObjectId
} =  require('mongoose').Types;

function getToken(user, opt = {}) {
    if (!opt.expiresIn) {
        opt.expiresIn = '7d';
    }
    return jwt.sign(
        user,
        config.JWT_SECRET,
        opt
    );
}

exports.session = async (ctx, next) => {
    let {
        zyxKey,
        zyxSecret 
    } = ctx.request.body;

    let tokenObj = await Account.findOne({
        zyxKey,
        removed: { $ne: true }
    });
    ctx.assert(tokenObj, 404, 'zyxKey 不存在，请联系客服', {
        code: 1
    });
    ctx.assert(
        hash(zyxSecret) === tokenObj.zyxSecret,
        500,
        'zyxSecret错误', {
            code: 1
        }
    );
    let session = getToken(_.pick(tokenObj, '_id','zyxKey', 'zyxSecret'));
    ctx.body = {
        status: 'ok',
        result: {
            session
        }
    }
}

// 开通开放账户
exports.account = async (ctx, next) => {
    let {
        zyxKey,
        zyxSecret,
        company='',
        phone='',
        nickname='',
        calltaskNotityUrl='',
        orderNotifyUrl=''
    } = ctx.request.body;
    let account = await new Account({
        zyxKey,
        zyxSecret,
        company,
        phone,
        nickname,
        calltaskNotityUrl,
        orderNotifyUrl
    }).save();
    ctx.body = {
        status: 'ok',
        result: {
            account
        }
    }
}

exports.auth = async(ctx, next) => {
    let user = ctx.state.user;
    ctx.assert(
        user,
        401,
        '认证错误', {
            code: 1
        }
    );
    await next();
}


