const jwt = require('jsonwebtoken');
const config = require('config');
const hash = require('utils/hash');
const tools = require('utils/tools');
const _ = require('lodash');
const mongoose = require('mongoose');
const User = require('db/mongo/open/user');
const Order = require('db/mongo/open/order');
const {
    ObjectId
} =  require('mongoose').Types;

// 获取用户
exports.list = async (ctx, next) => {
    let {
        skip=0,
        limit=10,
    } = ctx.request.body;

    skip = parseInt(skip);
    limit = parseInt(limit);

    ctx.assert(!isNaN(skip), 500, '参数错误，skip', {
        code: 1
    });
    ctx.assert(!isNaN(limit), 500, '参数错误，limit', {
        code: 1
    });
    ctx.assert(limit <= 500, 500, '参数错误，limit <= 500', {
        code: 1
    });

    let conditions = { removed : {$ne: true }, account: ctx.state.user._id };
    let users = await User.find(conditions, null, {
        skip,
        limit
    });
    let total = await User.count(conditions);
    ctx.body = {
        status: 'ok',
        result: {
            users,
            total,
            skip
        }
    }
}

exports.remove = async (ctx, next) => {
    let {
        user
    } = ctx.request.body;

    ctx.assert(tools.valid(user), 500, '参数错误，user', {
        code: 1
    });


    let userObj = await User.findById(user);
    ctx.assert(userObj && userObj.account + '' === ctx.state.user._id + '', 401, '权限错误', {
        code: 1
    });

    let order= await Order.findOne({ user });
    ctx.assert(!order, 400, '该用户存在订单不能删除，user', {
        code: 1
    });

    let _user = await User.updateOne({ _id: user }, { $set: { removed: true } });

    ctx.body = {
        status: 'ok'
    }
}


//备案用户
exports.create = async (ctx, next) => {
    let {
        licenses,
        company,
        name,
        phone,
        report
    } = ctx.request.body;

    ctx.assert(licenses && Array.isArray(licenses) && licenses.length , 500, '参数错误，licenses', {
        code: 1
    });
    ctx.assert(company , 500, '参数错误，company', {
        code: 1
    });
    ctx.assert(report , 500, '参数错误，report', {
        code: 1
    });


    let user = await new User({
        licenses,
        company,
        name,
        phone,
        report,
        account: ctx.state.user._id  
    }).save();
    
    ctx.body = {
        status: 'ok',
        result: {
            user
        }
    }
}
