const jwt = require('jsonwebtoken');
const config = require('config');
const hash = require('utils/hash');
const tools = require('utils/tools');
const _ = require('lodash');
const mongoose = require('mongoose');
const Group = require('db/mongo/open/group');
const User = require('db/mongo/open/user');
const {
    ObjectId
} =  require('mongoose').Types;

exports.findById = async(group) => {
    return await Group.findById(group);
}

// 获取画像列表
exports.list = async (ctx, next) => {
    let {
        skip=0,
        limit=10,
        start,
        end,
        user 
    } = ctx.request.body;

    let account = ctx.state.user;
    skip = parseInt(skip);
    limit = parseInt(limit);
    ctx.assert(!isNaN(skip), 500, '参数错误，skip', {
        code: 1
    });
    ctx.assert(!isNaN(limit), 500, '参数错误，limit', {
        code: 1
    });
    if(start || end) {
      ctx.assert(/^\d{8}$/.test(start) && /^\d{8}$/.test(end), 500, '参数错误，start end', {
        code: 1
      });
    }

    let conditions = tools.generateDateQuery(start, end);

    if(user) {
        ctx.assert(tools.valid(user), 500, '参数错误，user', {
            code: 1
        });
        let userObj = await User.findById(user);
        ctx.assert(userObj && userObj.account + '' === ctx.state.user._id + '', 500, '参数错误，user', {
            code: 1
        });
        conditions.user = user;
    }

    conditions.account = account._id;
    let groups = await Group.find(conditions, null, {
        skip,
        limit
    });
    let total = await Group.count(conditions);

    ctx.body = {
        status: 'ok',
        result: {
            groups,
            total,
            skip
        }
    }
}

//创建画像
exports.create = async (ctx, next) => {
    let {
        name,
        hosts,
        sex,
        age,
        province,
        city,
        user
    } = ctx.request.body;
    ctx.assert(hosts && Array.isArray(hosts) && hosts.length, 500, '参数错误，hosts', {
        code: 1
    });
    ctx.assert(name && name.length, 500, '参数错误，name', {
        code: 1
    });

    ctx.assert(ctx.state.user._id , 401, '权限错误', {
        code: 1
    });

    let data = {
        name,
        hosts,
        user,
        account: ctx.state.user._id
    };

    if(user) {
        ctx.assert(tools.valid(user), 500, '参数错误，user', {
            code: 1
        });
        let userObj = await User.findById(user);
        ctx.assert(userObj && userObj.account + '' === ctx.state.user._id + '', 500, '参数错误，user', {
            code: 1
        });
        data.user = user;
    }

    if(province) {
        ctx.assert(province && Array.isArray(province) && province.length, 500, '参数错误，province', {
            code: 1
        });
        data.province = province;
    }

    if(city) {
        ctx.assert(city && Array.isArray(city) && city.length, 500, '参数错误，city', {
            code: 1
        });
        data.city = city;
    }

    if(sex){
        ctx.assert(sex && Array.isArray(sex) && sex.length, 500, '参数错误，sex', {
            code: 1
        });
        data.sex = sex;
    }
    
    if(age){
        ctx.assert(age && Array.isArray(age) && age.length, 500, '参数错误，age', {
            code: 1
        });
        data.age = age;
    }
    let group = await new Group(data).save();
    ctx.body = {
        status: 'ok',
        result: {
            group
        }
    }
}
