const connect = require('../connect');
const mongoose = require('mongoose');
const {
    ObjectId
} = mongoose.SchemaTypes;

const schema = mongoose.Schema({
    username: {
        type: String,
        unique: true,
        required: true,
    },
    email: {
        type: String,
        unique: true,
    },
    password: {
        type: String,
        required: true,
    },
    role: Number,
    creator: { type: ObjectId, ref: 'user' },
}, {
    timestamps: true
})

module.exports = connect.stockDb.model('user', schema);