const hash = require('utils/hash');
const mongoose = require('mongoose');
const connect = require('../connect');
const {
    ObjectId
} = mongoose.SchemaTypes;

const schema = mongoose.Schema({
    zyxKey: {
        type: String,
        unique: true,
        required: true
    },
    zyxSecret: {
        type: String,
        required: true,
        set: v => hash(v)
    },
    callTaskUrl: String,
    clueTaskUrl: String,
    nickname: String,
    meta: String,
    company: String,
    phone: Number,
    calltaskNotityUrl: String,
    orderNotifyUrl: String
}, {
    timestamps: true
});

module.exports = connect.db.model('account', schema);