const jwt = require('jsonwebtoken');
const config = require('config');
const hash = require('utils/hash');
const tools = require('utils/tools');
const _ = require('lodash');
const api = require('utils/api');
const mongoose = require('mongoose');
const groupContrl = require('./group');
const orderContrl = require('./order');
const Order = require('db/mongo/open/order');
const OrderProduction = require('db/mongo/open/order_production');
const Clue = require('db/mongo/open/clue');
const User = require('db/mongo/open/user');
const Lock = require('db/mongo/open/lock');
const Unikey = require('db/mongo/stock/unikey');
const UnikeyOut = require('db/mongo/stock/unikeyout');
const {
    ObjectId
} =  require('mongoose').Types;

function getFrom (source) {
    if(source.indexOf('联通') >= 0) return 'cucc' ;
    if(source.indexOf('电信') >= 0) return 'ctcc' ;
    if(source.indexOf('移动') >= 0) return 'cmcc' ;
}

/*(async function() {
    let ss = await Clue.find({},null, {
        skip: 0,
        limit: 10000000
    });
    console.dir(ss.length);
    for (let o of ss) {
       let { _id, host } = o;
       console.dir( hash(host));
       let d = await Clue.update({_id }, { $set: { virtualHost: hash(host) }});
       console.dir(d);
       // await
    }
})();*/

// 获取线索列表
exports.list = async (ctx, next) => {
    let {
        skip=0,
        limit=10,
        group,
        order,
        user,
        production,
        start,
        end,
        id
    } = ctx.request.body;
    let account = ctx.state.user;
    skip = parseInt(skip);
    limit = parseInt(limit);
    ctx.assert(!isNaN(skip), 500, '参数错误，skip', {
        code: 1
    });
    ctx.assert(!isNaN(limit), 500, '参数错误，limit', {
        code: 1
    });
    ctx.assert(limit <= 500, 500, '参数错误，limit <= 500', {
        code: 1
    });
    if(start || end) {
      ctx.assert(/^\d{8}$/.test(start) && /^\d{8}$/.test(end), 500, '参数错误，start end', {
        code: 1
      });
    }
    let conditions = tools.generateDateQuery(start, end);
    conditions.account = account._id;

    if(user) {
        ctx.assert(tools.valid(user), 500, '参数错误，user', {
            code: 1
        });
        let userObj = await User.findById(user);
        ctx.assert(userObj && userObj.account + '' === ctx.state.user._id + '', 500, '参数错误，user', {
            code: 1
        });
        conditions.user = user;
    }

    if(id) {
        ctx.assert(id, 500, '参数错误，id', {
            code: 1
        });
        conditions._id = id;
    }

    if(order) {
        let orderObj = await Order.findById(order);
        ctx.assert(orderObj, 500, '参数错误，order', {
            code: 1
        });
        conditions.order = order;
    }
    if(production) {
       let pObj = await OrderProduction.findById(production);
        ctx.assert(pObj, 500, '参数错误，production', {
            code: 1
        });
        conditions.subOrder = production; 
    }
    if(group) {
        let groupObj = await groupContrl.findById(group);
        ctx.assert(groupObj, 500, '参数错误，group', {
            code: 1
        });
        conditions.group = group;
    }
    let clues = await Clue.find(conditions, null, {
        skip,
        limit
    });
    let total = await Clue.count(conditions);
    ctx.body = {
        status: 'ok',
        result: {
            clues:  (clues || []).map(clue => _.pick(clue, ['account', 'user',  'code', 'type', 'from', 'group', 'sex', 'age', 'city', 'province', 'virtualHost', 'lastCall', 'order', 'subOrder', 'lastCall', 'calledHistory', '_id'])),
            total,
            skip
        }
    }
}

exports.findByCode = async(code) => {
    return await Clue.findOne({
        code 
    })
}



exports.createAuto = async(ctx, next) => {

    async function unbind() {
        ctx.websocket.send(JSON.stringify({ type: 'info', message: `解除数据库锁定`}));
        await Lock.update({ type: 'order_production'}, { $set: { status: false} });
        ctx.websocket.send(JSON.stringify({ type: 'info', message: `解除数据库锁定成功`}));
    }

    try {
        ctx.websocket.on('message', async function(message) {
            let { order } = JSON.parse(message);
            //let order = "5c8f3f30189f42000721d983";
            if(!tools.valid(order)) {
                ctx.websocket.send(JSON.stringify({ type: 'warning', message: '订单ID 格式错误' }));
                await unbind();
                return next(ctx);
            }
            let lock = await Lock.findOne({ type: 'order_production' });
            if(!lock || lock.status) {
                ctx.websocket.send(JSON.stringify({ type: 'warning', message: '当前有未完成操作，稍后再执行' }));
                await unbind();
                return next(ctx);
            }
            ctx.websocket.send(JSON.stringify({ type: 'info',message: '准备锁定数据库' }));
            let r = await Lock.update({ type: 'order_production', status: true });
            ctx.websocket.send(JSON.stringify({ type: 'info',message: '数据库锁定成功' }));
            let orderObj = await Order.findById(order).populate({ 
                path: "group",
                select: "name hosts province city age sex",
            }).populate({ path:'user', select: 'company name' }).populate({ path:'account', select: 'orderNotifyUrl company' });

            if(!orderObj)  {
                ctx.websocket.send(JSON.stringify({ type: 'warning', message: '订单不存在' }));
                await unbind();
                return next(ctx);
            }
            console.dir(orderObj.toJSON());
            let { status, data, group, account, award, code, user } = orderObj;
            /*if(award) {
                ctx.websocket.send(JSON.stringify({ type: 'warning', message: '补量订单不支持自动录入' }));
                await unbind();
                return next(ctx);
            }*/
            if(status === '已结束') {
                ctx.websocket.send(JSON.stringify({ type: 'warning', message: '订单状态错误' + orderObj.status }));
                await unbind();
                return next(ctx);
            }

            let count = await Clue.count({ order });
         
            if(orderObj.count <= count )  {
                ctx.websocket.send(JSON.stringify({ type: 'warning', message: '订单返数已满' }));
                await unbind();
                return next(ctx);
            }
            let need = orderObj.count - count;
            if(!group) {
                ctx.websocket.send(JSON.stringify({ type: 'warning', message: '订单画像状态错误' }));
                await unbind();
                return next(ctx);
            }
            ctx.websocket.send(JSON.stringify({ type: 'info', message: `订单还需要${need}条数据`}));
            ctx.websocket.send(JSON.stringify({ type: 'info', message: `开始匹配`}));
            let { sex, age, province, city, hosts } = group;

            if(!hosts.length) {
                ctx.websocket.send(JSON.stringify({ type: 'warning', message: `没有可以匹配的规则`}));
                await unbind();
                return next(ctx);
            }
            ctx.websocket.send(JSON.stringify({ type: 'info', message: `规则排序成功，共${hosts.length}条url`}));
            ctx.websocket.send(JSON.stringify({ type: 'info', message: hosts }));
            ctx.websocket.send(JSON.stringify({ type: 'info', message: `准备匹配行业仓数据，按顺序循环获取匹配数据`}));
            let todoUnikeys = [];
            for(let url of hosts) {
                ctx.websocket.send(JSON.stringify({ type: 'info', message: `准备匹配url： ${url}`}));

                let res = await getRepoUnikeys({
                    "size": need,
                    "page": 1,
                    "citys": [],
                    "provinces": [],
                    "account": user._id,
                    "url": [url],
                    "exactMatch": true
                }); 

                if(res.status == 'ok') {
                    let repoUnikeys = res.result;
                    ctx.websocket.send(JSON.stringify({ type: 'info', message: `匹配${url}成功，共${repoUnikeys.length}条数据`}));
                    todoUnikeys = todoUnikeys.concat(repoUnikeys);
                    ctx.websocket.send(JSON.stringify({ type: 'info', message: `累计匹配${todoUnikeys.length}条数据`}));
                    if(need <= todoUnikeys.length) {
                        ctx.websocket.send(JSON.stringify({ type: 'info', message: `匹配数据已满足需求数据，跳出循环`}));
                        break;
                    }
                } else {
                  ctx.websocket.send(JSON.stringify({ type: 'warning', message: res.msg || '行业仓匹配失败' }));
                  await unbind();
                  return next(ctx);  
                }
            }
            if(!todoUnikeys.length) {
                ctx.websocket.send(JSON.stringify({ type: 'warning', message:  '行业仓没有匹配到数据' }));
                //ctx.websocket.send(JSON.stringify({ type: 'warning', '行业仓没有匹配到数据' }));
                await unbind();
                return next(ctx);  
            }
            if(need <= todoUnikeys.length) todoUnikeys = todoUnikeys.slice(0,need);
            ctx.websocket.send(JSON.stringify({ type: 'info', message: `准备录入数据`}));
            let unikeys = todoUnikeys.map( x => x.unikey );

            let unikeyCount = await Clue.count({ user: user._id, unikey: { $in: unikeys }, retrive: { $ne: true } });
            ctx.websocket.send(JSON.stringify({ type: 'info', message: `准备进行数据排重`}));
            if(unikeyCount > 0) {
                ctx.websocket.send(JSON.stringify({ type: 'warning', message:  '获取unikey重复,请联系管理员' }));
                await unbind();
                return next(ctx);
            } 
            ctx.websocket.send(JSON.stringify({ type: 'info', message: `数据排重成功`}));
            ctx.websocket.send(JSON.stringify({ type: 'info', message: `准备进行数据画像映射`}));
            let clueObjs = [];
            for(clue of todoUnikeys) {
                let { city: { name: cityName }, province: { name: provinceName }, unikey, url, source } = clue;
                if(!source || !url) {
                    ctx.websocket.send(JSON.stringify({ type: 'warning', message:  `${unikey}数据仓格式错误,请联系管理员`}));
                    await unbind();
                    return next(ctx);
                }
                let obj = {
                        account: account._id,
                        user: user._id,
                        city: cityName,
                        province: provinceName,
                        unikey,
                        type: 'group',
                        from: getFrom(source.name),
                        group: orderObj.group._id,
                        order
                };
                obj['host'] = url;
                obj['virtualHost'] = hash(url);
                clueObjs.push(obj);
        };
        ctx.websocket.send(JSON.stringify({ type: 'info', message: `数据画像映射成功`}));
        ctx.websocket.send(JSON.stringify({ type: 'info', message: `准备创建子订单`}));
        let sub = await new OrderProduction({ account: account._id, user: user._id, order, group: group._id, count: 0 }).save();
        ctx.websocket.send(JSON.stringify({ type: 'info', message: `创建子订单成功`}));
        for(clue of clueObjs) {
            await new Clue(_.merge(clue, {  subOrder: sub._id, code: 'G'  })).save(); 
            ctx.websocket.send(JSON.stringify({ type: 'info', message: `插入线索${clue.unikey}成功`}));
        }
        ctx.websocket.send(JSON.stringify({ type: 'info', message: `插入全部线索成功，共计${clueObjs.length}条线索`}));
        ctx.websocket.send(JSON.stringify({ type: 'info', message: `准备修改订单状态（状态和返数信息）和子订单状态（返数信息）`}));
        sub.count = clueObjs.length;
        orderObj.subOrder = ( orderObj.subOrder || []).concat([ sub._id ]);
        orderObj.clue = await Clue.count({ order });
        let archiveDate = new Date();
        if(orderObj.status == '审核中') {
            orderObj.status = '执行中',
            orderObj.history = orderObj.history.concat([{
                status: '执行中',
                operator: '',
                date: archiveDate
            }])
        }
        if(orderObj.clue === orderObj.count) {
            ctx.websocket.send(JSON.stringify({ type: 'info', message: `订单返数已满,关闭订单`}));
            orderObj.status = '已关闭',
            orderObj.history = orderObj.history.concat([{
                status: '已关闭',
                operator: '',
                date: archiveDate
            }])
        }
        await orderObj.save();
        ctx.websocket.send(JSON.stringify({ type: 'info', message: `订单状态修改成功`}));
        await sub.save();
        ctx.websocket.send(JSON.stringify({ type: 'info', message: `子订单状态修改成功`}));
        ctx.websocket.send(JSON.stringify({ type: 'info', message: `准备修改行业仓售出信息`}));
        let accountObj =  {
            "_id" : user._id + '',
            "username" : user.company,
            "code" : user._id,
            "company" : user.company,
            "openaccount": account._id
        }
        await Unikey.updateMany({ unikey: { $in: unikeys }}, {
            $push: {
                sellRecord: {
                    "orderId" : order,
                    "orderCode" : code,
                    "subOrderID" : sub._id + '',
                    "account" : accountObj
                }
            }
        });
        let unikeyouts = todoUnikeys.map( x => {
            return {
                "orderId" : order,
                "orderCode" : code,
                "subOrderID" : sub._id + '',
                "unikeyId" : x._id,
                "account" : accountObj
            }
        });
        await UnikeyOut.insertMany(unikeyouts);
        ctx.websocket.send(JSON.stringify({ type: 'info', message: `行业仓售出信息修改完毕`}));
        if(account && account.orderNotifyUrl) {
            ctx.websocket.send(JSON.stringify({ type: 'info', message: `回调开放合作伙伴api`}));
            let rs = await notify(account.orderNotifyUrl, {
                subOrder: sub._id,
                clue: unikeyouts.length,
                order: orderObj
            })
            console.dir(rs);
        }
        await unbind();
        return next(ctx);
     });
    } catch(e) {
        console.dir(e);
        ctx.websocket.send(JSON.stringify({ type: 'error', message: e }));
    } finally {
        //return next(ctx);
    }
}

async function getRepoUnikeys(data) {
    return await api({
        method: 'POST',
        url: 'http://stock.xiaoyun.com/api/external/stock',
        body: data,
        json: true
    });
}

async function notify(url, data) {
    return await api({
        method: 'POST',
        url,
        body: data,
        json: true
    });
}


//录入数据
exports.create = async (ctx, next) => {
    let {
        order,
        subOrder
    } = ctx.request.body;
    ctx.body = {
        status: 'ok',
        result: {
            order
        }
    }
}
