/* 话单 处理   */
const mongoose = require('mongoose');
const connect = require('../connect');
const {
    ObjectId
} = mongoose.SchemaTypes;

const schema = mongoose.Schema({
    unikey: {
        type: String,
        required: true
    },
    bindID: {                       // 绑定ID
        type: String,
        required: true
    },
    caller: {                       // 主叫号
        type: Number,
        required: true,
    },
    callback_data: String,
    called: {                       // 被叫号
        type: Number,
        required: true,
    },
    account: {                      // 账户
        type: ObjectId,
        required: true,
        ref: 'account'
    },
    user: {
        type: ObjectId,
        required: true,
        ref: 'user'
    },
    startTime: {                    // 开始时间
        type: Number,
        required: false,
    },
    updateTime: {                   // 结束时间
        type: Number,
        required: false,
    },
    duration:  {                    // 持续时间
        type: Number,
        required: false,
    },
    clue: {                         // 线索
        type: ObjectId,
        required: true,
        ref: 'clue'
    },
    from: {
        type: String,
        required: false,
    },
    clueType: {
        type: String,
        required: true,
        enum: ['group', 'slot']
    },
    expiration: {
        type: Number,
        required: false,
    }, 
    result: {                       // 通话结果
        type: String,
        required: false,
    },
    url: {                          // 通话录音
        type: String,
        required: false,
    },
    minutes: {                      // 持续时长 分钟
        type: Number,
        required: false,
    },
    archive: {                      // 归档标识
        type: Boolean
    },
    archiveDate: {                  // 归档日期
        type: Date
    }
}, {
    timestamps: true
});

schema.index({ caller: -1 });
schema.index({ bindID: -1 });


module.exports = connect.db.model('calltask', schema);