'use strict';

var express = require('express');
var router = express.Router();

var controller = require( '../lib/controller.js' );
var session = require( '../lib/session.js' );

router.get('/logs',controller.logs);
router.post('/agent',controller.putAgent);
router.post('/tbkl',controller.putTbkl);
router.post('/session',session.login);
router.get('/logout',session.logout);
router.post('/to_tbkl',controller.createTbkl); //系统生成淘口令
router.get('/tbkls',controller.getTbkls);
router.get('/links',controller.getLinks);
router.get('/qds',controller.getQds);
router.post('/qd',controller.createQd);
router.post('/newtkl',controller.newTbkl);

router.post('/link',controller.createLink);
router.get('/link/del/:link',controller.removeLink);

router.post('/put_data',controller.putGatherData);

router.post('/put_ip',controller.putIp);
router.post('/qd_update',controller.putQdUpdate);

//router.get('/details',controller.getDetails);

router.post('/tool_tbkls',controller.adminTbkl);
router.post('/tool2_tbkls',controller.admin2Tbkl);

router.get('/schedules',controller.getSchedules);
router.post('/schedule',controller.createSchedule);
router.get('/schedule/final',controller.updateScheduleFinal)
router.post('/schedule_update',controller.updateSchedule);
router.post('/schedule_auto_update',controller.updateAutoSchedule);
router.get('/gathers/qd',controller.getQdGatherData);
router.get('/gatherall',controller.getAllGatherData);
router.get('/ips',controller.getIps);

module.exports = router;