const mongoose = require('mongoose');
const hash = require('../../utils/hash');
const {ObjectId} = mongoose.SchemaTypes;

const schema = mongoose.Schema({
    user: {
        type: String,
        unique: true,
        required: true
    },
    password:{
        type: String,
        required: true,
        set: v => hash(v)
    },
    ipstatus:{
        type:String,
        required:false
    },
    iplimit:{
        type:Number,
        required:false
    },
    info:{
        type: String,
        unique: false 
    },
    role: {
        type: String,
        required: true
    }
}, {
    timestamps: true
});

schema.index({user: 1});
module.exports = mongoose.model('tao-agent', schema);
